/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.datamarts.master;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.terminal.Connector;
import io.intino.alexandria.terminal.StubConnector;
import io.intino.alexandria.zim.ZimStream;
import io.intino.cosmos.datahub.ObserverTerminal;
import io.intino.cosmos.datahub.datamarts.master.MasterDatamart;
import io.intino.cosmos.datahub.datamarts.master.MasterMounter;
import io.intino.cosmos.datahub.datamarts.master.entities.Appliance;
import io.intino.cosmos.datahub.datamarts.master.entities.Application;
import io.intino.cosmos.datahub.datamarts.master.entities.ApplicationJava;
import io.intino.cosmos.datahub.datamarts.master.entities.Area;
import io.intino.cosmos.datahub.datamarts.master.entities.Asset;
import io.intino.cosmos.datahub.datamarts.master.entities.Computer;
import io.intino.cosmos.datahub.datamarts.master.entities.Countermeasure;
import io.intino.cosmos.datahub.datamarts.master.entities.Hardware;
import io.intino.cosmos.datahub.datamarts.master.entities.IncidentRule;
import io.intino.cosmos.datahub.datamarts.master.entities.Model;
import io.intino.cosmos.datahub.datamarts.master.entities.Observable;
import io.intino.cosmos.datahub.datamarts.master.entities.Observer;
import io.intino.cosmos.datahub.datamarts.master.entities.OrderType;
import io.intino.cosmos.datahub.datamarts.master.entities.Part;
import io.intino.cosmos.datahub.datamarts.master.entities.Person;
import io.intino.cosmos.datahub.datamarts.master.entities.Place;
import io.intino.cosmos.datahub.datamarts.master.entities.Process;
import io.intino.cosmos.datahub.datamarts.master.entities.Service;
import io.intino.cosmos.datahub.datamarts.master.entities.Software;
import io.intino.cosmos.datahub.datamarts.master.mounters.ApplianceMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.ApplicationJavaMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.ApplicationMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.AreaMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.AssetMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.ComputerMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.CountermeasureMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.HardwareMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.IncidentRuleMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.ModelMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.ObserverMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.OrderTypeMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.PartMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.PersonMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.PlaceMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.ProcessMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.ServiceMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.SoftwareMounter;
import io.intino.ness.master.Datamart;
import io.intino.ness.master.model.Entity;
import io.intino.ness.master.reflection.AttributeDefinition;
import io.intino.ness.master.reflection.ConceptDefinition;
import io.intino.ness.master.reflection.DatamartDefinition;
import io.intino.ness.master.reflection.EntityDefinition;
import io.intino.ness.master.reflection.StructDefinition;
import io.intino.sumus.chronos.Group;
import io.intino.sumus.chronos.Period;
import io.intino.sumus.chronos.Reel;
import io.intino.sumus.chronos.ReelFile;
import io.intino.sumus.chronos.Shot;
import io.intino.sumus.chronos.State;
import io.intino.sumus.chronos.Timeline;
import io.intino.sumus.chronos.TimelineStore;
import jakarta.jms.BytesMessage;
import jakarta.jms.Message;
import jakarta.jms.TextMessage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.activemq.command.ActiveMQTextMessage;

public class MasterDatamartImpl
implements MasterDatamart {
    private static final String DATAHUB_MESSAGE_TOPIC = "service.ness.datamarts";
    private static final MasterDatamartDefinition definition = new MasterDatamartDefinition();
    private static final Set<String> TIMELINE_EVENTS = Set.of("Analysis", "ComputerAssertion", "Computer", "Switch", "ApplianceAssertion", "CellularGateway", "Wireless", "Camera", "ApplicationAssertion", "Application", "IncidentFinished", "Incident");
    private static final Set<String> REEL_EVENTS = Set.of("Status");
    private final Connector connector;
    private final ObserverTerminal.DatamartsRetryConfig retryConfig;
    private final List<Datamart.EntityListener> entityListeners = new ArrayList<Datamart.EntityListener>();
    private final Map<String, List<MasterMounter>> mounters = new HashMap<String, List<MasterMounter>>();
    private final MasterDatamart.Entities entities;
    private Instant ts;
    private boolean hasLocalAccessToTimelines;
    private final Map<String, TimelineNodeImpl> timelines = new ConcurrentHashMap<String, TimelineNodeImpl>();
    private boolean hasLocalAccessToIndicators;
    private final Map<String, IndicatorNodeImpl> indicators = new ConcurrentHashMap<String, IndicatorNodeImpl>();
    private boolean hasLocalAccessToReels;
    private final Map<String, ReelNodeImpl> reels = new ConcurrentHashMap<String, ReelNodeImpl>();
    private volatile DictionaryImpl dictionary = new DictionaryImpl();
    private volatile boolean initializing = false;

    public MasterDatamartImpl(Connector connector, ObserverTerminal.DatamartsRetryConfig retryConfig) {
        this.connector = Objects.requireNonNull(connector);
        this.retryConfig = Objects.requireNonNull(retryConfig);
        this.entities = new MasterDatamart.Entities(this);
        this.initMounters();
    }

    public synchronized MasterDatamartImpl init(String datamartSourceSelector) {
        try {
            this.initializing = true;
            this.downloadDatamartFromDatahub(datamartSourceSelector);
            Logger.info("MasterDatamart (" + (String)(this.snapshotTimetag().isEmpty() ? "" : "snapshot " + this.snapshotTimetag() + ", ") + this.connector.clientId() + ") initialized successfully.");
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError("MasterDatamart failed to start because a " + e.getClass().getName() + " occurred: " + e.getMessage());
        }
        finally {
            this.initializing = false;
        }
        return this;
    }

    public boolean requiresDatahubNotifications() {
        return true;
    }

    @Override
    public int size() {
        return this.entities.size();
    }

    @Override
    public int sizeDisabled() {
        return this.entities.sizeDisabled();
    }

    @Override
    public <T extends Entity> T get(String id) {
        return (T)this.entities.get(id);
    }

    @Override
    public Stream<Entity> entities() {
        return this.entities.streamGeneric();
    }

    @Override
    public void addEntityListener(Datamart.EntityListener listener) {
        if (listener == null) {
            throw new NullPointerException("EntityListener cannot be null");
        }
        this.entityListeners.add(listener);
    }

    @Override
    public DatamartDefinition getDefinition() {
        return definition;
    }

    @Override
    public List<String> listSnapshots() {
        try {
            Message message = this.requestResponseFromDatahub("listSnapshots", this.listSnapshotsRequest());
            if (!message.getBooleanProperty("success")) {
                throw new Exception(((TextMessage)message).getText());
            }
            return this.handleListSnapshotsResponse(message);
        }
        catch (Exception e) {
            Logger.error("Could not download list of available snapshots: " + e.getMessage(), e);
            return Collections.emptyList();
        }
    }

    private Message listSnapshotsRequest() throws Exception {
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setText("datamart=" + this.name() + ";operation=snapshots");
        return message;
    }

    private List<String> handleListSnapshotsResponse(Message message) throws Exception {
        return Arrays.stream(((TextMessage)message).getText().split(",")).collect(Collectors.toList());
    }

    @Override
    public synchronized MasterDatamart snapshot(final String timetag) {
        if (timetag == null) {
            return this;
        }
        return new MasterDatamartImpl(this, this.connector, this.retryConfig){

            @Override
            protected String snapshotTimetag() {
                return timetag;
            }

            @Override
            public synchronized MasterDatamart snapshot(String timetag2) {
                throw new UnsupportedOperationException("Cannot request snapshots to snapshot instances of a datamart");
            }
        }.init(null);
    }

    public Instant ts() {
        return this.ts;
    }

    @Override
    public Place place(String id) {
        return id == null ? null : (Place)this.entities.get(MasterDatamartImpl.definition.placeEntityDefinition, id);
    }

    @Override
    public Place placeDisabled(String id) {
        return id == null ? null : (Place)this.entities.getDisabled(MasterDatamartImpl.definition.placeEntityDefinition, id);
    }

    @Override
    public Stream<Place> places() {
        return this.entities.stream(MasterDatamartImpl.definition.placeEntityDefinition);
    }

    @Override
    public Stream<Place> placesDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.placeEntityDefinition);
    }

    @Override
    public Area area(String id) {
        return id == null ? null : (Area)this.entities.get(MasterDatamartImpl.definition.areaEntityDefinition, id);
    }

    @Override
    public Area areaDisabled(String id) {
        return id == null ? null : (Area)this.entities.getDisabled(MasterDatamartImpl.definition.areaEntityDefinition, id);
    }

    @Override
    public Stream<Area> areas() {
        return this.entities.stream(MasterDatamartImpl.definition.areaEntityDefinition);
    }

    @Override
    public Stream<Area> areasDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.areaEntityDefinition);
    }

    @Override
    public IncidentRule incidentRule(String id) {
        return id == null ? null : (IncidentRule)this.entities.get(MasterDatamartImpl.definition.incidentRuleEntityDefinition, id);
    }

    @Override
    public IncidentRule incidentRuleDisabled(String id) {
        return id == null ? null : (IncidentRule)this.entities.getDisabled(MasterDatamartImpl.definition.incidentRuleEntityDefinition, id);
    }

    @Override
    public Stream<IncidentRule> incidentRules() {
        return this.entities.stream(MasterDatamartImpl.definition.incidentRuleEntityDefinition);
    }

    @Override
    public Stream<IncidentRule> incidentRulesDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.incidentRuleEntityDefinition);
    }

    @Override
    public Countermeasure countermeasure(String id) {
        return id == null ? null : (Countermeasure)this.entities.get(MasterDatamartImpl.definition.countermeasureEntityDefinition, id);
    }

    @Override
    public Countermeasure countermeasureDisabled(String id) {
        return id == null ? null : (Countermeasure)this.entities.getDisabled(MasterDatamartImpl.definition.countermeasureEntityDefinition, id);
    }

    @Override
    public Stream<Countermeasure> countermeasures() {
        return this.entities.stream(MasterDatamartImpl.definition.countermeasureEntityDefinition);
    }

    @Override
    public Stream<Countermeasure> countermeasuresDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.countermeasureEntityDefinition);
    }

    @Override
    public Model model(String id) {
        return id == null ? null : (Model)this.entities.get(MasterDatamartImpl.definition.modelEntityDefinition, id);
    }

    @Override
    public Model modelDisabled(String id) {
        return id == null ? null : (Model)this.entities.getDisabled(MasterDatamartImpl.definition.modelEntityDefinition, id);
    }

    @Override
    public Stream<Model> models() {
        return this.entities.stream(MasterDatamartImpl.definition.modelEntityDefinition);
    }

    @Override
    public Stream<Model> modelsDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.modelEntityDefinition);
    }

    @Override
    public OrderType orderType(String id) {
        return id == null ? null : (OrderType)this.entities.get(MasterDatamartImpl.definition.orderTypeEntityDefinition, id);
    }

    @Override
    public OrderType orderTypeDisabled(String id) {
        return id == null ? null : (OrderType)this.entities.getDisabled(MasterDatamartImpl.definition.orderTypeEntityDefinition, id);
    }

    @Override
    public Stream<OrderType> orderTypes() {
        return this.entities.stream(MasterDatamartImpl.definition.orderTypeEntityDefinition);
    }

    @Override
    public Stream<OrderType> orderTypesDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.orderTypeEntityDefinition);
    }

    @Override
    public Observable observable(String id) {
        return id == null ? null : (Observable)this.entities.getDescendant(MasterDatamartImpl.definition.observableEntityDefinition, id);
    }

    @Override
    public Observable observableDisabled(String id) {
        return id == null ? null : (Observable)this.entities.getDescendantDisabled(MasterDatamartImpl.definition.observableEntityDefinition, id);
    }

    @Override
    public Stream<Observable> observables() {
        return Stream.of(this.persons(), this.processes(), this.assets(), this.parts(), this.hardwares(), this.softwares()).flatMap(Function.identity());
    }

    @Override
    public Stream<Observable> observablesDisabled() {
        return Stream.of(this.personsDisabled(), this.processesDisabled(), this.assetsDisabled(), this.partsDisabled(), this.hardwaresDisabled(), this.softwaresDisabled()).flatMap(Function.identity());
    }

    @Override
    public Person person(String id) {
        return id == null ? null : (Person)this.entities.get(MasterDatamartImpl.definition.personEntityDefinition, id);
    }

    @Override
    public Person personDisabled(String id) {
        return id == null ? null : (Person)this.entities.getDisabled(MasterDatamartImpl.definition.personEntityDefinition, id);
    }

    @Override
    public Stream<Person> persons() {
        return this.entities.stream(MasterDatamartImpl.definition.personEntityDefinition);
    }

    @Override
    public Stream<Person> personsDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.personEntityDefinition);
    }

    @Override
    public Process process(String id) {
        return id == null ? null : (Process)this.entities.get(MasterDatamartImpl.definition.processEntityDefinition, id);
    }

    @Override
    public Process processDisabled(String id) {
        return id == null ? null : (Process)this.entities.getDisabled(MasterDatamartImpl.definition.processEntityDefinition, id);
    }

    @Override
    public Stream<Process> processes() {
        return this.entities.stream(MasterDatamartImpl.definition.processEntityDefinition);
    }

    @Override
    public Stream<Process> processesDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.processEntityDefinition);
    }

    @Override
    public Asset asset(String id) {
        return id == null ? null : (Asset)this.entities.get(MasterDatamartImpl.definition.assetEntityDefinition, id);
    }

    @Override
    public Asset assetDisabled(String id) {
        return id == null ? null : (Asset)this.entities.getDisabled(MasterDatamartImpl.definition.assetEntityDefinition, id);
    }

    @Override
    public Stream<Asset> assets() {
        return this.entities.stream(MasterDatamartImpl.definition.assetEntityDefinition);
    }

    @Override
    public Stream<Asset> assetsDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.assetEntityDefinition);
    }

    @Override
    public Part part(String id) {
        return id == null ? null : (Part)this.entities.get(MasterDatamartImpl.definition.partEntityDefinition, id);
    }

    @Override
    public Part partDisabled(String id) {
        return id == null ? null : (Part)this.entities.getDisabled(MasterDatamartImpl.definition.partEntityDefinition, id);
    }

    @Override
    public Stream<Part> parts() {
        return this.entities.stream(MasterDatamartImpl.definition.partEntityDefinition);
    }

    @Override
    public Stream<Part> partsDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.partEntityDefinition);
    }

    @Override
    public Hardware hardware(String id) {
        return id == null ? null : (Hardware)this.entities.getDescendant(MasterDatamartImpl.definition.hardwareEntityDefinition, id);
    }

    @Override
    public Hardware hardwareDisabled(String id) {
        return id == null ? null : (Hardware)this.entities.getDescendantDisabled(MasterDatamartImpl.definition.hardwareEntityDefinition, id);
    }

    @Override
    public Stream<Hardware> hardwares() {
        return Stream.of(this.entities.stream(MasterDatamartImpl.definition.hardwareEntityDefinition), this.appliances(), this.computers()).flatMap(Function.identity());
    }

    @Override
    public Stream<Hardware> hardwaresDisabled() {
        return Stream.of(this.entities.streamDisabled(MasterDatamartImpl.definition.hardwareEntityDefinition), this.appliancesDisabled(), this.computersDisabled()).flatMap(Function.identity());
    }

    @Override
    public Appliance appliance(String id) {
        return id == null ? null : (Appliance)this.entities.get(MasterDatamartImpl.definition.applianceEntityDefinition, id);
    }

    @Override
    public Appliance applianceDisabled(String id) {
        return id == null ? null : (Appliance)this.entities.getDisabled(MasterDatamartImpl.definition.applianceEntityDefinition, id);
    }

    @Override
    public Stream<Appliance> appliances() {
        return this.entities.stream(MasterDatamartImpl.definition.applianceEntityDefinition);
    }

    @Override
    public Stream<Appliance> appliancesDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.applianceEntityDefinition);
    }

    @Override
    public Computer computer(String id) {
        return id == null ? null : (Computer)this.entities.get(MasterDatamartImpl.definition.computerEntityDefinition, id);
    }

    @Override
    public Computer computerDisabled(String id) {
        return id == null ? null : (Computer)this.entities.getDisabled(MasterDatamartImpl.definition.computerEntityDefinition, id);
    }

    @Override
    public Stream<Computer> computers() {
        return this.entities.stream(MasterDatamartImpl.definition.computerEntityDefinition);
    }

    @Override
    public Stream<Computer> computersDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.computerEntityDefinition);
    }

    @Override
    public Software software(String id) {
        return id == null ? null : (Software)this.entities.getDescendant(MasterDatamartImpl.definition.softwareEntityDefinition, id);
    }

    @Override
    public Software softwareDisabled(String id) {
        return id == null ? null : (Software)this.entities.getDescendantDisabled(MasterDatamartImpl.definition.softwareEntityDefinition, id);
    }

    @Override
    public Stream<Software> softwares() {
        return Stream.of(this.entities.stream(MasterDatamartImpl.definition.softwareEntityDefinition), this.observers(), this.services(), this.applications()).flatMap(Function.identity());
    }

    @Override
    public Stream<Software> softwaresDisabled() {
        return Stream.of(this.entities.streamDisabled(MasterDatamartImpl.definition.softwareEntityDefinition), this.observersDisabled(), this.servicesDisabled(), this.applicationsDisabled()).flatMap(Function.identity());
    }

    @Override
    public Observer observer(String id) {
        return id == null ? null : (Observer)this.entities.get(MasterDatamartImpl.definition.observerEntityDefinition, id);
    }

    @Override
    public Observer observerDisabled(String id) {
        return id == null ? null : (Observer)this.entities.getDisabled(MasterDatamartImpl.definition.observerEntityDefinition, id);
    }

    @Override
    public Stream<Observer> observers() {
        return this.entities.stream(MasterDatamartImpl.definition.observerEntityDefinition);
    }

    @Override
    public Stream<Observer> observersDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.observerEntityDefinition);
    }

    @Override
    public Service service(String id) {
        return id == null ? null : (Service)this.entities.get(MasterDatamartImpl.definition.serviceEntityDefinition, id);
    }

    @Override
    public Service serviceDisabled(String id) {
        return id == null ? null : (Service)this.entities.getDisabled(MasterDatamartImpl.definition.serviceEntityDefinition, id);
    }

    @Override
    public Stream<Service> services() {
        return this.entities.stream(MasterDatamartImpl.definition.serviceEntityDefinition);
    }

    @Override
    public Stream<Service> servicesDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.serviceEntityDefinition);
    }

    @Override
    public Application application(String id) {
        return id == null ? null : (Application)this.entities.getDescendant(MasterDatamartImpl.definition.applicationEntityDefinition, id);
    }

    @Override
    public Application applicationDisabled(String id) {
        return id == null ? null : (Application)this.entities.getDescendantDisabled(MasterDatamartImpl.definition.applicationEntityDefinition, id);
    }

    @Override
    public Stream<Application> applications() {
        return Stream.of(this.entities.stream(MasterDatamartImpl.definition.applicationEntityDefinition), this.applicationJavas()).flatMap(Function.identity());
    }

    @Override
    public Stream<Application> applicationsDisabled() {
        return Stream.of(this.entities.streamDisabled(MasterDatamartImpl.definition.applicationEntityDefinition), this.applicationJavasDisabled()).flatMap(Function.identity());
    }

    @Override
    public ApplicationJava applicationJava(String id) {
        return id == null ? null : (ApplicationJava)this.entities.get(MasterDatamartImpl.definition.applicationJavaEntityDefinition, id);
    }

    @Override
    public ApplicationJava applicationJavaDisabled(String id) {
        return id == null ? null : (ApplicationJava)this.entities.getDisabled(MasterDatamartImpl.definition.applicationJavaEntityDefinition, id);
    }

    @Override
    public Stream<ApplicationJava> applicationJavas() {
        return this.entities.stream(MasterDatamartImpl.definition.applicationJavaEntityDefinition);
    }

    @Override
    public Stream<ApplicationJava> applicationJavasDisabled() {
        return this.entities.streamDisabled(MasterDatamartImpl.definition.applicationJavaEntityDefinition);
    }

    @Override
    public Stream<MasterDatamart.TimelineNode> timelines(String id) {
        Stream<MasterDatamart.TimelineNode> stream = this.timelines.values().stream().filter(t2 -> t2.id.equals(id)).toList().stream();
        return stream;
    }

    @Override
    public MasterDatamart.TimelineNode analysisTimeline(String id) {
        String key = id.replace(":", "-") + ":Analysis";
        if (this.timelines.containsKey(key)) {
            return this.timelines.get(key);
        }
        if (!this.hasLocalAccessToTimelines) {
            return this.timelines.computeIfAbsent(key, theId -> new TimelineNodeImpl(id, "Analysis"));
        }
        return MasterDatamart.TimelineNode.empty();
    }

    @Override
    public MasterDatamart.TimelineNode computerTimeline(String id) {
        String key = id.replace(":", "-") + ":Computer";
        if (this.timelines.containsKey(key)) {
            return this.timelines.get(key);
        }
        if (!this.hasLocalAccessToTimelines) {
            return this.timelines.computeIfAbsent(key, theId -> new TimelineNodeImpl(id, "Computer"));
        }
        return MasterDatamart.TimelineNode.empty();
    }

    @Override
    public MasterDatamart.TimelineNode switchTimeline(String id) {
        String key = id.replace(":", "-") + ":Switch";
        if (this.timelines.containsKey(key)) {
            return this.timelines.get(key);
        }
        if (!this.hasLocalAccessToTimelines) {
            return this.timelines.computeIfAbsent(key, theId -> new TimelineNodeImpl(id, "Switch"));
        }
        return MasterDatamart.TimelineNode.empty();
    }

    @Override
    public MasterDatamart.TimelineNode cellularGatewayTimeline(String id) {
        String key = id.replace(":", "-") + ":CellularGateway";
        if (this.timelines.containsKey(key)) {
            return this.timelines.get(key);
        }
        if (!this.hasLocalAccessToTimelines) {
            return this.timelines.computeIfAbsent(key, theId -> new TimelineNodeImpl(id, "CellularGateway"));
        }
        return MasterDatamart.TimelineNode.empty();
    }

    @Override
    public MasterDatamart.TimelineNode wirelessTimeline(String id) {
        String key = id.replace(":", "-") + ":Wireless";
        if (this.timelines.containsKey(key)) {
            return this.timelines.get(key);
        }
        if (!this.hasLocalAccessToTimelines) {
            return this.timelines.computeIfAbsent(key, theId -> new TimelineNodeImpl(id, "Wireless"));
        }
        return MasterDatamart.TimelineNode.empty();
    }

    @Override
    public MasterDatamart.TimelineNode cameraTimeline(String id) {
        String key = id.replace(":", "-") + ":Camera";
        if (this.timelines.containsKey(key)) {
            return this.timelines.get(key);
        }
        if (!this.hasLocalAccessToTimelines) {
            return this.timelines.computeIfAbsent(key, theId -> new TimelineNodeImpl(id, "Camera"));
        }
        return MasterDatamart.TimelineNode.empty();
    }

    @Override
    public MasterDatamart.TimelineNode applicationTimeline(String id) {
        String key = id.replace(":", "-") + ":Application";
        if (this.timelines.containsKey(key)) {
            return this.timelines.get(key);
        }
        if (!this.hasLocalAccessToTimelines) {
            return this.timelines.computeIfAbsent(key, theId -> new TimelineNodeImpl(id, "Application"));
        }
        return MasterDatamart.TimelineNode.empty();
    }

    @Override
    public MasterDatamart.TimelineNode incidentsTimeline(String id) {
        String key = id.replace(":", "-") + ":incidents";
        if (this.timelines.containsKey(key)) {
            return this.timelines.get(key);
        }
        if (!this.hasLocalAccessToTimelines) {
            return this.timelines.computeIfAbsent(key, theId -> new TimelineNodeImpl(id, "incidents"));
        }
        return MasterDatamart.TimelineNode.empty();
    }

    @Override
    public Stream<MasterDatamart.ReelNode> reels(String id) {
        Stream<MasterDatamart.ReelNode> stream = this.reels.values().stream().filter(r -> r.id.equals(id)).toList().stream();
        return stream;
    }

    @Override
    public MasterDatamart.ReelNode statusReel(String id) {
        String key = id.replace(":", "-") + ":Status";
        if (this.reels.containsKey(key)) {
            return this.reels.get(key);
        }
        if (!this.hasLocalAccessToReels) {
            return this.reels.computeIfAbsent(key, theId -> new ReelNodeImpl(id, "Status"));
        }
        return MasterDatamart.ReelNode.empty();
    }

    @Override
    public Stream<MasterDatamart.ReelNode> statusReels() {
        Stream<MasterDatamart.ReelNode> stream = this.reels.values().stream().filter(r -> r.type.equals("Status")).toList().stream();
        return stream;
    }

    @Override
    public MasterDatamart.IndicatorNode pendingIncidentsIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("incidents.pendingIncidents") ? (MasterDatamart.IndicatorNode)this.indicators.get("incidents.pendingIncidents") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("incidents.pendingIncidents", theId -> new IndicatorNodeImpl("incidents.pendingIncidents", null));
    }

    @Override
    public MasterDatamart.IndicatorNode incidentFinishedTimeIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("incidents.incidentFinishedTime") ? (MasterDatamart.IndicatorNode)this.indicators.get("incidents.incidentFinishedTime") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("incidents.incidentFinishedTime", theId -> new IndicatorNodeImpl("incidents.incidentFinishedTime", null));
    }

    @Override
    public MasterDatamart.IndicatorNode availabilityIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Analysis.availability") ? (MasterDatamart.IndicatorNode)this.indicators.get("Analysis.availability") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Analysis.availability", theId -> new IndicatorNodeImpl("Analysis.availability", null));
    }

    @Override
    public MasterDatamart.IndicatorNode healthIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Analysis.health") ? (MasterDatamart.IndicatorNode)this.indicators.get("Analysis.health") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Analysis.health", theId -> new IndicatorNodeImpl("Analysis.health", null));
    }

    @Override
    public MasterDatamart.IndicatorNode riskIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Analysis.risk") ? (MasterDatamart.IndicatorNode)this.indicators.get("Analysis.risk") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Analysis.risk", theId -> new IndicatorNodeImpl("Analysis.risk", null));
    }

    @Override
    public MasterDatamart.IndicatorNode usageRAMIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Computer.usageRAM") ? (MasterDatamart.IndicatorNode)this.indicators.get("Computer.usageRAM") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Computer.usageRAM", theId -> new IndicatorNodeImpl("Computer.usageRAM", null));
    }

    @Override
    public MasterDatamart.IndicatorNode usageHDDIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Computer.usageHDD") ? (MasterDatamart.IndicatorNode)this.indicators.get("Computer.usageHDD") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Computer.usageHDD", theId -> new IndicatorNodeImpl("Computer.usageHDD", null));
    }

    @Override
    public MasterDatamart.IndicatorNode usageCPUIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Computer.usageCPU") ? (MasterDatamart.IndicatorNode)this.indicators.get("Computer.usageCPU") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Computer.usageCPU", theId -> new IndicatorNodeImpl("Computer.usageCPU", null));
    }

    @Override
    public MasterDatamart.IndicatorNode usageSystemIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Computer.usageSystem") ? (MasterDatamart.IndicatorNode)this.indicators.get("Computer.usageSystem") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Computer.usageSystem", theId -> new IndicatorNodeImpl("Computer.usageSystem", null));
    }

    @Override
    public MasterDatamart.IndicatorNode usageThreadsIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Computer.usageThreads") ? (MasterDatamart.IndicatorNode)this.indicators.get("Computer.usageThreads") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Computer.usageThreads", theId -> new IndicatorNodeImpl("Computer.usageThreads", null));
    }

    @Override
    public MasterDatamart.IndicatorNode usageFilesIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Computer.usageFiles") ? (MasterDatamart.IndicatorNode)this.indicators.get("Computer.usageFiles") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Computer.usageFiles", theId -> new IndicatorNodeImpl("Computer.usageFiles", null));
    }

    @Override
    public MasterDatamart.IndicatorNode temperatureKernelIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Computer.temperatureKernel") ? (MasterDatamart.IndicatorNode)this.indicators.get("Computer.temperatureKernel") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Computer.temperatureKernel", theId -> new IndicatorNodeImpl("Computer.temperatureKernel", null));
    }

    @Override
    public MasterDatamart.IndicatorNode temperatureExternalIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Computer.temperatureExternal") ? (MasterDatamart.IndicatorNode)this.indicators.get("Computer.temperatureExternal") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Computer.temperatureExternal", theId -> new IndicatorNodeImpl("Computer.temperatureExternal", null));
    }

    @Override
    public MasterDatamart.IndicatorNode dataReceivedIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Computer.dataReceived") ? (MasterDatamart.IndicatorNode)this.indicators.get("Computer.dataReceived") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Computer.dataReceived", theId -> new IndicatorNodeImpl("Computer.dataReceived", null));
    }

    @Override
    public MasterDatamart.IndicatorNode dataSentIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Computer.dataSent") ? (MasterDatamart.IndicatorNode)this.indicators.get("Computer.dataSent") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Computer.dataSent", theId -> new IndicatorNodeImpl("Computer.dataSent", null));
    }

    @Override
    public MasterDatamart.IndicatorNode applicationsSystemIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Computer.applicationsSystem") ? (MasterDatamart.IndicatorNode)this.indicators.get("Computer.applicationsSystem") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Computer.applicationsSystem", theId -> new IndicatorNodeImpl("Computer.applicationsSystem", null));
    }

    @Override
    public MasterDatamart.IndicatorNode applicationsKnownIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Computer.applicationsKnown") ? (MasterDatamart.IndicatorNode)this.indicators.get("Computer.applicationsKnown") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Computer.applicationsKnown", theId -> new IndicatorNodeImpl("Computer.applicationsKnown", null));
    }

    @Override
    public MasterDatamart.IndicatorNode applicationsUnknownIndicator() {
        if (this.hasLocalAccessToIndicators) {
            return this.indicators.containsKey("Computer.applicationsUnknown") ? (MasterDatamart.IndicatorNode)this.indicators.get("Computer.applicationsUnknown") : MasterDatamart.IndicatorNode.empty();
        }
        return this.indicators.computeIfAbsent("Computer.applicationsUnknown", theId -> new IndicatorNodeImpl("Computer.applicationsUnknown", null));
    }

    @Override
    public Datamart.Dictionary dictionary() {
        return this.dictionary;
    }

    @Override
    public Datamart.Dictionary dictionary(String name) {
        if (name == null) {
            name = "";
        }
        if (this.dictionary.name.equals(name)) {
            return this.dictionary;
        }
        this.loadDictionaryFromDatahub(name);
        return this.dictionary;
    }

    private void downloadDatamartFromDatahub(String datamartSourceSelector) throws MasterDatamart.DatahubRequestException {
        if (this.connector instanceof StubConnector) {
            return;
        }
        Logger.debug("Downloading datamart from datahub...");
        long start = System.currentTimeMillis();
        Logger.debug("Downloading entities...");
        int[] eventCount = new int[1];
        this.loadEntitiesFromEvents(this.downloadEntities(eventCount, datamartSourceSelector), eventCount);
        this.loadTimelinesFromDatahub();
        this.loadIndicatorsFromDatahub();
        this.loadReelsFromDatahub();
        this.loadDictionaryFromDatahub("");
        long time = System.currentTimeMillis() - start;
        Logger.debug("Datamart downloaded from datahub after " + time + " ms");
    }

    private void loadTimelinesFromDatahub() {
        Logger.debug("Downloading timelines...");
        Boolean hasLocalAccessToTimelines = null;
        for (String filename : this.listTimelineFiles()) {
            if (filename == null || filename.isBlank()) continue;
            try {
                File file = new File(filename);
                String id = file.getName().replace(".timeline", "");
                String type = file.getParentFile().getName();
                TimelineNodeImpl node = new TimelineNodeImpl(id, type, file.exists() ? file : null);
                this.timelines.put(id + ":" + type, node);
                if (hasLocalAccessToTimelines == null) {
                    hasLocalAccessToTimelines = file.exists();
                    continue;
                }
                hasLocalAccessToTimelines = hasLocalAccessToTimelines & file.exists();
            }
            catch (Exception e) {
                Logger.debug("Could not load timeline " + filename + " -> " + e.getClass().getSimpleName() + ": " + e.getMessage());
            }
        }
        this.hasLocalAccessToTimelines = hasLocalAccessToTimelines != null && hasLocalAccessToTimelines != false;
        Logger.debug("Loaded " + this.timelines.size() + " timelines (hasLocalAccessToTimelines=" + this.hasLocalAccessToTimelines + ")");
    }

    private String[] listTimelineFiles() {
        try {
            ActiveMQTextMessage request = new ActiveMQTextMessage();
            request.setText("datamart=" + this.name() + ";operation=list-timelines;");
            Message message = this.requestResponseFromDatahub("list-timelines", request);
            if (!message.getBooleanProperty("success")) {
                throw new Exception(((TextMessage)message).getText());
            }
            return ((TextMessage)message).getText().split(",");
        }
        catch (Exception e) {
            Logger.error(e);
            return new String[0];
        }
    }

    private void loadIndicatorsFromDatahub() {
        Logger.debug("Downloading indicators...");
        Boolean hasLocalAccessToIndicators = null;
        for (String filename : this.listIndicatorFiles()) {
            if (filename == null || filename.isBlank()) continue;
            try {
                File file = new File(filename);
                String id = file.getName().replace(".indicator", "");
                IndicatorNodeImpl node = new IndicatorNodeImpl(id, file.exists() ? file : null);
                this.indicators.put(id, node);
                if (hasLocalAccessToIndicators == null) {
                    hasLocalAccessToIndicators = file.exists();
                    continue;
                }
                hasLocalAccessToIndicators = hasLocalAccessToIndicators & file.exists();
            }
            catch (Exception e) {
                Logger.debug("Could not load indicator " + filename + " -> " + e.getClass().getSimpleName() + ": " + e.getMessage());
            }
        }
        this.hasLocalAccessToIndicators = hasLocalAccessToIndicators != null && hasLocalAccessToIndicators != false;
        Logger.debug("Loaded " + this.indicators.size() + " indicators (hasLocalAccessToTimelines=" + this.hasLocalAccessToTimelines + ")");
    }

    private String[] listIndicatorFiles() {
        try {
            ActiveMQTextMessage request = new ActiveMQTextMessage();
            request.setText("datamart=" + this.name() + ";operation=list-indicators;");
            Message message = this.requestResponseFromDatahub("list-indicators", request);
            if (!message.getBooleanProperty("success")) {
                throw new Exception(((TextMessage)message).getText());
            }
            return ((TextMessage)message).getText().split(",");
        }
        catch (Exception e) {
            Logger.error(e);
            return new String[0];
        }
    }

    private void loadReelsFromDatahub() {
        Logger.debug("Downloading reels...");
        Boolean hasLocalAccessToReels = null;
        for (String filename : this.listReelFiles()) {
            if (filename == null || filename.isBlank()) continue;
            try {
                File file = new File(filename);
                String id = file.getName().replace(".reel", "");
                String type = file.getParentFile().getName();
                ReelNodeImpl node = new ReelNodeImpl(id, type, file.exists() ? file : null);
                this.reels.put(id + ":" + type, node);
                if (hasLocalAccessToReels == null) {
                    hasLocalAccessToReels = file.exists();
                    continue;
                }
                hasLocalAccessToReels = hasLocalAccessToReels & file.exists();
            }
            catch (Exception e) {
                Logger.debug("Could not load reel " + filename + " -> " + e.getClass().getSimpleName() + ": " + e.getMessage());
            }
        }
        this.hasLocalAccessToReels = hasLocalAccessToReels != null && hasLocalAccessToReels != false;
        Logger.debug("Loaded " + this.reels.size() + " reels");
    }

    private String[] listReelFiles() {
        try {
            ActiveMQTextMessage request = new ActiveMQTextMessage();
            request.setText("datamart=" + this.name() + ";operation=list-reels;");
            Message message = this.requestResponseFromDatahub("list-reels", request);
            if (!message.getBooleanProperty("success")) {
                throw new Exception(((TextMessage)message).getText());
            }
            return ((TextMessage)message).getText().split(",");
        }
        catch (Exception e) {
            Logger.error(e);
            return new String[0];
        }
    }

    private void loadDictionaryFromDatahub(String name) {
        String[][] entries;
        Logger.debug("Downloading dictionary...");
        HashMap<String, Map<String, String>> words = new HashMap<String, Map<String, String>>();
        for (String[] triplet : entries = this.dictionaryEntries(name)) {
            words.computeIfAbsent(triplet[0], k -> new HashMap(4)).put(triplet[1], triplet[2]);
        }
        this.dictionary = new DictionaryImpl(name, words);
        Logger.debug("Loaded dictionary " + name + " with " + words.size() + " words");
    }

    private String[][] dictionaryEntries(String name) {
        try {
            ActiveMQTextMessage request = new ActiveMQTextMessage();
            request.setText("datamart=" + this.name() + ";operation=get-dictionary;name=" + name);
            Message message = this.requestResponseFromDatahub("get-dictionary", request);
            if (message == null) {
                return new String[0][0];
            }
            if (!message.getBooleanProperty("success")) {
                throw new Exception(((TextMessage)message).getText());
            }
            String text = ((TextMessage)message).getText();
            if (text == null) {
                return new String[0][0];
            }
            return (String[][])Arrays.stream(text.split("\n")).filter(l -> !l.isBlank()).map(l -> l.trim().split("\t", -1)).filter(t2 -> ((String[])t2).length >= 3).toArray(x$0 -> new String[x$0][]);
        }
        catch (Exception e) {
            Logger.error(e);
            return new String[0][0];
        }
    }

    private Stream<Event> downloadEntities(int[] eventCount, String datamartSourceSelector) throws MasterDatamart.DatahubRequestException {
        try {
            Message message = this.requestResponseFromDatahub("downloadEvents", this.downloadEntitiesRequest(datamartSourceSelector));
            if (!message.getBooleanProperty("success")) {
                throw new Exception(((TextMessage)message).getText());
            }
            return this.handleDownloadResponse(message, eventCount);
        }
        catch (NullPointerException e) {
            throw new MasterDatamart.DatahubRequestException("Could not download datamart: no response from datahub.");
        }
        catch (MasterDatamart.DatahubRequestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MasterDatamart.DatahubRequestException("Could not download datamart: " + e.getMessage());
        }
    }

    private Message downloadEntitiesRequest(String datamartSourceSelector) throws Exception {
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setText("datamart=" + this.name() + ";operation=entities" + (String)(this.snapshotTimetag().isEmpty() ? "" : ";timetag=" + this.snapshotTimetag()) + (String)(datamartSourceSelector == null ? "" : ";sourceSelector=" + datamartSourceSelector));
        return message;
    }

    protected String snapshotTimetag() {
        return "";
    }

    private Stream<Event> handleDownloadResponse(Message message, int[] eventCount) throws Exception {
        BytesMessage m = (BytesMessage)message;
        eventCount[0] = m.getIntProperty("size");
        int size = m.getIntProperty("size");
        byte[] bytes = new byte[size];
        m.readBytes(bytes, size);
        return ZimStream.of(new ByteArrayInputStream(bytes)).map(MessageEvent::new);
    }

    private void loadEntitiesFromEvents(Stream<Event> events, int[] eventCount) {
        events.forEach(this::mount);
    }

    public synchronized void mount(Event event) {
        try {
            if (event == null) {
                return;
            }
            this.ts = event.ts();
            this.mountEntities(event);
        }
        catch (Throwable e) {
            Logger.error("Error while mounting event ss=" + event.ss() + ", ts=" + String.valueOf(event.ts()) + " -> " + e.getMessage(), e);
        }
    }

    public synchronized void handleDatahubNotification(String notification) {
        try {
            if (notification == null || notification.isBlank()) {
                return;
            }
            String[] typeAndSs = notification.split("\u0000");
            this.handleTimelineNotification(typeAndSs[0], typeAndSs[1]);
            this.handleReelNotification(typeAndSs[0], typeAndSs[1]);
        }
        catch (Throwable e) {
            Logger.error("Error while processing datahub notification " + notification + ": " + e.getMessage(), e);
        }
    }

    private void handleReelNotification(String type, String id) {
        if (!REEL_EVENTS.contains(type)) {
            return;
        }
        String key = id + ":" + type;
        ReelNodeImpl reel = this.reels.computeIfAbsent(id + ":" + type, k -> new ReelNodeImpl(id, type, null));
        reel.notifyChange();
    }

    private void handleTimelineNotification(String type, String id) {
        if (!TIMELINE_EVENTS.contains(type)) {
            return;
        }
        TimelineNodeImpl timeline = this.timelines.computeIfAbsent(id + ":" + type, k -> new TimelineNodeImpl(id, type, null));
        timeline.notifyChange();
    }

    private void mountEntities(Event event) {
        try {
            List<MasterMounter> mounters = this.mounters.get(event.type());
            if (mounters == null) {
                return;
            }
            mounters.forEach(mounter -> mounter.useListeners(!this.initializing).mount(event));
        }
        catch (Exception e) {
            Logger.error("Failed to mount event of type " + event.type() + ": " + e.getMessage(), e);
        }
    }

    private void initMounters() {
        this.mounters.computeIfAbsent("PlaceAssertion", type -> new ArrayList(1)).add(new PlaceMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("AreaAssertion", type -> new ArrayList(1)).add(new AreaMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("IncidentRuleAssertion", type -> new ArrayList(1)).add(new IncidentRuleMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("CountermeasureAssertion", type -> new ArrayList(1)).add(new CountermeasureMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ModelAssertion", type -> new ArrayList(1)).add(new ModelMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("OrderTypeAssertion", type -> new ArrayList(1)).add(new OrderTypeMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("PersonAssertion", type -> new ArrayList(1)).add(new PersonMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ProcessAssertion", type -> new ArrayList(1)).add(new ProcessMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("AssetAssertion", type -> new ArrayList(1)).add(new AssetMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("PartAssertion", type -> new ArrayList(1)).add(new PartMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("HardwareAssertion", type -> new ArrayList(1)).add(new HardwareMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ApplianceAssertion", type -> new ArrayList(1)).add(new ApplianceMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ComputerAssertion", type -> new ArrayList(1)).add(new ComputerMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("SoftwareAssertion", type -> new ArrayList(1)).add(new SoftwareMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ObserverAssertion", type -> new ArrayList(1)).add(new ObserverMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ServiceAssertion", type -> new ArrayList(1)).add(new ServiceMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ApplicationAssertion", type -> new ArrayList(1)).add(new ApplicationMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ApplicationJavaAssertion", type -> new ArrayList(1)).add(new ApplicationJavaMounter(this.entities, this.entityListeners));
    }

    private static int availableThreads() {
        return Runtime.getRuntime().availableProcessors();
    }

    private Message requestResponseFromDatahub(String requestName, Message request) throws MasterDatamart.DatahubRequestException {
        long timeout = this.retryConfig.initialTimeoutAmount;
        for (int i = 0; i < this.retryConfig.maxAttempts; ++i) {
            Message message = this.connector.requestResponse(DATAHUB_MESSAGE_TOPIC, request, timeout, this.retryConfig.timeoutUnit);
            if (message != null) {
                return message;
            }
            if (i < this.retryConfig.maxAttempts - 1) {
                Logger.warn("(" + (i + 1) + ") Datahub did not respond after " + timeout + " " + String.valueOf((Object)this.retryConfig.timeoutUnit) + " to the request '" + requestName + "'. Trying again...");
            }
            timeout = (long)((float)timeout * this.retryConfig.timeoutMultiplier);
        }
        throw new MasterDatamart.DatahubRequestException("Datahub did not respond to the request '" + requestName + "' after " + this.retryConfig.maxAttempts);
    }

    private static Set<String> sourcesOfTimeline(String type) {
        return switch (type) {
            case "Analysis" -> Set.of("Analysis");
            case "Computer" -> Set.of("Computer", "ComputerAssertion");
            case "Switch" -> Set.of("Switch", "ApplianceAssertion");
            case "CellularGateway" -> Set.of("CellularGateway", "ApplianceAssertion");
            case "Wireless" -> Set.of("Wireless", "ApplianceAssertion");
            case "Camera" -> Set.of("Camera", "ApplianceAssertion");
            case "Application" -> Set.of("Application", "ApplicationAssertion");
            case "incidents" -> Set.of("IncidentFinished", "Incident");
            default -> Collections.emptySet();
        };
    }

    private static Set<String> sourcesOfReel(String type) {
        return switch (type) {
            case "Status" -> Set.of("Datalake#dl$status");
            default -> Collections.emptySet();
        };
    }

    static {
        try {
            Object ref = MasterDatamart.class.getDeclaredField("definition").get(null);
            Field field = ref.getClass().getDeclaredField("definition");
            field.setAccessible(true);
            field.set(ref, definition);
            field.setAccessible(false);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError("Could not set MasterDatamart.definition field");
        }
    }

    private static class DictionaryImpl
    implements Datamart.Dictionary {
        private final String name;
        private final Map<String, WordImpl> words;

        private DictionaryImpl() {
            this("", new HashMap<String, Map<String, String>>(0));
        }

        private DictionaryImpl(String name, Map<String, Map<String, String>> words) {
            this.name = name;
            this.words = words.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new WordImpl((String)e.getKey(), (Map)e.getValue())));
        }

        @Override
        public Datamart.Dictionary.Word get(String wordId) {
            if (wordId == null) {
                return Datamart.Dictionary.Word.wrap("");
            }
            Datamart.Dictionary.Word word = this.words.get(wordId);
            return word != null ? word : Datamart.Dictionary.Word.wrap(wordId);
        }

        @Override
        public Stream<Datamart.Dictionary.Word> words() {
            Stream<Datamart.Dictionary.Word> stream = this.words.values().stream();
            return stream;
        }

        @Override
        public Set<String> languages() {
            return this.words.values().stream().flatMap(w -> w.languages().stream()).collect(Collectors.toSet());
        }

        private static class WordImpl
        implements Datamart.Dictionary.Word {
            private final String id;
            private final Map<String, String> translations;

            private WordImpl(String id, Map<String, String> translations) {
                this.id = id;
                this.translations = translations;
            }

            @Override
            public String get() {
                return this.id;
            }

            @Override
            public Set<String> languages() {
                return this.translations.keySet();
            }

            @Override
            public Optional<String> in(String language) {
                return Optional.ofNullable(this.translations.get(language));
            }
        }
    }

    public static final class MasterDatamartDefinition
    implements DatamartDefinition {
        public final EntityDefinition placeEntityDefinition = new EntityDefinition(this){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Place";
            }

            @Override
            public String name() {
                return "Place";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.empty();
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of();
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Place.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "id";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "enabled";
                    }

                    @Override
                    public Class<?> type() {
                        return Boolean.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "label";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "coordinates";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "timeOffset";
                    }

                    @Override
                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "region";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "city";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "area";
                    }

                    @Override
                    public Class<?> type() {
                        return Area.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "address";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "postalCode";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition areaEntityDefinition = new EntityDefinition(this){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Area";
            }

            @Override
            public String name() {
                return "Area";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.empty();
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of();
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Area.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "id";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "enabled";
                    }

                    @Override
                    public Class<?> type() {
                        return Boolean.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "label";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition incidentRuleEntityDefinition = new EntityDefinition(this){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "IncidentRule";
            }

            @Override
            public String name() {
                return "IncidentRule";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.empty();
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of();
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return IncidentRule.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "id";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "enabled";
                    }

                    @Override
                    public Class<?> type() {
                        return Boolean.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "target";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "model";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "condition";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "precondition";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "level";
                    }

                    @Override
                    public Class<?> type() {
                        return IncidentRule.Level.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "tracking";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "dismissCondition";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "description";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "triggers";
                    }

                    @Override
                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    @Override
                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(this){

                            @Override
                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            @Override
                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition countermeasureEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Countermeasure";
            }

            @Override
            public String name() {
                return "Countermeasure";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.empty();
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of();
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Countermeasure.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "id";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "enabled";
                    }

                    @Override
                    public Class<?> type() {
                        return Boolean.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "condition";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "priority";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "actuationList";
                    }

                    @Override
                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    @Override
                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            @Override
                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.of(this.datamart().countermeasure$ActuationStructDefinition);
                            }

                            @Override
                            public Class<?> javaClass() {
                                return Countermeasure.Actuation.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition modelEntityDefinition = new EntityDefinition(this){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Model";
            }

            @Override
            public String name() {
                return "Model";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.empty();
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of();
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Model.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "id";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "enabled";
                    }

                    @Override
                    public Class<?> type() {
                        return Boolean.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "type";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "target";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "profile";
                    }

                    @Override
                    public Class<?> type() {
                        return Model.Profile.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition orderTypeEntityDefinition = new EntityDefinition(this){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "OrderType";
            }

            @Override
            public String name() {
                return "OrderType";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.empty();
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of();
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return OrderType.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "id";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "enabled";
                    }

                    @Override
                    public Class<?> type() {
                        return Boolean.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition observableEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable";
            }

            @Override
            public String name() {
                return "Observable";
            }

            @Override
            public boolean isAbstract() {
                return true;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.empty();
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of();
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of(personEntityDefinition, processEntityDefinition, assetEntityDefinition, partEntityDefinition, hardwareEntityDefinition, applianceEntityDefinition, computerEntityDefinition, softwareEntityDefinition, observerEntityDefinition, serviceEntityDefinition, applicationEntityDefinition, applicationJavaEntityDefinition);
            }

            @Override
            public Class<?> javaClass() {
                return Observable.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "id";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "enabled";
                    }

                    @Override
                    public Class<?> type() {
                        return Boolean.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "label";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "place";
                    }

                    @Override
                    public Class<?> type() {
                        return Place.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "team";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "model";
                    }

                    @Override
                    public Class<?> type() {
                        return Model.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "container";
                    }

                    @Override
                    public Class<?> type() {
                        return Observable.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "observer";
                    }

                    @Override
                    public Class<?> type() {
                        return Observer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "responsible";
                    }

                    @Override
                    public Class<?> type() {
                        return Person.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "tags";
                    }

                    @Override
                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    @Override
                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(this){

                            @Override
                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            @Override
                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "operationList";
                    }

                    @Override
                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    @Override
                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            @Override
                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.of(this.datamart().observable$OperationStructDefinition);
                            }

                            @Override
                            public Class<?> javaClass() {
                                return Observable.Operation.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition personEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable.Person";
            }

            @Override
            public String name() {
                return "Person";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.of(observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of(observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Person.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "area";
                    }

                    @Override
                    public Class<?> type() {
                        return Area.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "role";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "supervisor";
                    }

                    @Override
                    public Class<?> type() {
                        return Person.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "email";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "phone";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition processEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable.Process";
            }

            @Override
            public String name() {
                return "Process";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.of(observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of(observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Process.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList list = new ArrayList();
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition assetEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable.Asset";
            }

            @Override
            public String name() {
                return "Asset";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.of(observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of(observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Asset.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList list = new ArrayList();
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition partEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable.Part";
            }

            @Override
            public String name() {
                return "Part";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.of(observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of(observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Part.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList list = new ArrayList();
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition hardwareEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable.Hardware";
            }

            @Override
            public String name() {
                return "Hardware";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.of(observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of(observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of(applianceEntityDefinition, computerEntityDefinition);
            }

            @Override
            public Class<?> javaClass() {
                return Hardware.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "sn";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "ip";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "publicIp";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition applianceEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable.Hardware.Appliance";
            }

            @Override
            public String name() {
                return "Appliance";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.of(hardwareEntityDefinition);
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of(hardwareEntityDefinition, observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Appliance.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList list = new ArrayList();
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition computerEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable.Hardware.Computer";
            }

            @Override
            public String name() {
                return "Computer";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.of(hardwareEntityDefinition);
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of(hardwareEntityDefinition, observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Computer.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "architecture";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "os";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "cores";
                    }

                    @Override
                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "diskSize";
                    }

                    @Override
                    public Class<?> type() {
                        return Long.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "memorySize";
                    }

                    @Override
                    public Class<?> type() {
                        return Long.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "processes";
                    }

                    @Override
                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "maxOpenFiles";
                    }

                    @Override
                    public Class<?> type() {
                        return Long.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "jvm";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "isp";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition softwareEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable.Software";
            }

            @Override
            public String name() {
                return "Software";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.of(observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of(observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of(observerEntityDefinition, serviceEntityDefinition, applicationEntityDefinition, applicationJavaEntityDefinition);
            }

            @Override
            public Class<?> javaClass() {
                return Software.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList list = new ArrayList();
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition observerEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable.Software.Observer";
            }

            @Override
            public String name() {
                return "Observer";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.of(softwareEntityDefinition);
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of(softwareEntityDefinition, observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Observer.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "version";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "installedActivities";
                    }

                    @Override
                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    @Override
                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(this){

                            @Override
                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            @Override
                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "enabledActivities";
                    }

                    @Override
                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    @Override
                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(this){

                            @Override
                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            @Override
                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition serviceEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable.Software.Service";
            }

            @Override
            public String name() {
                return "Service";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.of(softwareEntityDefinition);
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of(softwareEntityDefinition, observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Service.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<1> list = new ArrayList<1>();
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "url";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition applicationEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable.Software.Application";
            }

            @Override
            public String name() {
                return "Application";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.of(softwareEntityDefinition);
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of(softwareEntityDefinition, observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of(applicationJavaEntityDefinition);
            }

            @Override
            public Class<?> javaClass() {
                return Application.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "name";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "user";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "systemService";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "startingTime";
                    }

                    @Override
                    public Class<?> type() {
                        return LocalDateTime.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "pid";
                    }

                    @Override
                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "commandLine";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "state";
                    }

                    @Override
                    public Class<?> type() {
                        return Application.State.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition applicationJavaEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable.Software.Application.ApplicationJava";
            }

            @Override
            public String name() {
                return "ApplicationJava";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.of(applicationEntityDefinition);
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of(applicationEntityDefinition, softwareEntityDefinition, observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return ApplicationJava.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "classpathPrefix";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "mainArtifact";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "debugPort";
                    }

                    @Override
                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "jmxPort";
                    }

                    @Override
                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "minMemory";
                    }

                    @Override
                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "maxMemory";
                    }

                    @Override
                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "classpath";
                    }

                    @Override
                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    @Override
                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(this){

                            @Override
                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            @Override
                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "inputArguments";
                    }

                    @Override
                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    @Override
                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(this){

                            @Override
                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            @Override
                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "jvmParameter";
                    }

                    @Override
                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    @Override
                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(this){

                            @Override
                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            @Override
                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "jvmVersion";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final StructDefinition countermeasure$ActuationStructDefinition = new StructDefinition(this){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Countermeasure$Actuation";
            }

            @Override
            public String name() {
                return "Actuation";
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<StructDefinition> parent() {
                return Optional.empty();
            }

            @Override
            public List<StructDefinition> ancestors() {
                return List.of();
            }

            @Override
            public List<StructDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Countermeasure.Actuation.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "id";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "name";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "label";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "target";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "tries";
                    }

                    @Override
                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "tryInterval";
                    }

                    @Override
                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "extraCondition";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "notification";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "dismissNotification";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "channels";
                    }

                    @Override
                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    @Override
                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(this){

                            @Override
                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            @Override
                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((StructDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final StructDefinition model$ProfileStructDefinition = new StructDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Model$Profile";
            }

            @Override
            public String name() {
                return "Profile";
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<StructDefinition> parent() {
                return Optional.empty();
            }

            @Override
            public List<StructDefinition> ancestors() {
                return List.of();
            }

            @Override
            public List<StructDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Model.Profile.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<MasterDatamartDefinition.1> list = new ArrayList<MasterDatamartDefinition.1>();
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "variableList";
                    }

                    @Override
                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    @Override
                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            @Override
                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.of(this.datamart().model$Profile$VariableStructDefinition);
                            }

                            @Override
                            public Class<?> javaClass() {
                                return Model.Profile.Variable.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((StructDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final StructDefinition model$Profile$VariableStructDefinition = new StructDefinition(this){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Model$Profile$Variable";
            }

            @Override
            public String name() {
                return "Variable";
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<StructDefinition> parent() {
                return Optional.empty();
            }

            @Override
            public List<StructDefinition> ancestors() {
                return List.of();
            }

            @Override
            public List<StructDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Model.Profile.Variable.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "name";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "className";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "label";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "type";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "operator";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "unit";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "symbol";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "values";
                    }

                    @Override
                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    @Override
                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(this){

                            @Override
                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            @Override
                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "priority";
                    }

                    @Override
                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "min";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "max";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "description";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "format";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((StructDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final StructDefinition observable$OperationStructDefinition = new StructDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable$Operation";
            }

            @Override
            public String name() {
                return "Operation";
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<StructDefinition> parent() {
                return Optional.empty();
            }

            @Override
            public List<StructDefinition> ancestors() {
                return List.of();
            }

            @Override
            public List<StructDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Observable.Operation.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "activity";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "name";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "procedureList";
                    }

                    @Override
                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    @Override
                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            @Override
                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.of(this.datamart().observable$Operation$ProcedureStructDefinition);
                            }

                            @Override
                            public Class<?> javaClass() {
                                return Observable.Operation.Procedure.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((StructDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final StructDefinition observable$Operation$ProcedureStructDefinition = new StructDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable$Operation$Procedure";
            }

            @Override
            public String name() {
                return "Procedure";
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<StructDefinition> parent() {
                return Optional.empty();
            }

            @Override
            public List<StructDefinition> ancestors() {
                return List.of();
            }

            @Override
            public List<StructDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Observable.Operation.Procedure.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "name";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "returnType";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "description";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "parameterList";
                    }

                    @Override
                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    @Override
                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            @Override
                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.of(this.datamart().observable$Operation$Procedure$ParameterStructDefinition);
                            }

                            @Override
                            public Class<?> javaClass() {
                                return Observable.Operation.Procedure.Parameter.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((StructDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final StructDefinition observable$Operation$Procedure$ParameterStructDefinition = new StructDefinition(this){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable$Operation$Procedure$Parameter";
            }

            @Override
            public String name() {
                return "Parameter";
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<StructDefinition> parent() {
                return Optional.empty();
            }

            @Override
            public List<StructDefinition> ancestors() {
                return List.of();
            }

            @Override
            public List<StructDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Observable.Operation.Procedure.Parameter.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "type";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(this){

                    @Override
                    public String name() {
                        return "name";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((StructDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };

        @Override
        public String name() {
            return "master";
        }

        @Override
        public Datamart.Scale scale() {
            return Datamart.Scale.Day;
        }

        @Override
        public DatamartDefinition.Query<EntityDefinition> entities() {
            return new DatamartDefinition.Query<EntityDefinition>(List.of(this.placeEntityDefinition, this.areaEntityDefinition, this.incidentRuleEntityDefinition, this.countermeasureEntityDefinition, this.modelEntityDefinition, this.orderTypeEntityDefinition, this.observableEntityDefinition, this.personEntityDefinition, this.processEntityDefinition, this.assetEntityDefinition, this.partEntityDefinition, this.hardwareEntityDefinition, this.applianceEntityDefinition, this.computerEntityDefinition, this.softwareEntityDefinition, this.observerEntityDefinition, this.serviceEntityDefinition, this.applicationEntityDefinition, this.applicationJavaEntityDefinition));
        }

        @Override
        public DatamartDefinition.Query<StructDefinition> structs() {
            return new DatamartDefinition.Query<StructDefinition>(List.of(this.countermeasure$ActuationStructDefinition, this.model$ProfileStructDefinition, this.model$Profile$VariableStructDefinition, this.observable$OperationStructDefinition, this.observable$Operation$ProcedureStructDefinition, this.observable$Operation$Procedure$ParameterStructDefinition));
        }

        @Override
        public Optional<EntityDefinition> entity(String name) {
            switch (name) {
                case "Place": {
                    return Optional.of(this.placeEntityDefinition);
                }
                case "Area": {
                    return Optional.of(this.areaEntityDefinition);
                }
                case "IncidentRule": {
                    return Optional.of(this.incidentRuleEntityDefinition);
                }
                case "Countermeasure": {
                    return Optional.of(this.countermeasureEntityDefinition);
                }
                case "Model": {
                    return Optional.of(this.modelEntityDefinition);
                }
                case "OrderType": {
                    return Optional.of(this.orderTypeEntityDefinition);
                }
                case "Observable": {
                    return Optional.of(this.observableEntityDefinition);
                }
                case "Person": {
                    return Optional.of(this.personEntityDefinition);
                }
                case "Process": {
                    return Optional.of(this.processEntityDefinition);
                }
                case "Asset": {
                    return Optional.of(this.assetEntityDefinition);
                }
                case "Part": {
                    return Optional.of(this.partEntityDefinition);
                }
                case "Hardware": {
                    return Optional.of(this.hardwareEntityDefinition);
                }
                case "Appliance": {
                    return Optional.of(this.applianceEntityDefinition);
                }
                case "Computer": {
                    return Optional.of(this.computerEntityDefinition);
                }
                case "Software": {
                    return Optional.of(this.softwareEntityDefinition);
                }
                case "Observer": {
                    return Optional.of(this.observerEntityDefinition);
                }
                case "Service": {
                    return Optional.of(this.serviceEntityDefinition);
                }
                case "Application": {
                    return Optional.of(this.applicationEntityDefinition);
                }
                case "ApplicationJava": {
                    return Optional.of(this.applicationJavaEntityDefinition);
                }
            }
            return Optional.empty();
        }

        @Override
        public Optional<StructDefinition> struct(String name) {
            switch (name) {
                case "Countermeasure$Actuation": {
                    return Optional.of(this.countermeasure$ActuationStructDefinition);
                }
                case "Model$Profile": {
                    return Optional.of(this.model$ProfileStructDefinition);
                }
                case "Model$Profile$Variable": {
                    return Optional.of(this.model$Profile$VariableStructDefinition);
                }
                case "Observable$Operation": {
                    return Optional.of(this.observable$OperationStructDefinition);
                }
                case "Observable$Operation$Procedure": {
                    return Optional.of(this.observable$Operation$ProcedureStructDefinition);
                }
                case "Observable$Operation$Procedure$Parameter": {
                    return Optional.of(this.observable$Operation$Procedure$ParameterStructDefinition);
                }
            }
            return Optional.empty();
        }

        private MasterDatamartDefinition datamart() {
            return this;
        }
    }

    private class TimelineNodeImpl
    implements MasterDatamart.TimelineNode {
        private final String id;
        private final String type;
        private volatile File file;
        private volatile TimelineStore timelineFile;
        private volatile MasterDatamart.TimelineNode.ChangeListener listener;
        private volatile boolean disposed;

        private TimelineNodeImpl(String id, String type) {
            this(id, type, null);
        }

        private TimelineNodeImpl(String id, String type, File file) {
            this.id = Objects.requireNonNull(id);
            this.type = Objects.requireNonNull(type);
            this.file = file;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public String type() {
            return this.type;
        }

        @Override
        public boolean exists() {
            try {
                return this.timelineFile() != null;
            }
            catch (MasterDatamart.TimelineNotAvailableException e) {
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            TimelineNodeImpl timelineNodeImpl = this;
            synchronized (timelineNodeImpl) {
                if (this.disposed) {
                    return;
                }
                this.clearCache();
                this.listener = null;
                MasterDatamartImpl.this.timelines.remove(this.id + ":" + this.type);
                this.disposed = true;
            }
        }

        @Override
        public TimelineStore.TimeModel timeModel() throws MasterDatamart.TimelineNotAvailableException {
            return this.timelineFile().timeModel();
        }

        @Override
        public TimelineStore.SensorModel sensorModel() throws MasterDatamart.TimelineNotAvailableException {
            return this.timelineFile().sensorModel();
        }

        @Override
        public Instant first() throws MasterDatamart.TimelineNotAvailableException {
            return this.timelineFile().first();
        }

        @Override
        public Instant last() throws MasterDatamart.TimelineNotAvailableException {
            return this.timelineFile().last();
        }

        @Override
        public Timeline get() throws MasterDatamart.TimelineNotAvailableException {
            TimelineNodeImpl timelineNodeImpl = this;
            synchronized (timelineNodeImpl) {
                if (this.disposed) {
                    throw new MasterDatamart.TimelineNotAvailableException("This " + this.getClass().getSimpleName() + " is disposed.");
                }
                try {
                    return this.timelineFile().timeline();
                }
                catch (Exception e) {
                    throw new MasterDatamart.TimelineNotAvailableException(e);
                }
            }
        }

        private TimelineStore timelineFile() throws MasterDatamart.TimelineNotAvailableException {
            TimelineNodeImpl timelineNodeImpl = this;
            synchronized (timelineNodeImpl) {
                if (this.disposed) {
                    throw new MasterDatamart.TimelineNotAvailableException("This " + this.getClass().getSimpleName() + " is disposed.");
                }
                try {
                    if (MasterDatamartImpl.this.hasLocalAccessToTimelines && this.file != null && this.file.exists()) {
                        return this.loadFile();
                    }
                    if (this.timelineFile != null) {
                        return this.timelineFile;
                    }
                    this.timelineFile = this.downloadFromDatahub();
                    return this.timelineFile;
                }
                catch (Exception e) {
                    throw new MasterDatamart.TimelineNotAvailableException(e);
                }
            }
        }

        @Override
        public void setChangeListener(MasterDatamart.TimelineNode.ChangeListener listener) {
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyChange() {
            TimelineNodeImpl timelineNodeImpl = this;
            synchronized (timelineNodeImpl) {
                if (this.disposed) {
                    return;
                }
                try {
                    this.clearCache();
                    if (this.listener != null) {
                        new Thread(() -> this.listener.notifyChange(this), "Master-TimelineNodeImpl-" + System.currentTimeMillis()).start();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        private void clearCache() {
            this.timelineFile = null;
            if (!MasterDatamartImpl.this.hasLocalAccessToTimelines) {
                this.file = null;
            }
        }

        private TimelineStore loadFile() throws Exception {
            return TimelineStore.of(this.file);
        }

        private TimelineStore downloadFromDatahub() throws Exception {
            Message response = MasterDatamartImpl.this.requestResponseFromDatahub("get-timeline=" + this.id(), this.request(MasterDatamartImpl.this.hasLocalAccessToTimelines ? "path" : "download"));
            if (!response.getBooleanProperty("success")) {
                throw new MasterDatamart.TimelineNotAvailableException("Could not get timeline " + this.id + " because datahub returned success=false in the response");
            }
            if (response instanceof TextMessage) {
                TextMessage textResponse = (TextMessage)response;
                this.file = this.getFile(textResponse);
                MasterDatamartImpl.this.hasLocalAccessToTimelines = true;
                if (this.file != null && this.file.exists()) {
                    return this.loadFile();
                }
                this.file = null;
                MasterDatamartImpl.this.hasLocalAccessToTimelines = false;
                response = MasterDatamartImpl.this.requestResponseFromDatahub("get-timeline=" + this.id(), this.request("download"));
            }
            if (!response.getBooleanProperty("success")) {
                throw new MasterDatamart.TimelineNotAvailableException("Could not get timeline " + this.id + " because datahub returned success=false in the response");
            }
            return this.readFromBytes((BytesMessage)response);
        }

        private TimelineStore readFromBytes(BytesMessage m) throws Exception {
            int size = m.getIntProperty("size");
            byte[] bytes = new byte[size];
            m.readBytes(bytes, size);
            this.file = File.createTempFile(this.id(), ".timeline");
            Files.write(this.file.toPath(), bytes, StandardOpenOption.CREATE);
            this.file.deleteOnExit();
            MasterDatamartImpl.this.hasLocalAccessToTimelines = false;
            return this.loadFile();
        }

        private File getFile(TextMessage m) {
            try {
                return new File(m.getText());
            }
            catch (Exception e) {
                return null;
            }
        }

        private Message request(String mode) throws Exception {
            ActiveMQTextMessage message = new ActiveMQTextMessage();
            String command = "datamart=" + MasterDatamartImpl.this.name() + ";operation=get-timeline;id=" + this.id() + ";mode=" + mode + ";type=" + this.type;
            message.setText(command);
            return message;
        }
    }

    private class IndicatorNodeImpl
    implements MasterDatamart.IndicatorNode {
        private final String id;
        private volatile File file;

        private IndicatorNodeImpl(String id, File file) {
            this.id = Objects.requireNonNull(id);
            this.file = file;
        }

        @Override
        public boolean exists() {
            try {
                return this.get() != null;
            }
            catch (MasterDatamart.IndicatorNotAvailableException e) {
                return false;
            }
        }

        @Override
        public MasterDatamart.Indicator get() throws MasterDatamart.IndicatorNotAvailableException {
            IndicatorNodeImpl indicatorNodeImpl = this;
            synchronized (indicatorNodeImpl) {
                try {
                    if (MasterDatamartImpl.this.hasLocalAccessToIndicators) {
                        return MasterDatamart.Indicator.load(new FileInputStream(this.file));
                    }
                    return this.downloadFromDatahub();
                }
                catch (Exception e) {
                    throw new MasterDatamart.IndicatorNotAvailableException(e);
                }
            }
        }

        private MasterDatamart.Indicator downloadFromDatahub() throws Exception {
            Message response = MasterDatamartImpl.this.requestResponseFromDatahub("get-indicator=" + this.id, this.request(MasterDatamartImpl.this.hasLocalAccessToIndicators ? "path" : "download"));
            if (!response.getBooleanProperty("success")) {
                throw new MasterDatamart.ReelNotAvailableException("Could not get indicator " + this.id + " because datahub returned success=false in the response");
            }
            if (response instanceof TextMessage) {
                TextMessage textResponse = (TextMessage)response;
                this.file = this.getFile(textResponse);
                MasterDatamartImpl.this.hasLocalAccessToIndicators = true;
                if (this.file != null && this.file.exists()) {
                    return this.loadFile();
                }
                this.file = null;
                MasterDatamartImpl.this.hasLocalAccessToIndicators = false;
                response = MasterDatamartImpl.this.requestResponseFromDatahub("get-indicator=" + this.id, this.request("download"));
            }
            if (!response.getBooleanProperty("success")) {
                throw new MasterDatamart.ReelNotAvailableException("Could not get indicator " + this.id + " because datahub returned success=false in the response");
            }
            return this.readFromBytes((BytesMessage)response);
        }

        private MasterDatamart.Indicator readFromBytes(BytesMessage m) throws Exception {
            int messageSize = m.getIntProperty("size");
            byte[] bytes = new byte[messageSize];
            m.readBytes(bytes, messageSize);
            return MasterDatamart.Indicator.load(new ByteArrayInputStream(bytes));
        }

        private Message request(String mode) throws Exception {
            ActiveMQTextMessage message = new ActiveMQTextMessage();
            message.setText("datamart=" + MasterDatamartImpl.this.name() + ";operation=get-indicator;id=" + this.id + ";mode=" + mode);
            return message;
        }

        private File getFile(TextMessage m) {
            try {
                return new File(m.getText());
            }
            catch (Exception e) {
                return null;
            }
        }

        private MasterDatamart.Indicator loadFile() throws Exception {
            return MasterDatamart.Indicator.load(new FileInputStream(this.file));
        }
    }

    private class ReelNodeImpl
    implements MasterDatamart.ReelNode {
        private final String id;
        private final String type;
        private volatile File file;
        private volatile ReelFile reelFile;
        private volatile MasterDatamart.ReelNode.ChangeListener listener;
        private volatile boolean disposed;

        private ReelNodeImpl(String id, String type) {
            this(id, type, null);
        }

        private ReelNodeImpl(String id, String type, File file) {
            this.id = Objects.requireNonNull(id);
            this.type = Objects.requireNonNull(type);
            this.file = file;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public String type() {
            return this.type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            ReelNodeImpl reelNodeImpl = this;
            synchronized (reelNodeImpl) {
                if (this.disposed) {
                    return;
                }
                this.clearCache();
                this.listener = null;
                MasterDatamartImpl.this.reels.remove(this.id + ":" + this.type);
                this.disposed = true;
            }
        }

        @Override
        public Instant start() throws MasterDatamart.ReelNotAvailableException {
            ReelFile reelFile = this.reelFile();
            if (reelFile == null) {
                return null;
            }
            return reelFile.start();
        }

        @Override
        public State stateOf(String signal) throws MasterDatamart.ReelNotAvailableException {
            ReelFile reelFile = this.reelFile();
            return reelFile.lastStateOf(signal);
        }

        @Override
        public Set<String> signals() throws MasterDatamart.ReelNotAvailableException {
            ReelFile reelFile = this.reelFile();
            return reelFile.signals();
        }

        @Override
        public List<State> stateOf(Stream<String> signals) throws MasterDatamart.ReelNotAvailableException {
            ReelFile reelFile = this.reelFile();
            return signals.map(reelFile::lastStateOf).toList();
        }

        @Override
        public Shot lastShotOf(String signal) throws MasterDatamart.ReelNotAvailableException {
            ReelFile reelFile = this.reelFile();
            return reelFile.lastShotOf(signal);
        }

        @Override
        public List<Shot> lastShots() throws MasterDatamart.ReelNotAvailableException {
            ReelFile reelFile = this.reelFile();
            return reelFile.lastShots();
        }

        @Override
        public List<Shot> lastShots(String group) throws MasterDatamart.ReelNotAvailableException {
            ReelFile reelFile = this.reelFile();
            return reelFile.lastShots(group);
        }

        @Override
        public List<Shot> lastShots(Group group) throws MasterDatamart.ReelNotAvailableException {
            ReelFile reelFile = this.reelFile();
            return reelFile.lastShots(group);
        }

        @Override
        public Reel get(Period period) throws MasterDatamart.ReelNotAvailableException {
            ReelFile reelFile = this.reelFile();
            return this.reelFile().reel().by(period);
        }

        @Override
        public Reel get(Instant from, Instant to, Period period) throws MasterDatamart.ReelNotAvailableException {
            ReelFile reelFile = this.reelFile();
            return reelFile.reel(from, to).by(period);
        }

        @Override
        public boolean exists() {
            try {
                return this.reelFile() != null;
            }
            catch (MasterDatamart.ReelNotAvailableException e) {
                return false;
            }
        }

        private ReelFile reelFile() throws MasterDatamart.ReelNotAvailableException {
            ReelNodeImpl reelNodeImpl = this;
            synchronized (reelNodeImpl) {
                if (this.disposed) {
                    throw new MasterDatamart.ReelNotAvailableException("This " + this.getClass().getSimpleName() + " is disposed.");
                }
                try {
                    if (MasterDatamartImpl.this.hasLocalAccessToReels && this.file != null && this.file.exists()) {
                        return this.loadFile();
                    }
                    if (this.reelFile != null) {
                        return this.reelFile;
                    }
                    this.reelFile = this.downloadFromDatahub();
                    return this.reelFile;
                }
                catch (Exception e) {
                    throw new MasterDatamart.ReelNotAvailableException(e);
                }
            }
        }

        @Override
        public void setChangeListener(MasterDatamart.ReelNode.ChangeListener listener) {
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyChange() {
            ReelNodeImpl reelNodeImpl = this;
            synchronized (reelNodeImpl) {
                if (this.disposed) {
                    return;
                }
                try {
                    this.clearCache();
                    if (this.listener != null) {
                        new Thread(() -> this.listener.notifyChange(this), "Master-ReelNodeImpl-" + System.currentTimeMillis()).start();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        private void clearCache() {
            this.reelFile = null;
            if (!MasterDatamartImpl.this.hasLocalAccessToReels) {
                this.file = null;
            }
        }

        private ReelFile loadFile() throws Exception {
            return ReelFile.open(this.file);
        }

        private ReelFile downloadFromDatahub() throws Exception {
            Message response = MasterDatamartImpl.this.requestResponseFromDatahub("get-reel=" + this.id(), this.request(MasterDatamartImpl.this.hasLocalAccessToReels ? "path" : "download"));
            if (!response.getBooleanProperty("success")) {
                throw new MasterDatamart.ReelNotAvailableException("Could not get reel " + this.id + " because datahub returned success=false in the response");
            }
            if (response instanceof TextMessage) {
                TextMessage textResponse = (TextMessage)response;
                this.file = this.getFile(textResponse);
                MasterDatamartImpl.this.hasLocalAccessToReels = true;
                if (this.file != null && this.file.exists()) {
                    return this.loadFile();
                }
                this.file = null;
                MasterDatamartImpl.this.hasLocalAccessToReels = false;
                response = MasterDatamartImpl.this.requestResponseFromDatahub("get-reel=" + this.id(), this.request("download"));
            }
            if (!response.getBooleanProperty("success")) {
                throw new MasterDatamart.ReelNotAvailableException("Could not get reel " + this.id + " because datahub returned success=false in the response");
            }
            return this.readFromBytes((BytesMessage)response);
        }

        private ReelFile readFromBytes(BytesMessage m) throws Exception {
            int size = m.getIntProperty("size");
            byte[] bytes = new byte[size];
            m.readBytes(bytes, size);
            this.file = File.createTempFile(this.id(), ".reel");
            Files.write(this.file.toPath(), bytes, StandardOpenOption.CREATE);
            this.file.deleteOnExit();
            MasterDatamartImpl.this.hasLocalAccessToReels = false;
            return this.loadFile();
        }

        private File getFile(TextMessage m) {
            try {
                return new File(m.getText());
            }
            catch (Exception e) {
                return null;
            }
        }

        private Message request(String mode) throws Exception {
            ActiveMQTextMessage message = new ActiveMQTextMessage();
            String command = "datamart=" + MasterDatamartImpl.this.name() + ";operation=get-reel;id=" + this.id() + ";mode=" + mode + ";type=" + this.type;
            message.setText(command);
            return message;
        }
    }
}

