/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.service.requests;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.service.requests.ContainerRequest;
import io.intino.consul.terminal.RequestAttendant;
import jakarta.jms.Message;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ExploreFileSystemRequest
extends ContainerRequest {
    public static final String ID = "exploreFileSystem";

    @Override
    public String id() {
        return ID;
    }

    @Override
    public RequestAttendant.RequestResult responseTo(Message request) {
        try {
            String root = this.parameter(request, "path");
            List<File> roots = Arrays.asList(File.listRoots());
            if (root.isEmpty()) {
                return new RequestAttendant.RequestResult(true, roots.stream().map(File::getAbsolutePath).collect(Collectors.toList()));
            }
            return new RequestAttendant.RequestResult(true, this.walk(Path.of(root, new String[0]), roots.stream().anyMatch(r -> r.getAbsolutePath().equals(root)) ? 1 : 4).map(p -> String.valueOf(p.toAbsolutePath()) + (p.toFile().isDirectory() ? File.separator : "")).collect(Collectors.toList()));
        }
        catch (Throwable e) {
            Logger.error(e);
            return new RequestAttendant.RequestResult(false, e.getMessage());
        }
    }

    @Override
    public boolean isAvailable(Message message) {
        return true;
    }

    private Stream<Path> walk(Path path, int depth) {
        try {
            final ArrayList paths = new ArrayList();
            Files.walkFileTree(path, Set.of(), depth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    paths.add(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException e) {
                    return FileVisitResult.SKIP_SUBTREE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    paths.add(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
            return paths.stream();
        }
        catch (IOException e) {
            Logger.error(e);
            return Stream.of(new Path[0]);
        }
    }
}

