/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.actions;

import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class WindowsUpgradeCommand {
    public static final String INSTALL_SERVICE_BAT = "install_upgrade_service.bat";
    public static final String UPGRADE_BAT = "upgrade.bat";
    private final File installDirectory;

    public WindowsUpgradeCommand(File installDirectory) {
        this.installDirectory = installDirectory;
    }

    public void execute() throws IOException {
        File upgradeServiceBatch = WindowsUpgradeCommand.createScript(this.installDirectory, INSTALL_SERVICE_BAT);
        WindowsUpgradeCommand.createScript(this.installDirectory, UPGRADE_BAT);
        try {
            Process process = new ProcessBuilder(new String[0]).directory(this.installDirectory).command(INSTALL_SERVICE_BAT).inheritIO().start();
            process.waitFor(1L, TimeUnit.MINUTES);
            upgradeServiceBatch.delete();
            WindowsUpgradeCommand.runProcess(new ProcessBuilder(new String[0]).directory(this.installDirectory).command("net", "start", "consul-upgrade"));
        }
        catch (InterruptedException e) {
            Logger.error(e);
        }
    }

    public static File createScript(File installDirectory, String upgradeScript) throws IOException {
        Map<String, String> parameters = WindowsUpgradeCommand.scriptParameters(installDirectory);
        InputStream stream = WindowsUpgradeCommand.class.getResourceAsStream(upgradeScript);
        if (stream == null) {
            stream = WindowsUpgradeCommand.class.getResourceAsStream("/" + upgradeScript);
        }
        String content = new String(stream.readAllBytes());
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            content = content.replace(entry.getKey(), entry.getValue());
        }
        File scriptFile = new File(installDirectory, upgradeScript);
        Files.writeString(scriptFile.toPath(), (CharSequence)content, new OpenOption[0]);
        scriptFile.setExecutable(true);
        stream.close();
        return scriptFile;
    }

    private static Map<String, String> scriptParameters(File installDirectory) {
        return Map.of("#app_home#", installDirectory.getAbsolutePath(), "#upgradeFile#", new File(installDirectory, UPGRADE_BAT).getAbsolutePath(), "#logFile#", new File(installDirectory, "upgrade.log").getAbsolutePath());
    }

    private static void runProcess(ProcessBuilder processBuilder) {
        new Thread(() -> {
            try {
                Thread.sleep(3000L);
                processBuilder.start();
            }
            catch (IOException | InterruptedException e) {
                Logger.error(e);
            }
        }).start();
    }
}

