/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box;

import com.google.gson.reflect.TypeToken;
import io.intino.alexandria.Json;
import io.intino.alexandria.logger.Logger;
import io.intino.consul.framework.Activity;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ContainerStore
implements Activity.Store {
    public static final Type asList = new TypeToken<List<String>>(){}.getType();
    public static final Type asMap = new TypeToken<Map<String, String>>(){}.getType();
    public static final Type asBooleanMap = new TypeToken<Map<String, Boolean>>(){}.getType();
    private static final String SEP = "\t";
    private final File directory;
    private final File activitiesDirectory;
    private Map<String, String> entries;

    public ContainerStore(File directory) {
        this.directory = directory;
        Logger.info("Container store located in: " + directory.getAbsolutePath());
        directory.mkdirs();
        this.activitiesDirectory = new File(directory, "activities");
        this.activitiesDirectory.mkdirs();
        this.load();
    }

    public File saveActivity(String artifact, byte[] content) {
        File file = this.activityFile(artifact);
        file.getParentFile().mkdirs();
        try {
            Files.write(file.toPath(), content, new OpenOption[0]);
            return file;
        }
        catch (IOException e) {
            Logger.error(e);
            return file;
        }
    }

    public File saveActivityParams(String artifact, Map<String, String> params) {
        File paramsFile = this.parametersFile(artifact);
        try {
            Files.writeString(paramsFile.toPath(), (CharSequence)Json.toJson(params), new OpenOption[0]);
            return paramsFile;
        }
        catch (IOException e) {
            Logger.error(e);
            return paramsFile;
        }
    }

    public void removeActivity(String artifact) {
        File file = this.activityFile(artifact);
        if (!file.delete()) {
            file.deleteOnExit();
        }
        this.parametersFile(artifact).delete();
    }

    public File activity(String artifact) {
        return this.activityFile(artifact);
    }

    public Map<String, String> activityParams(String artifact) {
        try {
            File file = this.parametersFile(artifact);
            if (!file.exists()) {
                return Map.of();
            }
            return (Map)Json.fromJson(Files.readString(file.toPath()), asMap);
        }
        catch (IOException e) {
            Logger.error(e);
            return Map.of();
        }
    }

    private void load() {
        if (!this.file().exists()) {
            this.entries = new ConcurrentHashMap<String, String>();
        } else {
            try (Stream<String> lines = Files.lines(this.file().toPath());){
                this.entries = lines.map(l -> l.split(SEP)).collect(Collectors.toMap(f -> f[0], f -> f[1], (v1, v2) -> v2, ConcurrentHashMap::new));
            }
            catch (IOException e) {
                Logger.error(e);
            }
        }
    }

    public synchronized void save() {
        try {
            this.file().delete();
            if (!this.entries.isEmpty()) {
                BufferedWriter writer = new BufferedWriter(new FileWriter(this.file(), true));
                this.entries.entrySet().stream().map(e -> (String)e.getKey() + SEP + (String)e.getValue() + "\n").forEach(l -> {
                    try {
                        writer.write((String)l);
                    }
                    catch (IOException e) {
                        Logger.error(e);
                    }
                });
                writer.close();
            }
        }
        catch (IOException e2) {
            Logger.error(e2);
        }
    }

    @Override
    public void put(String key, Object object) {
        this.entries.put(key, Json.toJson(object));
    }

    @Override
    public <T> T get(String key, Class<T> type) {
        String value = this.entries.get(key);
        return value == null ? null : (T)Json.fromJson(value, type);
    }

    public <T> T getOrElse(String key, Class<T> type, T orElse) {
        String value = this.entries.get(key);
        return value == null ? orElse : Json.fromJson(value, type);
    }

    @Override
    public <T> T get(String key, Type type) {
        String value = this.entries.get(key);
        return value == null ? null : (T)Json.fromJson(value, type);
    }

    public <T> T getOrElse(String key, Type type, T orElse) {
        String value = this.entries.get(key);
        return value == null ? orElse : Json.fromJson(value, type);
    }

    private File activityFile(String artifact) {
        String[] coors = artifact.split(":");
        return new File(this.activitiesDirectory, coors[0] + File.separator + coors[1] + File.separator + coors[2] + File.separator + coors[1] + "-" + coors[2] + ".jar");
    }

    private File parametersFile(String artifact) {
        String[] coors = artifact.split(":");
        return new File(this.activitiesDirectory, coors[0] + File.separator + coors[1] + File.separator + coors[2] + File.separator + "parameters.json");
    }

    private File file() {
        return new File(this.directory, "store.json");
    }

    @Override
    public Stream<String> keys() {
        return this.entries.keySet().stream();
    }

    @Override
    public void remove(String key) {
        this.entries.remove(key);
    }

    public void removeAll(Predicate<String> predicate) {
        this.entries.keySet().removeIf(predicate);
    }

    public void clear() {
        this.entries.clear();
    }
}

