/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.datalake.file;

import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.datalake.file.measurement.MeasurementEventStore;
import io.intino.alexandria.datalake.file.message.MessageEventStore;
import io.intino.alexandria.datalake.file.resource.ResourceEventStore;
import io.intino.alexandria.event.measurement.MeasurementEvent;
import io.intino.alexandria.event.message.MessageEvent;
import java.io.File;

public class FileDatalake
implements Datalake {
    private final File root;

    public FileDatalake(File root) {
        this.root = root;
        this.checkStore();
    }

    private void checkStore() {
        this.messageStoreFolder().mkdirs();
        this.measurementStoreFolder().mkdirs();
        this.resourceStoreFolder().mkdirs();
    }

    @Override
    public Datalake.Store<MessageEvent> messageStore() {
        return new MessageEventStore(this.messageStoreFolder());
    }

    @Override
    public Datalake.Store<MeasurementEvent> measurementStore() {
        return new MeasurementEventStore(this.measurementStoreFolder());
    }

    @Override
    public Datalake.ResourceStore resourceStore() {
        return new ResourceEventStore(this.resourceStoreFolder());
    }

    public File root() {
        return this.root;
    }

    public File messageStoreFolder() {
        return new File(this.root, "messages");
    }

    public File measurementStoreFolder() {
        return new File(this.root, "measurements");
    }

    private File resourceStoreFolder() {
        return new File(this.root, "resources");
    }
}

