/*
 * Decompiled with CFR 0.152.
 */
package smile.manifold;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.graph.AdjacencyList;
import smile.graph.Graph;
import smile.manifold.NearestNeighborGraph;
import smile.math.MathEx;
import smile.math.blas.UPLO;
import smile.math.distance.Distance;
import smile.math.distance.EuclideanDistance;
import smile.math.matrix.ARPACK;
import smile.math.matrix.Matrix;

public class IsoMap
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger logger = LoggerFactory.getLogger(IsoMap.class);
    public final int[] index;
    public final double[][] coordinates;
    public final AdjacencyList graph;

    public IsoMap(int[] index, double[][] coordinates, AdjacencyList graph) {
        this.index = index;
        this.coordinates = coordinates;
        this.graph = graph;
    }

    public static IsoMap of(double[][] data, int k) {
        return IsoMap.of(data, k, 2, true);
    }

    public static IsoMap of(double[][] data, int k, int d, boolean conformal) {
        return IsoMap.of(data, new EuclideanDistance(), k, d, conformal);
    }

    public static <T> IsoMap of(T[] data, Distance<T> distance, int k) {
        return IsoMap.of(data, distance, k, 2, true);
    }

    public static <T> IsoMap of(T[] data, Distance<T> distance, int k, int d, boolean conformal) {
        AdjacencyList graph;
        if (!conformal) {
            graph = NearestNeighborGraph.of(data, distance, k, false, null);
        } else {
            int n = data.length;
            double[] M2 = new double[n];
            graph = NearestNeighborGraph.of(data, distance, k, false, (v1, v2, weight, j) -> {
                int n = v1;
                M2[n] = M2[n] + weight;
            });
            for (int i = 0; i < n; ++i) {
                M2[i] = Math.sqrt(M2[i] / (double)k);
            }
            for (Graph.Edge edge : graph.getEdges()) {
                edge.weight /= M2[edge.v1] * M2[edge.v2];
            }
        }
        NearestNeighborGraph nng = NearestNeighborGraph.largest(graph);
        int[] index = nng.index;
        int n = index.length;
        graph = nng.graph;
        double[][] D = graph.dijkstra();
        for (int i = 0; i < n; ++i) {
            for (int j2 = 0; j2 < i; ++j2) {
                D[i][j2] = -0.5 * D[i][j2] * D[i][j2];
                D[j2][i] = D[i][j2];
            }
        }
        double[] mean = MathEx.rowMeans(D);
        double mu = MathEx.mean(mean);
        Matrix B = new Matrix(n, n);
        for (int i = 0; i < n; ++i) {
            for (int j3 = 0; j3 <= i; ++j3) {
                double b = D[i][j3] - mean[i] - mean[j3] + mu;
                B.set(i, j3, b);
                B.set(j3, i, b);
            }
        }
        B.uplo(UPLO.LOWER);
        Matrix.EVD eigen = ARPACK.syev(B, ARPACK.SymmOption.LA, d);
        if (eigen.wr.length < d) {
            logger.warn("eigen({}) returns only {} eigen vectors", (Object)d, (Object)eigen.wr.length);
            d = eigen.wr.length;
        }
        Matrix V = eigen.Vr;
        double[][] coordinates = new double[n][d];
        for (int j4 = 0; j4 < d; ++j4) {
            if (eigen.wr[j4] < 0.0) {
                throw new IllegalArgumentException(String.format("Some of the first %d eigenvalues are < 0.", d));
            }
            double scale = Math.sqrt(eigen.wr[j4]);
            for (int i = 0; i < n; ++i) {
                coordinates[i][j4] = V.get(i, j4) * scale;
            }
        }
        return new IsoMap(index, coordinates, graph);
    }
}

