/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering.linkage;

import smile.clustering.linkage.Linkage;
import smile.math.distance.Distance;

public class WPGMALinkage
extends Linkage {
    public WPGMALinkage(double[][] proximity) {
        super(proximity);
    }

    public WPGMALinkage(int size, float[] proximity) {
        super(size, proximity);
    }

    public static WPGMALinkage of(double[][] data) {
        return new WPGMALinkage(data.length, WPGMALinkage.proximity(data));
    }

    public static <T> WPGMALinkage of(T[] data, Distance<T> distance) {
        return new WPGMALinkage(data.length, WPGMALinkage.proximity(data, distance));
    }

    public String toString() {
        return "WPGMA linkage";
    }

    @Override
    public void merge(int i, int j) {
        int k;
        for (k = 0; k < i; ++k) {
            this.proximity[this.index((int)i, (int)k)] = (this.d(i, k) + this.d(j, k)) / 2.0f;
        }
        for (k = i + 1; k < this.size; ++k) {
            this.proximity[this.index((int)k, (int)i)] = (this.d(k, i) + this.d(j, k)) / 2.0f;
        }
    }
}

