/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.normalization;

import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import ro.hasna.ts.math.normalization.Normalizer;

public class ZNormalizer
implements Normalizer {
    private static final long serialVersionUID = 6446811014325682141L;
    private final Mean mean;
    private final StandardDeviation standardDeviation;

    public ZNormalizer() {
        this(new Mean(), new StandardDeviation(false));
    }

    public ZNormalizer(Mean mean, StandardDeviation standardDeviation) {
        this.mean = mean;
        this.standardDeviation = standardDeviation;
    }

    @Override
    public double[] normalize(double[] values) {
        double m = this.mean.evaluate(values);
        double sd = this.standardDeviation.evaluate(values, m);
        int length = values.length;
        double[] normalizedValues = new double[length];
        for (int i = 0; i < length; ++i) {
            normalizedValues[i] = (values[i] - m) / sd;
        }
        return normalizedValues;
    }
}

