/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.normalization;

import org.apache.commons.math3.exception.NumberIsTooLargeException;
import ro.hasna.ts.math.normalization.Normalizer;

public class MinMaxNormalizer
implements Normalizer {
    private static final long serialVersionUID = 2822371561555309746L;
    private final double min;
    private final double max;

    public MinMaxNormalizer() {
        this(0.0, 1.0);
    }

    public MinMaxNormalizer(double min, double max) {
        if (min > max) {
            throw new NumberIsTooLargeException(min, (Number)max, true);
        }
        this.min = min;
        this.max = max;
    }

    @Override
    public double[] normalize(double[] values) {
        double[] result = new double[values.length];
        double initialMin = values[0];
        double initialMax = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (initialMax < values[i]) {
                initialMax = values[i];
            }
            if (!(initialMin > values[i])) continue;
            initialMin = values[i];
        }
        double aux = (this.max - this.min) / (initialMax - initialMin);
        for (int i = 0; i < values.length; ++i) {
            result[i] = (values[i] - initialMin) * aux + this.min;
        }
        return result;
    }
}

