/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.ml.distance;

import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;
import ro.hasna.ts.math.ml.distance.GenericDistanceMeasure;
import ro.hasna.ts.math.util.TimeSeriesPrecision;

public class RealSequenceEditDistance
implements GenericDistanceMeasure<double[]> {
    private static final long serialVersionUID = -373272813771443967L;
    private final double epsilon;
    private final double radiusPercentage;

    public RealSequenceEditDistance() {
        this(TimeSeriesPrecision.EPSILON, 1.0);
    }

    public RealSequenceEditDistance(double epsilon, double radiusPercentage) {
        this.epsilon = epsilon;
        this.radiusPercentage = radiusPercentage;
    }

    @Override
    public double compute(double[] a, double[] b) {
        return this.compute(a, b, Double.POSITIVE_INFINITY);
    }

    @Override
    public double compute(double[] a, double[] b, double cutOffValue) {
        int i;
        if (this.equals(a, b)) {
            return 0.0;
        }
        int n = b.length;
        int radius = (int)((double)n * this.radiusPercentage);
        int n1 = n + 1;
        double[] prev = new double[n1];
        double[] current = new double[n1];
        for (i = 0; i < n1; ++i) {
            prev[i] = i;
        }
        for (i = 0; i < a.length; ++i) {
            int start = FastMath.max(0, i - radius);
            int end = FastMath.min(n - 1, i + radius);
            current[0] = i + 1;
            double min = Double.POSITIVE_INFINITY;
            for (int j = start; j <= end; ++j) {
                double x = prev[j + 1] + 1.0;
                double y = current[j] + 1.0;
                double z = prev[j];
                if (!Precision.equals(a[i], b[j], this.epsilon)) {
                    z += 1.0;
                }
                current[j + 1] = FastMath.min(x, FastMath.min(y, z));
                if (!(current[j + 1] < min)) continue;
                min = current[j + 1];
            }
            if (min > cutOffValue) {
                return Double.POSITIVE_INFINITY;
            }
            System.arraycopy(current, 0, prev, 0, n1);
        }
        if (current[n] > cutOffValue) {
            return Double.POSITIVE_INFINITY;
        }
        return current[n];
    }

    private boolean equals(double[] a, double[] b) {
        boolean equals = a.length == b.length;
        for (int i = 0; i < a.length && equals; ++i) {
            if (Precision.equals(a[i], b[i], this.epsilon)) continue;
            equals = false;
        }
        return equals;
    }
}

