/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos.timelines.writers;

import io.intino.sumus.chronos.timelines.TimelineWriter;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.StandardOpenOption;

public class FileTimelineWriter
extends TimelineWriter {
    public FileTimelineWriter(String sensor, File file) throws IOException {
        this(sensor, file, false);
    }

    public FileTimelineWriter(String sensor, File file, boolean append) throws IOException {
        super(sensor, FileTimelineWriter.open(file, append));
    }

    public FileTimelineWriter(String sensor, File file, boolean append, int bufferSize) throws IOException {
        super(sensor, FileTimelineWriter.open(file, append), bufferSize);
    }

    private static SeekableByteChannel open(File file, boolean append) throws IOException {
        if (!append && file.exists()) {
            file.delete();
        }
        FileChannel channel = FileChannel.open(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        if (append) {
            channel.position(channel.size());
        }
        return channel;
    }
}

