/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos.timelines;

import io.intino.sumus.chronos.InvalidChronosBlockMarkException;
import io.intino.sumus.chronos.TimelineStore;
import io.intino.sumus.chronos.timelines.blocks.Data;
import io.intino.sumus.chronos.timelines.blocks.Header;
import io.intino.sumus.chronos.timelines.blocks.SensorModel;
import io.intino.sumus.chronos.timelines.blocks.TimeModel;
import io.intino.sumus.chronos.util.ChannelsHelper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.time.Instant;
import java.util.Iterator;

public class TimelineReader
implements Iterator<TimelineStore.Block>,
AutoCloseable {
    private final SeekableByteChannel channel;
    private final ByteBuffer markAndSizeBuffer;
    private final TimelineStore.Header header;
    private TimelineStore.TimeModel timeModel;
    private TimelineStore.SensorModel sensorModel;
    private TimelineStore.Block current;
    private Instant currentInstant;

    public TimelineReader(ReadableByteChannel channel) throws IOException {
        this.channel = ChannelsHelper.makeSeekable(channel);
        this.markAndSizeBuffer = ByteBuffer.allocate(4);
        this.header = TimelineReader.readHeader(channel, new Header());
        this.current = this.readNextBlock();
    }

    public long position() throws IOException {
        return this.channel.position();
    }

    public TimelineStore.Header header() {
        return this.header;
    }

    public TimelineStore.TimeModel timeModel() {
        return this.timeModel;
    }

    public TimelineStore.SensorModel sensorModel() {
        return this.sensorModel;
    }

    @Override
    public boolean hasNext() {
        return this.current != null;
    }

    @Override
    public TimelineStore.Block next() {
        TimelineStore.Block next = this.current;
        this.current = this.readNextBlock();
        return next;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    private TimelineStore.Block readNextBlock() {
        try {
            int read = this.channel.read(this.markAndSizeBuffer.position(0).limit(2));
            if (read != 2) {
                return null;
            }
            return this.readBlock(this.markAndSizeBuffer.getShort(0));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private TimelineStore.Block readBlock(short mark) throws IOException {
        switch (mark) {
            case 26208: {
                return this.readTimeModel();
            }
            case 26209: {
                return this.readSensorModel();
            }
            case 21845: {
                return this.readData();
            }
        }
        throw new InvalidChronosBlockMarkException("Invalid Chronos block mark: 0x" + Integer.toHexString(mark).toUpperCase());
    }

    private TimelineStore.Block readTimeModel() throws IOException {
        this.timeModel = TimeModel.deserialize(this.channel, false);
        this.currentInstant = this.timeModel.instant();
        return this.timeModel;
    }

    private TimelineStore.Block readSensorModel() throws IOException {
        this.sensorModel = SensorModel.deserialize(this.channel, false);
        return this.sensorModel;
    }

    private TimelineStore.Block readData() throws IOException {
        long position = this.position();
        if (position > 2L) {
            position -= 2L;
        }
        this.channel.read(this.markAndSizeBuffer.position(0).limit(4));
        ByteBuffer data = ByteBuffer.allocate(this.markAndSizeBuffer.getInt(0));
        this.channel.read(data);
        return this.readDataRecordsFrom(position, data.clear());
    }

    private TimelineStore.Block readDataRecordsFrom(long position, ByteBuffer data) {
        int recordSize = Data.calculateRecordByteSize(this.sensorModel.size());
        int numRecords = data.remaining() / recordSize;
        Instant[] instants = new Instant[numRecords];
        for (int i = 0; i < numRecords; ++i) {
            instants[i] = this.currentInstant;
            this.currentInstant = this.timeModel.next(this.currentInstant);
        }
        return new Data(position, instants, this.sensorModel.size(), data);
    }

    public static Header readHeader(ReadableByteChannel channel, Header header) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(512);
        int read = channel.read(buffer);
        if (read < 512) {
            throw new IllegalStateException("Could not read Chronos Header. Bytes read = " + read);
        }
        Header.deserialize(buffer.clear(), header);
        return header;
    }

    public static TimelineStore.Header readHeader(SeekableByteChannel channel) throws IOException {
        return TimelineReader.readHeader(channel, new Header());
    }

    public static TimelineStore.SensorModel readSensorModel(long sensorModelPosition, SeekableByteChannel channel) throws IOException {
        channel.position(sensorModelPosition);
        return SensorModel.deserialize(channel, true);
    }

    public static TimelineStore.TimeModel readTimeModel(long timeModelPosition, SeekableByteChannel channel) throws IOException {
        channel.position(timeModelPosition);
        return TimeModel.deserialize(channel, true);
    }
}

