/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos.itl;

import io.intino.sumus.chronos.Period;
import io.intino.sumus.chronos.TimelineStore;
import io.intino.sumus.chronos.timelines.TimelineReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.channels.Channels;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;

public class ItlExporter {
    private static final DecimalFormat TheDecimalFormatter = ItlExporter.formatter();

    public static void export(String id, File src, File dst) throws IOException {
        ItlExporter.export(id, new FileInputStream(src), new FileOutputStream(dst));
    }

    public static void export(String id, InputStream src, OutputStream dst) throws IOException {
        Period[] lastPeriod = new Period[1];
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(dst));){
            writer.write("@id " + id + "\n");
            try (TimelineReader reader = new TimelineReader(Channels.newChannel(src));){
                while (reader.hasNext()) {
                    TimelineStore.Block block = reader.next();
                    if (block instanceof TimelineStore.TimeModel) {
                        ItlExporter.write((TimelineStore.TimeModel)block, writer, lastPeriod);
                        continue;
                    }
                    if (block instanceof TimelineStore.SensorModel) {
                        ItlExporter.write((TimelineStore.SensorModel)block, (Writer)writer);
                        continue;
                    }
                    if (!(block instanceof TimelineStore.Data)) continue;
                    ItlExporter.write((TimelineStore.Data)block, (Writer)writer);
                }
            }
        }
    }

    private static void write(TimelineStore.SensorModel data, Writer writer) throws IOException {
        writer.write("@measurements " + String.join((CharSequence)",", data.magnitudes()) + "\n");
    }

    private static void write(TimelineStore.TimeModel timeModel, Writer writer, Period[] lastPeriod) throws IOException {
        writer.write("@instant " + timeModel.instant().toString() + "\n");
        if (timeModel.period().equals((Object)lastPeriod[0])) {
            return;
        }
        writer.write("@period " + timeModel.period() + "\n");
        lastPeriod[0] = timeModel.period();
    }

    private static void write(TimelineStore.Data data, Writer writer) throws IOException {
        for (TimelineStore.Data.Record record : data) {
            writer.write(ItlExporter.toString(record.values()) + "\n");
        }
    }

    private static String toString(double[] values) {
        return Arrays.stream(values).mapToObj(ItlExporter::toString).collect(Collectors.joining("\t")).stripTrailing();
    }

    private static String toString(double value) {
        return Double.isNaN(value) ? "" : ItlExporter.format(value);
    }

    private static String format(double value) {
        return Double.isNaN(value) ? "" : TheDecimalFormatter.format(value);
    }

    private static DecimalFormat formatter() {
        DecimalFormat df = new DecimalFormat("#.#############");
        df.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.ENGLISH));
        return df;
    }
}

