/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.messages.universe;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class CountermeasureAssertion
extends MessageEvent
implements Serializable {
    private List<Actuation> actuationList = null;

    public CountermeasureAssertion(String ss, String id) {
        this(new MessageEvent("CountermeasureAssertion", ss).toMessage(), id);
    }

    public CountermeasureAssertion(MessageEvent event) {
        this(event.toMessage());
    }

    public CountermeasureAssertion(Message message) {
        this(message, message.get("id").asString());
    }

    private CountermeasureAssertion(Message message, String id) {
        super(message.set("id", Objects.requireNonNull(id, "Assertion Id cannot be null")));
    }

    public String id() {
        return this.message.get("id").asString();
    }

    @Override
    public CountermeasureAssertion ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    @Override
    public CountermeasureAssertion ss(String ss) {
        super.ss(ss);
        return this;
    }

    public boolean enabled() {
        return this.message.get("enabled").asOptional(Boolean.TYPE).orElse(true);
    }

    public CountermeasureAssertion enabled(boolean enabled) {
        this.message.set("enabled", enabled);
        return this;
    }

    public static CountermeasureAssertion fromString(String event) {
        return new CountermeasureAssertion(new MessageReader(event).next());
    }

    public String condition() {
        return !this.message.contains("condition") ? null : this.message.get("condition").asString();
    }

    public String priority() {
        return !this.message.contains("priority") ? null : this.message.get("priority").asString();
    }

    public List<Actuation> actuationList() {
        if (this.actuationList != null) {
            return this.actuationList;
        }
        this.actuationList = new ArrayList<Actuation>((Collection)this.message.components("Actuation").stream().map(c -> new Actuation((Message)c)).collect(Collectors.toList())){

            @Override
            public boolean add(Actuation element) {
                super.add(element);
                CountermeasureAssertion.this.message.add(element.toMessage());
                return true;
            }

            @Override
            public void add(int index, Actuation element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Actuation)) {
                    return false;
                }
                super.remove(o);
                CountermeasureAssertion.this.message.remove(((Actuation)o).toMessage());
                return true;
            }

            @Override
            public Actuation remove(int index) {
                Actuation type = (Actuation)this.get(index);
                this.remove(type);
                return type;
            }

            @Override
            public boolean removeIf(Predicate<? super Actuation> filter) {
                return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((Actuation)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                c.forEach(this::remove);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends Actuation> c) {
                c.forEach(this::add);
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends Actuation> c) {
                throw new UnsupportedOperationException();
            }
        };
        return this.actuationList;
    }

    public CountermeasureAssertion condition(String condition) {
        if (condition == null) {
            this.message.remove("condition");
        } else {
            this.message.set("condition", condition);
        }
        return this;
    }

    public CountermeasureAssertion priority(String priority) {
        if (priority == null) {
            this.message.remove("priority");
        } else {
            this.message.set("priority", priority);
        }
        return this;
    }

    public CountermeasureAssertion actuationList(List<Actuation> actuation) {
        new ArrayList<Actuation>(this.actuationList()).forEach((Consumer<Actuation>)((Consumer<Object>)v -> this.actuationList.remove(v)));
        this.actuationList.addAll(actuation);
        return this;
    }

    @Override
    public Message toMessage() {
        return super.toMessage();
    }

    public static class Actuation
    implements Serializable {
        protected Message message;

        public Actuation() {
            this.message = new Message("Actuation");
        }

        public Actuation(Message message) {
            this.message = message;
        }

        public String id() {
            return !this.message.contains("id") ? null : this.message.get("id").asString();
        }

        public String name() {
            return !this.message.contains("name") ? null : this.message.get("name").asString();
        }

        public String label() {
            return !this.message.contains("label") ? null : this.message.get("label").asString();
        }

        public String target() {
            return !this.message.contains("target") ? null : this.message.get("target").asString();
        }

        public Integer tries() {
            return this.message.get("tries").asInteger();
        }

        public Integer tryInterval() {
            return this.message.get("tryInterval").asInteger();
        }

        public String extraCondition() {
            return !this.message.contains("extraCondition") ? null : this.message.get("extraCondition").asString();
        }

        public Actuation id(String id) {
            if (id == null) {
                this.message.remove("id");
            } else {
                this.message.set("id", id);
            }
            return this;
        }

        public Actuation name(String name) {
            if (name == null) {
                this.message.remove("name");
            } else {
                this.message.set("name", name);
            }
            return this;
        }

        public Actuation label(String label) {
            if (label == null) {
                this.message.remove("label");
            } else {
                this.message.set("label", label);
            }
            return this;
        }

        public Actuation target(String target) {
            if (target == null) {
                this.message.remove("target");
            } else {
                this.message.set("target", target);
            }
            return this;
        }

        public Actuation tries(Integer tries) {
            this.message.set("tries", tries);
            return this;
        }

        public Actuation tryInterval(Integer tryInterval) {
            this.message.set("tryInterval", tryInterval);
            return this;
        }

        public Actuation extraCondition(String extraCondition) {
            if (extraCondition == null) {
                this.message.remove("extraCondition");
            } else {
                this.message.set("extraCondition", extraCondition);
            }
            return this;
        }

        public Message toMessage() {
            return this.message;
        }
    }
}

