/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.messages.messaging;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Notification
extends MessageEvent
implements Serializable {
    private List<Recipient> recipientList = null;
    private List<Property> propertyList = null;
    private List<Attachment> attachmentList = null;

    public Notification(String ss) {
        this(new MessageEvent("Notification", ss).toMessage());
    }

    public Notification(MessageEvent event) {
        this(event.toMessage());
    }

    public Notification(Message message) {
        super(message);
    }

    private Notification(Message message, String id) {
        super(message.set("id", Objects.requireNonNull(id, "Assertion Id cannot be null")));
    }

    @Override
    public Notification ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    @Override
    public Notification ss(String ss) {
        super.ss(ss);
        return this;
    }

    public static Notification fromString(String event) {
        return new Notification(new MessageReader(event).next());
    }

    public String id() {
        return !this.message.contains("id") ? null : this.message.get("id").asString();
    }

    @Override
    public String type() {
        return !this.message.contains("type") ? null : this.message.get("type").asString();
    }

    public Channel channel() {
        return !this.message.contains("channel") ? null : Channel.valueOf(this.message.get("channel").asString());
    }

    public Language language() {
        return !this.message.contains("language") ? null : Language.valueOf(this.message.get("language").asString());
    }

    public Recipient recipient() {
        List<Message> components = this.message.components("Recipient");
        return components.isEmpty() ? null : new Recipient(components.get(0));
    }

    public List<Property> propertyList() {
        if (this.propertyList != null) {
            return this.propertyList;
        }
        this.propertyList = new ArrayList<Property>((Collection)this.message.components("Property").stream().map(c -> new Property((Message)c)).collect(Collectors.toList())){

            @Override
            public boolean add(Property element) {
                super.add(element);
                Notification.this.message.add(element.toMessage());
                return true;
            }

            @Override
            public void add(int index, Property element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Property)) {
                    return false;
                }
                super.remove(o);
                Notification.this.message.remove(((Property)o).toMessage());
                return true;
            }

            @Override
            public Property remove(int index) {
                Property type = (Property)this.get(index);
                this.remove(type);
                return type;
            }

            @Override
            public boolean removeIf(Predicate<? super Property> filter) {
                return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((Property)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                c.forEach(this::remove);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends Property> c) {
                c.forEach(this::add);
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends Property> c) {
                throw new UnsupportedOperationException();
            }
        };
        return this.propertyList;
    }

    public List<Attachment> attachmentList() {
        if (this.attachmentList != null) {
            return this.attachmentList;
        }
        this.attachmentList = new ArrayList<Attachment>((Collection)this.message.components("Attachment").stream().map(c -> new Attachment((Message)c)).collect(Collectors.toList())){

            @Override
            public boolean add(Attachment element) {
                super.add(element);
                Notification.this.message.add(element.toMessage());
                return true;
            }

            @Override
            public void add(int index, Attachment element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Attachment)) {
                    return false;
                }
                super.remove(o);
                Notification.this.message.remove(((Attachment)o).toMessage());
                return true;
            }

            @Override
            public Attachment remove(int index) {
                Attachment type = (Attachment)this.get(index);
                this.remove(type);
                return type;
            }

            @Override
            public boolean removeIf(Predicate<? super Attachment> filter) {
                return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((Attachment)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                c.forEach(this::remove);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends Attachment> c) {
                c.forEach(this::add);
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends Attachment> c) {
                throw new UnsupportedOperationException();
            }
        };
        return this.attachmentList;
    }

    public Notification id(String id) {
        if (id == null) {
            this.message.remove("id");
        } else {
            this.message.set("id", id);
        }
        return this;
    }

    public Notification type(String type) {
        if (type == null) {
            this.message.remove("type");
        } else {
            this.message.set("type", type);
        }
        return this;
    }

    public Notification channel(Channel channel) {
        if (channel == null) {
            this.message.remove("channel");
        } else {
            this.message.set("channel", channel.name());
        }
        return this;
    }

    public Notification language(Language language) {
        if (language == null) {
            this.message.remove("language");
        } else {
            this.message.set("language", language.name());
        }
        return this;
    }

    public Notification recipient(Recipient recipient) {
        this.message.components("Recipient").forEach(v -> this.message.remove((Message)v));
        if (recipient != null) {
            this.message.add(recipient.toMessage());
        }
        return this;
    }

    public Notification propertyList(List<Property> property) {
        new ArrayList<Property>(this.propertyList()).forEach((Consumer<Property>)((Consumer<Object>)v -> this.propertyList.remove(v)));
        this.propertyList.addAll(property);
        return this;
    }

    public Notification attachmentList(List<Attachment> attachment) {
        new ArrayList<Attachment>(this.attachmentList()).forEach((Consumer<Attachment>)((Consumer<Object>)v -> this.attachmentList.remove(v)));
        this.attachmentList.addAll(attachment);
        return this;
    }

    @Override
    public Message toMessage() {
        return super.toMessage();
    }

    public static enum Channel {
        Email,
        Push;

    }

    public static enum Language {
        en,
        es,
        pt;

    }

    public static class Recipient
    implements Serializable {
        protected Message message;

        public Recipient() {
            this.message = new Message("Recipient");
        }

        public Recipient(Message message) {
            this.message = message;
        }

        public String email() {
            return !this.message.contains("email") ? null : this.message.get("email").asString();
        }

        public String deviceToken() {
            return !this.message.contains("deviceToken") ? null : this.message.get("deviceToken").asString();
        }

        public List<String> cc() {
            return new ArrayList<String>(this.message.contains("cc") ? Arrays.asList(this.message.get("cc").as(String[].class)) : Collections.emptyList()){

                @Override
                public boolean add(String value) {
                    super.add(value);
                    message.append("cc", value);
                    return true;
                }

                @Override
                public void add(int index, String element) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean remove(Object value) {
                    if (!(value instanceof String)) {
                        return false;
                    }
                    super.remove(value);
                    message.remove("cc", value);
                    return true;
                }

                @Override
                public String remove(int index) {
                    String type = (String)this.get(index);
                    this.remove(type);
                    return type;
                }

                @Override
                public boolean removeIf(Predicate<? super String> filter) {
                    return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((String)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    c.forEach(this::remove);
                    return true;
                }

                @Override
                public boolean addAll(Collection<? extends String> c) {
                    c.forEach(this::add);
                    return true;
                }

                @Override
                public boolean addAll(int index, Collection<? extends String> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void clear() {
                    super.clear();
                    message.remove("cc");
                }
            };
        }

        public List<String> bcc() {
            return new ArrayList<String>(this.message.contains("bcc") ? Arrays.asList(this.message.get("bcc").as(String[].class)) : Collections.emptyList()){

                @Override
                public boolean add(String value) {
                    super.add(value);
                    message.append("bcc", value);
                    return true;
                }

                @Override
                public void add(int index, String element) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean remove(Object value) {
                    if (!(value instanceof String)) {
                        return false;
                    }
                    super.remove(value);
                    message.remove("bcc", value);
                    return true;
                }

                @Override
                public String remove(int index) {
                    String type = (String)this.get(index);
                    this.remove(type);
                    return type;
                }

                @Override
                public boolean removeIf(Predicate<? super String> filter) {
                    return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((String)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    c.forEach(this::remove);
                    return true;
                }

                @Override
                public boolean addAll(Collection<? extends String> c) {
                    c.forEach(this::add);
                    return true;
                }

                @Override
                public boolean addAll(int index, Collection<? extends String> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void clear() {
                    super.clear();
                    message.remove("bcc");
                }
            };
        }

        public Recipient email(String email) {
            if (email == null) {
                this.message.remove("email");
            } else {
                this.message.set("email", email);
            }
            return this;
        }

        public Recipient deviceToken(String deviceToken) {
            if (deviceToken == null) {
                this.message.remove("deviceToken");
            } else {
                this.message.set("deviceToken", deviceToken);
            }
            return this;
        }

        public Recipient cc(List<String> cc) {
            this.message.set("cc", cc);
            return this;
        }

        public Recipient bcc(List<String> bcc) {
            this.message.set("bcc", bcc);
            return this;
        }

        public Message toMessage() {
            return this.message;
        }
    }

    public static class Attachment
    implements Serializable {
        protected Message message;

        public Attachment() {
            this.message = new Message("Attachment");
        }

        public Attachment(Message message) {
            this.message = message;
        }

        public String name() {
            return !this.message.contains("name") ? null : this.message.get("name").asString();
        }

        public Type type() {
            return !this.message.contains("type") ? null : Type.valueOf(this.message.get("type").asString());
        }

        public String value() {
            return !this.message.contains("value") ? null : this.message.get("value").asString();
        }

        public Attachment name(String name) {
            if (name == null) {
                this.message.remove("name");
            } else {
                this.message.set("name", name);
            }
            return this;
        }

        public Attachment type(Type type) {
            if (type == null) {
                this.message.remove("type");
            } else {
                this.message.set("type", type.name());
            }
            return this;
        }

        public Attachment value(String value) {
            if (value == null) {
                this.message.remove("value");
            } else {
                this.message.set("value", value);
            }
            return this;
        }

        public Message toMessage() {
            return this.message;
        }

        public static enum Type {
            Text,
            File;

        }
    }

    public static class Property
    implements Serializable {
        protected Message message;

        public Property() {
            this.message = new Message("Property");
        }

        public Property(Message message) {
            this.message = message;
        }

        public String name() {
            return !this.message.contains("name") ? null : this.message.get("name").asString();
        }

        public String value() {
            return !this.message.contains("value") ? null : this.message.get("value").asString();
        }

        public Property name(String name) {
            if (name == null) {
                this.message.remove("name");
            } else {
                this.message.set("name", name);
            }
            return this;
        }

        public Property value(String value) {
            if (value == null) {
                this.message.remove("value");
            } else {
                this.message.set("value", value);
            }
            return this;
        }

        public Message toMessage() {
            return this.message;
        }
    }
}

