/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.datamarts.master;

import io.intino.cosmos.datahub.datamarts.master.MasterDatamart;
import io.intino.ness.master.model.Concept;
import io.intino.ness.master.model.Entity;
import io.intino.ness.master.reflection.AttributeDefinition;
import io.intino.ness.master.reflection.EntityDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public abstract class MasterEntity
implements Entity {
    private final String id;
    private final MasterDatamart datamart;
    private final Map<String, Attribute> attributes;
    private List<Concept.ChangeListener> listeners;
    private static final Set<String> ExcludedAttributeNames = Set.of("id", "enabled", "ts", "ss");

    public MasterEntity(String id, MasterDatamart datamart) {
        this.id = id;
        this.datamart = datamart;
        this.attributes = this.createAllAttributes();
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public boolean enabled() {
        return this.attribute("enabled").value().as(Boolean.class);
    }

    @Override
    public MasterDatamart datamart() {
        return this.datamart;
    }

    @Override
    public Concept.Attribute attribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public List<Concept.Attribute> attributes() {
        return new ArrayList<Concept.Attribute>(this.attributes.values());
    }

    @Override
    public void addChangeListener(Concept.ChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("ChangeListener cannot be null");
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<Concept.ChangeListener>(1);
        }
        this.listeners.add(listener);
    }

    synchronized void addAttribute(final String name, Object value) {
        if (ExcludedAttributeNames.contains(name)) {
            return;
        }
        this.attributes.put(name, new Attribute(name, value));
        List<AttributeDefinition> attributeDefinitions = this.getDefinition().declaredAttributes();
        if (attributeDefinitions.stream().anyMatch(a -> a.name().equals(name))) {
            return;
        }
        attributeDefinitions.add(new AttributeDefinition(){

            @Override
            public String name() {
                return name;
            }

            @Override
            public Class<?> type() {
                return String.class;
            }

            public String toString() {
                return name;
            }
        });
    }

    synchronized void updateAttribute(String name, Object newValue) {
        Attribute attribute = this.attributes.get(name);
        if (attribute == null) {
            this.addAttribute(name, newValue);
            return;
        }
        if (name.equals("id")) {
            return;
        }
        Concept.Attribute.Value oldValue = attribute.value();
        attribute.setValue(newValue);
        if (!oldValue.equals(attribute.value())) {
            this.notifyChangeListeners(attribute, oldValue);
        }
    }

    private void notifyChangeListeners(Attribute attribute, Concept.Attribute.Value oldValue) {
        if (this.listeners == null) {
            return;
        }
        for (Concept.ChangeListener listener : this.listeners) {
            try {
                listener.onChange(this, attribute, oldValue);
            }
            catch (Throwable throwable) {}
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.id.equals(((Entity)o).id());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id;
    }

    protected Collection<Attribute> initDeclaredAttributes() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute("id", this.id));
        attributes.add(new Attribute("enabled", true));
        return attributes;
    }

    private Map<String, Attribute> createAllAttributes() {
        Collection<Attribute> declaredAttribs = this.initDeclaredAttributes();
        Map<String, Attribute> attributes = Collections.synchronizedMap(new LinkedHashMap(2 + declaredAttribs.size()));
        declaredAttribs.forEach(attr -> attributes.put(attr.name(), (Attribute)attr));
        return attributes;
    }

    protected final class Attribute
    implements Concept.Attribute {
        private final String name;
        private Concept.Attribute.Value value;
        private List<Concept.Attribute.ChangeListener> listeners;

        public Attribute(String name) {
            this(name, null);
        }

        public Attribute(String name, Object initialValue) {
            this.name = name;
            this.value = new Concept.Attribute.Value(initialValue);
        }

        @Override
        public AttributeDefinition getDefinition() {
            return MasterEntity.this.getDefinition().attribute(this.name).get();
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Concept.Attribute.Value value() {
            return this.value;
        }

        @Override
        public void addChangeListener(Concept.Attribute.ChangeListener listener) {
            if (listener == null) {
                throw new NullPointerException("ChangeListener cannot be null");
            }
            if (this.listeners == null) {
                this.listeners = new ArrayList<Concept.Attribute.ChangeListener>(1);
            }
            this.listeners.add(listener);
        }

        private void setValue(Object newValue) {
            Concept.Attribute.Value oldValue = this.value;
            this.value = new Concept.Attribute.Value(newValue);
            if (!oldValue.equals(newValue)) {
                this.notifyChangeListeners(oldValue, this.value);
            }
        }

        private void notifyChangeListeners(Concept.Attribute.Value oldValue, Concept.Attribute.Value newValue) {
            if (this.listeners == null) {
                return;
            }
            for (Concept.Attribute.ChangeListener listener : this.listeners) {
                try {
                    listener.onValueChange(oldValue, newValue);
                }
                catch (Throwable throwable) {}
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Attribute other = (Attribute)o;
            return this.name().equals(other.name()) && this.type().equals(other.type()) && this.value.equals(other.value());
        }

        public int hashCode() {
            return Objects.hash(this.name(), this.type(), this.value());
        }

        public String toString() {
            return this.type().getSimpleName() + " " + this.name() + " = " + this.value();
        }
    }

    protected static final class EntityDefinitionInternal
    implements EntityDefinition {
        private final String entityName;

        public EntityDefinitionInternal(String entityName) {
            this.entityName = entityName;
        }

        @Override
        public boolean isAbstract() {
            return this.definition().isAbstract();
        }

        @Override
        public String fullName() {
            return this.definition().fullName();
        }

        @Override
        public String name() {
            return this.definition().name();
        }

        @Override
        public List<AttributeDefinition> declaredAttributes() {
            return this.definition().declaredAttributes();
        }

        @Override
        public Optional<EntityDefinition> parent() {
            return this.definition().parent();
        }

        @Override
        public List<EntityDefinition> ancestors() {
            return this.definition().ancestors();
        }

        @Override
        public List<EntityDefinition> descendants() {
            return this.definition().descendants();
        }

        @Override
        public Class<?> javaClass() {
            return this.definition().javaClass();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof EntityDefinition) {
                return o.equals(this.definition());
            }
            return false;
        }

        public int hashCode() {
            return this.definition().hashCode();
        }

        private EntityDefinition definition() {
            return MasterDatamart.definition.entity(this.entityName).orElseThrow(() -> new IllegalStateException("MasterDatamart is not initialized"));
        }
    }
}

