/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.terminal;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import io.intino.alexandria.Json;
import io.intino.alexandria.logger.Logger;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.TextMessage;
import java.lang.reflect.Type;
import java.util.Map;

public interface RequestAttendant {
    public static final Type asMap = new TypeToken<Map<String, JsonElement>>(){}.getType();
    public static final RequestAttendant NullAttendant = new RequestAttendant(){

        @Override
        public String id() {
            return null;
        }

        @Override
        public RequestResult responseTo(Message request) {
            return new RequestResult(false, "operation not found");
        }

        @Override
        public boolean isAvailable(Message parameters) {
            return false;
        }
    };

    default public Map<String, JsonElement> parameters(Message request) throws JMSException {
        return (Map)Json.fromJson(request.getStringProperty("parameters"), asMap);
    }

    default public String parameter(Message request, String name) throws JMSException {
        JsonElement o = this.parameters(request).get(name);
        return o instanceof JsonPrimitive ? o.getAsString() : null;
    }

    default public <T> T parameter(Message request, String name, Class<T> type) throws JMSException {
        JsonElement o = this.parameters(request).get(name);
        return o instanceof JsonObject ? (T)Json.fromJson(o, type) : null;
    }

    public String id();

    public RequestResult responseTo(Message var1);

    public boolean isAvailable(Message var1);

    public static String getText(Message m) {
        try {
            return ((TextMessage)m).getText();
        }
        catch (JMSException e) {
            Logger.error(e);
            return "";
        }
    }

    public record RequestResult(boolean success, Object response) {
    }
}

