/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.os.remote;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import io.intino.consul.framework.Activity;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.List;

record RemoteProcessRunner(Session session) implements Activity.System.ProcessRunner
{
    @Override
    public String execute(String ... command) throws Exception {
        return this.execute(Arrays.asList(command));
    }

    @Override
    public synchronized String execute(List<String> command) throws Exception {
        if (!this.session.isConnected()) {
            this.session.connect();
        }
        ByteArrayOutputStream response = new ByteArrayOutputStream();
        this.sendCommand(command, response);
        return response.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCommand(List<String> command, ByteArrayOutputStream response) throws JSchException, InterruptedException {
        block9: {
            ChannelExec channel = null;
            String cmd = String.join((CharSequence)" ", command);
            try {
                channel = this.send(cmd, response);
            }
            catch (JSchException e) {
                if (e.getMessage().contains("Packet corrupt")) {
                    channel = this.send(cmd, response);
                    break block9;
                }
                throw e;
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                if (channel != null) {
                    channel.disconnect();
                }
            }
        }
    }

    private ChannelExec send(String command, ByteArrayOutputStream response) throws JSchException, InterruptedException {
        ChannelExec channel = (ChannelExec)this.session.openChannel("exec");
        channel.setCommand(command);
        channel.setOutputStream(response);
        channel.connect(120000);
        while (channel.isConnected()) {
            Thread.sleep(100L);
        }
        return channel;
    }
}

