/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.os.remote;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.os.remote.RemoteFileSystem;
import io.intino.consul.container.box.os.remote.RemoteProcessRunner;
import io.intino.consul.container.box.os.remote.linux.LinuxOSProcess;
import io.intino.consul.framework.Activity;
import io.intino.consul.framework.utils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import oshi.driver.linux.proc.UpTime;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;

public class RemoteOperatingSystem
implements Activity.System.OperatingSystem {
    private final RemoteProcessRunner processRunner;
    private final Session session;
    private final RemoteFileSystem remoteFileSystem;
    private final long bootTime;
    private long userHz;
    private long pageSize;
    private static Set<String> systemProcesses;
    private Activity.System.OperatingSystem.Name name;
    public static final Pattern DIGITS;

    public RemoteOperatingSystem(Session session) {
        this.session = session;
        this.remoteFileSystem = new RemoteFileSystem(session);
        this.processRunner = new RemoteProcessRunner(session);
        this.bootTime = this.booTime();
        if (systemProcesses == null || systemProcesses.isEmpty()) {
            systemProcesses = this.systemProcesses();
        }
        try {
            this.name = this.processRunner().execute("uname").trim().equals("Linux") ? Activity.System.OperatingSystem.Name.Unix : Activity.System.OperatingSystem.Name.Mac;
        }
        catch (Exception e) {
            this.name = Activity.System.OperatingSystem.Name.Unix;
        }
        this.updateProperties();
    }

    @Override
    public Activity.System.OperatingSystem.Name name() {
        return this.name;
    }

    @Override
    public long bootTimeSeconds() {
        return this.bootTime;
    }

    @Override
    public Activity.System.FileSystem fileSystem() throws IOException {
        return this.remoteFileSystem;
    }

    @Override
    public Activity.System.ProcessRunner processRunner() {
        return this.processRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int createConnection(int port) {
        Session session = this.session;
        synchronized (session) {
            try {
                if (this.contains(port)) {
                    return port;
                }
                return this.session.setPortForwardingL(port, "localhost", port);
            }
            catch (JSchException e) {
                Logger.error(e.getMessage());
                return 0;
            }
        }
    }

    private boolean contains(int port) {
        try {
            return Arrays.stream(this.session.getPortForwardingL()).anyMatch(l -> l.contains(port + ":"));
        }
        catch (JSchException e) {
            Logger.error(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnection(int port) {
        Session session = this.session;
        synchronized (session) {
            try {
                if (!this.contains(port)) {
                    this.session.delPortForwardingL(port);
                }
            }
            catch (JSchException e) {
                Logger.error(e.getMessage());
            }
        }
    }

    @Override
    public List<? extends Activity.System.OSProcess> processes() throws IOException {
        return this.getPidFiles().stream().map(this::linuxOSProcess).filter(Objects::nonNull).toList();
    }

    private LinuxOSProcess linuxOSProcess(File f) {
        try {
            return new LinuxOSProcess(f, this, systemProcesses);
        }
        catch (Exception e) {
            Logger.error(f.getPath() + ": " + e.getMessage());
            return null;
        }
    }

    private List<File> getPidFiles() throws IOException {
        File directory = new File("/proc");
        return this.fileSystem().listDirectory(directory.getAbsolutePath()).stream().filter(file -> DIGITS.matcher((CharSequence)file).matches()).map(n -> new File(directory, (String)n)).toList();
    }

    @Override
    public int processCount() {
        return 0;
    }

    private long booTime() {
        long tempBT = this.bootTimeFromProc();
        if (tempBT == 0L) {
            tempBT = System.currentTimeMillis() / 1000L - (long)UpTime.getSystemUptimeSeconds();
        }
        return tempBT;
    }

    public long bootTimeFromProc() {
        try {
            return this.fileSystem().readFile("/proc/stat").lines().filter(stat -> stat.startsWith("btime")).findFirst().map(t2 -> ParseUtil.parseLongOrDefault(ParseUtil.whitespaces.split((CharSequence)t2)[1], 0L)).orElse(0L);
        }
        catch (IOException e) {
            Logger.error(e.getMessage());
            return 0L;
        }
    }

    @Override
    public long userHz() {
        return this.userHz;
    }

    @Override
    public long pageSize() {
        return this.pageSize;
    }

    @Override
    public Activity.System.Measurements measurements() {
        String command = String.join((CharSequence)";echo -----;", "free -m", "df -m .", "iostat -c", "sysctl fs.file-nr", "ps -eo nlwp | tail -n +2 | awk '{ num_threads += $1 } END { print num_threads }'", "cat /sys/class/net/eth0/statistics/tx_bytes", "cat /sys/class/net/eth0/statistics/rx_bytes", "uptime");
        try {
            final String[] results = (String[])Arrays.stream(this.processRunner.execute(command).trim().split("-----")).map(String::trim).toArray(String[]::new);
            return new Activity.System.Measurements(){

                @Override
                public long usageRAM() {
                    try {
                        return RemoteOperatingSystem.usage(results[0]).intValue();
                    }
                    catch (Exception e) {
                        Logger.error(e.getMessage());
                        return 0L;
                    }
                }

                @Override
                public long usageHDD() {
                    try {
                        return RemoteOperatingSystem.usage(results[1]).intValue();
                    }
                    catch (Exception e) {
                        Logger.error(e.getMessage());
                        return 0L;
                    }
                }

                @Override
                public double usageCPU() {
                    try {
                        String[] iostat = results[2].trim().split("\n");
                        String[] values = (String[])Arrays.stream(iostat[iostat.length - 1].split(" ")).map(String::trim).filter(f -> !f.isEmpty()).toArray(String[]::new);
                        if (values.length > 0 && Utils.isNumber(values[0])) {
                            return (long)Double.parseDouble(values[0]);
                        }
                    }
                    catch (Exception e) {
                        Logger.error(e.getMessage());
                    }
                    return 0.0;
                }

                @Override
                public double usageSystem() {
                    try {
                        String trim = results[7].trim();
                        String averages = trim.substring(trim.lastIndexOf(":") + 1);
                        Double[] array = (Double[])Arrays.stream(averages.split(",")).map(String::trim).map(Double::parseDouble).toArray(Double[]::new);
                        return array[2];
                    }
                    catch (Throwable e) {
                        Logger.error(e);
                        return 0.0;
                    }
                }

                @Override
                public int usageFiles() {
                    try {
                        String[] files = (String[])Arrays.stream(results[3].split(" ")).map(String::trim).filter(f -> !f.isEmpty() || f.isBlank()).toArray(String[]::new);
                        if (files.length == 0) {
                            return 0;
                        }
                        String[] used = files[2].split("\t");
                        if (used.length > 0 && Utils.isNumber(used[0])) {
                            return Integer.parseInt(used[0]);
                        }
                    }
                    catch (Exception e) {
                        Logger.error(e.getMessage());
                    }
                    return 0;
                }

                @Override
                public long usageThreads() {
                    try {
                        String result = results[4].trim();
                        return Utils.isNumber(result) ? (long)Integer.parseInt(result) : 0L;
                    }
                    catch (Exception e) {
                        Logger.error(e.getMessage());
                        return 0L;
                    }
                }

                @Override
                public long dataReceived() {
                    try {
                        String result = results[5].trim();
                        return Utils.isNumber(result) ? Long.parseLong(result) / 0x100000L : 0L;
                    }
                    catch (Exception e) {
                        Logger.error(e.getMessage());
                        return 0L;
                    }
                }

                @Override
                public long dataSent() {
                    try {
                        String result = results[6].trim();
                        return Utils.isNumber(result) ? Long.parseLong(result) / 0x100000L : 0L;
                    }
                    catch (Exception e) {
                        Logger.error(e.getMessage());
                        return 0L;
                    }
                }

                @Override
                public double temperatureKernel() {
                    return 0.0;
                }

                @Override
                public double temperatureExternal() {
                    return 0.0;
                }
            };
        }
        catch (Exception e) {
            Logger.error(e);
            return null;
        }
    }

    private static Integer usage(String executed) {
        String[] lines = executed.split("\n");
        if (lines.length < 2) {
            return 0;
        }
        String[] values = (String[])Arrays.stream(lines[1].split(" ")).map(String::trim).filter(f -> !f.isEmpty()).toArray(String[]::new);
        if (values.length >= 3 && Utils.isNumber(values[2])) {
            return Integer.parseInt(values[2]);
        }
        return 0;
    }

    private void updateProperties() {
        try {
            Map<Integer, Long> auxv = this.queryAuxv();
            long hz = auxv.getOrDefault(17, 0L);
            this.userHz = hz > 0L ? hz : ParseUtil.parseLongOrDefault(this.processRunner.execute("getconf", "CLK_TCK"), 100L);
            long pageSize = auxv.getOrDefault(6, 0L);
            this.pageSize = pageSize > 0L ? pageSize : ParseUtil.parseLongOrDefault(this.processRunner.execute("getconf", "PAGE_SIZE"), 4096L);
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
        }
    }

    private Map<Integer, Long> queryAuxv() {
        try {
            int key;
            byte[] array = this.fileSystem().readFileBytes("/proc/self/auxv");
            ByteBuffer buff = ByteBuffer.wrap(array);
            HashMap<Integer, Long> auxvMap = new HashMap<Integer, Long>();
            do {
                if ((key = FileUtil.readNativeLongFromBuffer(buff).intValue()) <= 0) continue;
                auxvMap.put(key, FileUtil.readNativeLongFromBuffer(buff).longValue());
            } while (key > 0);
            return auxvMap;
        }
        catch (IOException e) {
            Logger.error(e);
            return Map.of();
        }
    }

    private Set<String> systemProcesses() {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(Activity.System.OperatingSystem.Name.Unix.name().toLowerCase() + ".system.processes.txt");
        if (stream == null) {
            Logger.error("Resource not found: " + Activity.System.OperatingSystem.Name.Unix.name().toLowerCase() + ".system.processes.txt");
            return Set.of();
        }
        return new BufferedReader(new InputStreamReader(stream)).lines().collect(Collectors.toSet());
    }

    static {
        DIGITS = Pattern.compile("\\d+");
    }
}

