/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.os.local;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.os.local.LocalOperatingSystem;
import io.intino.consul.framework.Activity;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;

public class LocalFileSystem
implements Activity.System.FileSystem {
    private final LocalOperatingSystem localOperatingSystem;

    public LocalFileSystem(LocalOperatingSystem localOperatingSystem) {
        this.localOperatingSystem = localOperatingSystem;
    }

    @Override
    public boolean exists(String path) {
        return new File(path).exists();
    }

    @Override
    public String readFile(String path) {
        try {
            Path filePath = Path.of(path, new String[0]);
            if (!filePath.toFile().exists()) {
                return null;
            }
            return Files.readString(filePath);
        }
        catch (IOException e) {
            Logger.error(e.getMessage());
            return null;
        }
    }

    @Override
    public byte[] readFileBytes(String path) {
        try {
            return Files.readAllBytes(Path.of(path, new String[0]));
        }
        catch (IOException e) {
            Logger.error(e);
            return new byte[0];
        }
    }

    @Override
    public InputStream openFile(String path) {
        try {
            return new FileInputStream(path);
        }
        catch (FileNotFoundException e) {
            Logger.error(e);
            return InputStream.nullInputStream();
        }
    }

    @Override
    public void writeString(String path, String content) {
        this.writeString(path, content, StandardOpenOption.CREATE);
    }

    @Override
    public void writeString(String path, String content, StandardOpenOption ... options) {
        try {
            Path filePath = Path.of(path, new String[0]);
            filePath.toFile().getParentFile().mkdirs();
            Files.writeString(filePath, (CharSequence)content, options);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    @Override
    public void changeOwner(String path, String user, String group) {
        if (this.localOperatingSystem.name() != Activity.System.OperatingSystem.Name.Unix) {
            return;
        }
        Path filePath = Path.of(path, new String[0]);
        UserPrincipalLookupService lookupService = filePath.getFileSystem().getUserPrincipalLookupService();
        try (Stream<Path> paths = Files.walk(filePath, new FileVisitOption[0]);){
            paths.forEach(p -> {
                try {
                    Files.setOwner(filePath, lookupService.lookupPrincipalByName(user));
                    GroupPrincipal groupPrincipal = lookupService.lookupPrincipalByGroupName(group);
                    if (groupPrincipal != null) {
                        PosixFileAttributeView fileAttributeView = Files.getFileAttributeView(filePath, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
                        fileAttributeView.setGroup(groupPrincipal);
                    }
                }
                catch (IOException e) {
                    Logger.error(e);
                }
            });
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    @Override
    public void copy(String source, String target, CopyOption ... options) {
        try {
            new File(target).getParentFile().mkdirs();
            Files.copy(Path.of(source, new String[0]), Path.of(target, new String[0]), options);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    @Override
    public void mkdirs(String path) {
        new File(path).mkdirs();
    }

    @Override
    public void delete(String path) {
        try {
            if (new File(path).exists()) {
                Files.delete(Path.of(path, new String[0]));
            }
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    @Override
    public void deleteDirectory(String path) {
        try {
            FileUtils.deleteDirectory(new File(path));
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    @Override
    public List<String> listDirectory(String path) {
        try {
            return Files.list(Path.of(path, new String[0])).map(p -> p.toFile().getName()).toList();
        }
        catch (IOException e) {
            Logger.error(e);
            return Collections.emptyList();
        }
    }
}

