/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.activity;

import io.intino.consul.container.box.ContainerStore;
import io.intino.consul.framework.Activity;
import java.lang.reflect.Type;
import java.util.stream.Stream;

public class ActivityStore
implements Activity.Store {
    private final ContainerStore store;
    private final String prefix;

    public ActivityStore(String activityID, ContainerStore store) {
        this.store = store;
        this.prefix = activityID + "#";
    }

    @Override
    public void put(String key, Object object) {
        this.store.put(this.prefix + key, object);
    }

    @Override
    public <T> T get(String key, Class<T> aClass) {
        return this.store.get(this.prefix + key, aClass);
    }

    @Override
    public <T> T get(String key, Type type) {
        return this.store.get(this.prefix + key, type);
    }

    @Override
    public Stream<String> keys() {
        return this.store.keys().filter(k -> k.startsWith(this.prefix)).map(k -> k.replace(this.prefix, ""));
    }

    @Override
    public void remove(String key) {
        this.store.remove(this.prefix + key);
    }
}

