/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.activity;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.activity.ManifestReader;
import io.intino.consul.container.box.activity.Version;
import io.intino.consul.container.box.schemas.Manifest;
import io.intino.consul.framework.Activity;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;

public class ActivityLoader {
    public Activity load(File jar) {
        try {
            if (!jar.exists()) {
                return null;
            }
            String mainClass = this.mainClass(jar);
            ClassLoader classLoader = ActivityLoader.createClassLoader(jar);
            return (Activity)classLoader.loadClass(mainClass).getConstructors()[0].newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | Error | IllegalAccessException | InstantiationException | InvocationTargetException | MalformedURLException e) {
            Logger.error(e);
            return null;
        }
    }

    public boolean isSuitable(File activityFile, String containerVersion) {
        try {
            Manifest manifest = this.loadManifest(new FileInputStream(activityFile));
            if (manifest == null) {
                return false;
            }
            Manifest.Container container = manifest.container();
            if (container == null) {
                return false;
            }
            if (new Version(container.minVersion()).compareTo(new Version(containerVersion)) > 0) {
                return false;
            }
            if (container.maxVersion() != null) {
                return new Version(container.maxVersion()).compareTo(new Version(containerVersion)) < 0;
            }
            return true;
        }
        catch (Exception e) {
            Logger.error(e);
            return false;
        }
    }

    private static ClassLoader createClassLoader(File jar) throws MalformedURLException {
        return new JarClassLoader(jar, ActivityLoader.class.getClassLoader());
    }

    private Manifest loadManifest(InputStream is) {
        try {
            JarEntry e;
            JarInputStream jar = new JarInputStream(is);
            while ((e = (JarEntry)jar.getNextEntry()) != null && !e.getName().equalsIgnoreCase("activity.xml")) {
            }
            if (e.getName().equals("activity.xml")) {
                return ManifestReader.of(new String(jar.readAllBytes()));
            }
        }
        catch (IOException e) {
            Logger.error(e);
        }
        return null;
    }

    private String mainClass(File jar) {
        String string;
        JarFile jarFile = new JarFile(jar);
        try {
            string = jarFile.getManifest().getMainAttributes().getValue("Main-Class");
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Logger.warn("Main class not found in " + jar);
                return null;
            }
        }
        jarFile.close();
        return string;
    }

    public static class JarClassLoader
    extends URLClassLoader {
        public JarClassLoader(File file, ClassLoader parent) {
            super(JarClassLoader.name(file), new URL[]{JarClassLoader.url(file)}, parent);
        }

        private static String name(File jar) {
            return "activity-" + jar.getName().replace(".jar", "-loader");
        }

        private static URL url(File jar) {
            try {
                return jar.toURI().toURL();
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
    }
}

