/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.event.resource;

import io.intino.alexandria.Resource;
import io.intino.alexandria.event.resource.ResourceHelper;
import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipResourceReader
implements Iterator<Resource>,
AutoCloseable {
    public static final String METADATA_EXTENSION = ".metadata";
    private final File file;
    private final ZipFile zipFile;
    private final Map<Object, ZipEntry> entries;
    private final Iterator<? extends ZipEntry> iterator;

    public ZipResourceReader(File file) throws IOException {
        this.file = file;
        this.zipFile = new ZipFile(file);
        this.entries = Collections.list(this.zipFile.entries()).stream().collect(Collectors.toMap(ZipEntry::getName, e -> e));
        this.iterator = this.entries.values().stream().filter(e -> !e.getName().endsWith(METADATA_EXTENSION)).sorted(Comparator.comparing(ZipEntry::getName)).iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Resource next() {
        return this.toResource(this.iterator.next());
    }

    private Resource toResource(ZipEntry entry) {
        Map<String, String> metadata = this.deserializeMetadata(entry);
        String name = entry.getName().substring(entry.getName().indexOf("#") + 1).replace("$", "/");
        Resource resource = new Resource(name, this.inputStreamProviderOf(entry));
        resource.metadata().putAll(metadata);
        return resource;
    }

    private Map<String, String> deserializeMetadata(ZipEntry entry) {
        ZipEntry metadataEntry = this.entries.get(entry.getName() + METADATA_EXTENSION);
        if (metadataEntry != null) {
            try {
                Map<String, String> metadata = ResourceHelper.deserializeMetadata(new String(this.zipFile.getInputStream(metadataEntry).readAllBytes(), StandardCharsets.UTF_8));
                if (metadata == null) {
                    return new HashMap<String, String>();
                }
                if (this.file != null) {
                    metadata.put("$file", this.file.getAbsolutePath());
                }
                return metadata;
            }
            catch (IOException e) {
                Logger.error(e);
            }
        }
        return new HashMap<String, String>();
    }

    private Resource.InputStreamProvider inputStreamProviderOf(ZipEntry entry) {
        return () -> {
            ZipFile zip = new ZipFile(this.file);
            return zip.getInputStream(zip.getEntry(entry.getName()));
        };
    }

    @Override
    public void close() throws Exception {
        this.zipFile.close();
    }
}

