/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.event.resource;

import io.intino.alexandria.event.EventWriter;
import io.intino.alexandria.event.resource.ResourceEvent;
import io.intino.alexandria.event.resource.ResourceHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ResourceEventWriter
implements EventWriter<ResourceEvent> {
    private static final String ENTRY_NAME_SEP = "$";
    private final ZipOutputStream zip;
    private final File file;

    public ResourceEventWriter(File file) throws IOException {
        this(file, true);
    }

    public ResourceEventWriter(File file, boolean append) throws IOException {
        this(EventWriter.IO.open(file, append), file);
    }

    public ResourceEventWriter(OutputStream outputStream) {
        this(outputStream, null);
    }

    public ResourceEventWriter(OutputStream outputStream, File file) {
        this.zip = new ZipOutputStream(outputStream);
        this.file = file;
    }

    @Override
    public void write(ResourceEvent event) throws IOException {
        this.writeResourceEntry(event);
        this.writeMetadataEntry(event);
    }

    private void writeResourceEntry(ResourceEvent event) throws IOException {
        ZipEntry entry = new ZipEntry(event.getREI().resourceId());
        this.zip.putNextEntry(entry);
        try (InputStream resourceData = event.resource().stream();){
            resourceData.transferTo(this.zip);
        }
    }

    private void writeMetadataEntry(ResourceEvent event) throws IOException {
        ZipEntry entry = new ZipEntry(event.getREI().resourceId() + ".metadata");
        this.zip.putNextEntry(entry);
        this.zip.write(ResourceHelper.serializeMetadata(event, this.file).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void flush() throws IOException {
        this.zip.flush();
    }

    @Override
    public void close() throws IOException {
        this.zip.close();
    }
}

