/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria;

import io.intino.alexandria.Scale;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Timetag
implements Comparable<Timetag> {
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyyMMdd000000");
    private final String tag;

    public Timetag(LocalDateTime dateTime, Scale scale) {
        this(dateTimeFormatter.format(dateTime).substring(0, Timetag.sizeOf(scale)));
    }

    public Timetag(Instant instant, Scale scale) {
        this(Timetag.toString(instant).substring(0, Timetag.sizeOf(scale)));
    }

    public Timetag(LocalDate date, Scale scale) {
        this(dateFormatter.format(date).substring(0, Timetag.sizeOf(scale)));
    }

    public Timetag(String tag) {
        this.tag = tag;
    }

    public static Timetag today() {
        return Timetag.now(Scale.Day);
    }

    public static Timetag now() {
        return Timetag.now(Scale.Minute);
    }

    public static Timetag now(Scale scale) {
        return new Timetag(LocalDateTime.now(), scale);
    }

    public static Timetag of(String tag) {
        if (tag == null) {
            throw new NullPointerException("Tag cannot be null");
        }
        if (!Timetag.isTimetag(tag)) {
            throw new IllegalArgumentException(tag + " is not a valid timetag. It should follow the pattern yyyy[MMddhhmmss]");
        }
        return new Timetag(tag);
    }

    public static Optional<Timetag> ofOptional(String tag) {
        return Timetag.isTimetag(tag) ? Optional.of(new Timetag(tag)) : Optional.empty();
    }

    public static Timetag of(LocalDateTime datetime, Scale scale) {
        return new Timetag(datetime, scale);
    }

    public static Timetag of(LocalDate date, Scale scale) {
        return new Timetag(date, scale);
    }

    public static Timetag of(Instant instant, Scale scale) {
        return new Timetag(instant, scale);
    }

    public static boolean isTimetag(String str) {
        try {
            new Timetag(str).datetime();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Stream<Timetag> range(String fromInclusive, String toInclusive) {
        Timetag from = Timetag.of(fromInclusive);
        Timetag to = Timetag.of(toInclusive);
        if (from.scale() != to.scale()) {
            throw new IllegalArgumentException("Both from and to timetags must have the same scale");
        }
        return Timetag.range(from, to);
    }

    public static Stream<Timetag> range(Timetag fromInclusive, Timetag toInclusive) {
        return StreamSupport.stream(fromInclusive.iterateTo(toInclusive).spliterator(), false);
    }

    public String value() {
        return this.tag;
    }

    public int year() {
        return Integer.parseInt(this.tag.substring(0, 4));
    }

    public int month() {
        return this.hasMonth() ? Integer.parseInt(this.tag.substring(4, 6)) : 1;
    }

    public int day() {
        return this.hasDay() ? Integer.parseInt(this.tag.substring(6, 8)) : 1;
    }

    public int hour() {
        return this.hasHour() ? Integer.parseInt(this.tag.substring(8, 10)) : 0;
    }

    public int minute() {
        return this.hasMinute() ? Integer.parseInt(this.tag.substring(10, 12)) : 0;
    }

    public boolean hasMonth() {
        return this.tag.length() >= Scale.Month.digits();
    }

    public boolean hasDay() {
        return this.tag.length() >= Scale.Day.digits();
    }

    public boolean hasHour() {
        return this.tag.length() >= Scale.Hour.digits();
    }

    public boolean hasMinute() {
        return this.tag.length() >= Scale.Minute.digits();
    }

    public Scale scale() {
        return Scale.of(this.tag.length());
    }

    private int precision() {
        return this.tag.length() - 4 >> 1;
    }

    public LocalDateTime datetime() {
        return LocalDateTime.of(this.year(), this.month(), this.day(), this.hour(), this.minute());
    }

    public Instant instant() {
        return this.datetime().toInstant(ZoneOffset.UTC);
    }

    public LocalDate date() {
        return this.datetime().toLocalDate();
    }

    public String label() {
        Object result = this.tag;
        for (int i = ((String)result).length(); i > 4; i -= 2) {
            result = ((String)result).substring(0, i - 2) + "-" + ((String)result).substring(i - 2);
        }
        return result;
    }

    public Timetag next() {
        return this.next(1);
    }

    public Timetag next(int count) {
        return count == 0 ? this : new Timetag(this.shift(count), this.scale());
    }

    public Timetag previous() {
        return this.previous(1);
    }

    public Timetag previous(int count) {
        return count == 0 ? this : new Timetag(this.shift(-count), this.scale());
    }

    public Iterable<Timetag> iterateTo(String timetag) {
        return this.iterateTo(Timetag.of(timetag));
    }

    public Iterable<Timetag> iterateTo(Timetag toInclusive) {
        if (this.equals(toInclusive)) {
            return Collections.singletonList(this);
        }
        if (this.isBefore(toInclusive)) {
            return () -> TimetagIterator.forward(this, toInclusive);
        }
        return () -> TimetagIterator.backwards(this, toInclusive);
    }

    public boolean isAfter(Timetag timetag) {
        return this.compareTo(timetag) > 0;
    }

    public boolean isBefore(Timetag timetag) {
        return this.compareTo(timetag) < 0;
    }

    private LocalDateTime shift(int amount) {
        return this.scale().temporalUnit().addTo(this.datetime(), amount);
    }

    public boolean isIn(Collection<Timetag> timetags) {
        return timetags.contains(this);
    }

    public boolean isBetween(String from, String toInclusive) {
        return this.isBetween(Timetag.of(from), Timetag.of(toInclusive));
    }

    public boolean isBetween(Timetag from, Timetag toInclusive) {
        return !this.isBefore(from) && !this.isAfter(toInclusive);
    }

    private static int sizeOf(Scale scale) {
        return scale.digits();
    }

    private static String toString(Instant instant) {
        return instant.toString().replaceAll("[-TZ.:]", "");
    }

    public boolean equals(Object o) {
        if (o instanceof Timetag) {
            return this.tag.equals(((Timetag)o).tag);
        }
        if (o instanceof String) {
            return this.tag.equals(o);
        }
        if (o instanceof Instant) {
            return this.tag.equals(new Timetag((Instant)((Instant)o), (Scale)this.scale()).tag);
        }
        if (o instanceof LocalDateTime) {
            return this.tag.equals(new Timetag((LocalDateTime)((LocalDateTime)o), (Scale)this.scale()).tag);
        }
        if (o instanceof LocalDate) {
            return this.tag.equals(new Timetag((LocalDate)((LocalDate)o), (Scale)this.scale()).tag);
        }
        return false;
    }

    public int hashCode() {
        return this.tag.hashCode();
    }

    public String toString() {
        return this.tag;
    }

    @Override
    public int compareTo(Timetag other) {
        return this.tag.compareTo(other.tag);
    }

    public int compare(Timetag timetag) {
        return this.compareTo(timetag);
    }

    private static class TimetagIterator
    implements Iterator<Timetag> {
        private Timetag current;
        private final Timetag target;
        private final int direction;

        public static TimetagIterator forward(Timetag from, Timetag to) {
            return new TimetagIterator(from, to, 1);
        }

        public static TimetagIterator backwards(Timetag from, Timetag to) {
            return new TimetagIterator(from, to, -1);
        }

        private TimetagIterator(Timetag current, Timetag target, int direction) {
            this.current = current;
            this.target = target;
            this.direction = direction;
        }

        @Override
        public boolean hasNext() {
            int cmp = this.target.compareTo(this.current);
            return cmp == 0 || Math.signum(cmp) == (float)this.direction;
        }

        @Override
        public Timetag next() {
            Timetag result = this.current;
            this.current = this.current.next(this.direction);
            return result;
        }
    }
}

