/*
 * Decompiled with CFR 0.152.
 */
package smile.feature.importance;

import java.util.stream.Stream;
import smile.base.cart.CART;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.formula.Formula;
import smile.feature.importance.SHAP;

public interface TreeSHAP
extends SHAP<Tuple> {
    public CART[] trees();

    public Formula formula();

    @Override
    default public double[] shap(Tuple x) {
        CART[] forest = this.trees();
        Tuple xt = this.formula().x(x);
        double[] phi = forest[0].shap(xt);
        for (int k = 1; k < forest.length; ++k) {
            double[] phii = forest[k].shap(xt);
            for (int i = 0; i < phi.length; ++i) {
                int n = i;
                phi[n] = phi[n] + phii[i];
            }
        }
        int i = 0;
        while (i < phi.length) {
            int n = i++;
            phi[n] = phi[n] / (double)forest.length;
        }
        return phi;
    }

    @Override
    default public double[] shap(DataFrame data) {
        this.formula().bind(data.schema());
        return this.shap((Stream)data.stream().parallel());
    }
}

