/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering.linkage;

import java.util.stream.IntStream;
import smile.math.MathEx;
import smile.math.distance.Distance;

public abstract class Linkage {
    int size;
    float[] proximity;

    public Linkage(double[][] proximity) {
        this.size = proximity.length;
        if (this.size > 65535) {
            throw new IllegalArgumentException("Data size " + this.size + " > 65535");
        }
        int length = (int)((long)this.size * (long)(this.size + 1) / 2L);
        this.proximity = new float[length];
        int k = 0;
        for (int j = 0; j < this.size; ++j) {
            int i = j;
            while (i < this.size) {
                this.proximity[k] = (float)proximity[i][j];
                ++i;
                ++k;
            }
        }
    }

    public Linkage(int size, float[] proximity) {
        if (proximity.length != size * (size + 1) / 2) {
            throw new IllegalArgumentException(String.format("The length of proximity is %d, expected %d", proximity.length, size * (size + 1) / 2));
        }
        this.size = size;
        this.proximity = proximity;
    }

    int index(int i, int j) {
        return i > j ? this.proximity.length - (this.size - j) * (this.size - j + 1) / 2 + i - j : this.proximity.length - (this.size - i) * (this.size - i + 1) / 2 + j - i;
    }

    public int size() {
        return this.size;
    }

    public float d(int i, int j) {
        return this.proximity[this.index(i, j)];
    }

    public abstract void merge(int var1, int var2);

    public static float[] proximity(double[][] data) {
        return Linkage.proximity(data, MathEx::distance);
    }

    public static <T> float[] proximity(T[] data, Distance<T> distance) {
        int n = data.length;
        if (n > 65535) {
            throw new IllegalArgumentException("Data size " + n + " > 65535");
        }
        int length = (int)((long)n * (long)(n + 1) / 2L);
        float[] proximity = new float[length];
        IntStream.range(0, n).parallel().forEach(i -> {
            for (int j = 0; j < i; ++j) {
                int k = length - (n - j) * (n - j + 1) / 2 + i - j;
                proximity[k] = (float)distance.d(data[i], data[j]);
            }
        });
        return proximity;
    }
}

