/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.representation;

import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.transform.DftNormalization;
import org.apache.commons.math3.transform.FastFourierTransformer;
import org.apache.commons.math3.transform.TransformType;
import ro.hasna.ts.math.representation.GenericTransformer;

public class DiscreteFourierTransform
implements GenericTransformer<double[], double[]> {
    private static final long serialVersionUID = -9081297024486191358L;
    private final FastFourierTransformer fourierTransformer;

    public DiscreteFourierTransform() {
        this(new FastFourierTransformer(DftNormalization.STANDARD));
    }

    public DiscreteFourierTransform(FastFourierTransformer fourierTransformer) {
        this.fourierTransformer = fourierTransformer;
    }

    @Override
    public double[] transform(double[] values) {
        int initialLength = values.length;
        int powerOfTwo = Integer.highestOneBit(initialLength);
        double[] copy = values;
        if (initialLength != powerOfTwo) {
            copy = new double[powerOfTwo <<= 1];
            System.arraycopy(values, 0, copy, 0, initialLength);
        }
        Complex[] complexes = this.fourierTransformer.transform(copy, TransformType.FORWARD);
        int outputLength = (powerOfTwo >> 1) + 1;
        double[] result = new double[outputLength];
        double k = 2.0 / (double)initialLength;
        result[0] = complexes[0].divide(initialLength).abs();
        for (int i = 1; i < outputLength && i < complexes.length; ++i) {
            result[i] = complexes[i].multiply(k).abs();
        }
        return result;
    }
}

