/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos.processors;

import io.intino.sumus.chronos.Magnitude;
import io.intino.sumus.chronos.Timeline;
import java.util.HashMap;
import java.util.Map;

public class Interpolator {
    private final Timeline timeline;

    public Interpolator(Timeline timeline) {
        this.timeline = timeline;
    }

    public Timeline execute() {
        return new Timeline.Builder(this.timeline.instants).put(this.valuesOf(this.timeline)).close();
    }

    private Map<Magnitude, double[]> valuesOf(Timeline timeline) {
        HashMap<Magnitude, double[]> result = new HashMap<Magnitude, double[]>();
        for (Magnitude magnitude : timeline.magnitudes()) {
            result.put(magnitude, new Operator(timeline.get((Magnitude)magnitude).values).execute());
        }
        return result;
    }

    public static class Operator {
        private final double[] values;

        public Operator(double[] values) {
            this.values = values;
        }

        public double[] execute() {
            double[] result = new double[this.values.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Operator.isNumber(this.values[i]) ? this.values[i] : this.interpolate(i);
            }
            return result;
        }

        private double interpolate(int i) {
            int left = this.firstLeftNumber(i - 1);
            int right = this.firstRightNumber(i + 1);
            return left >= 0 && right < this.values.length ? this.interpolate(left, i, right) : Double.NaN;
        }

        private double interpolate(int left, int i, int right) {
            return this.values[left] + this.f(i - left, right - left, this.values[right] - this.values[left]);
        }

        private int firstLeftNumber(int i) {
            while (i >= 0 && Double.isNaN(this.values[i])) {
                --i;
            }
            return i;
        }

        private int firstRightNumber(int i) {
            while (i < this.values.length && Double.isNaN(this.values[i])) {
                ++i;
            }
            return i;
        }

        private static boolean isNumber(double result) {
            return !Double.isNaN(result);
        }

        private double f(double d, double dx, double dy) {
            double c = dy / dx;
            double a = 2.0 * (c - dy / dx) / (dx * dx);
            double b = (3.0 * dy / dx - 2.0 * c - c) / dx;
            return a * d * d * d + b * d * d + c * d;
        }
    }
}

