/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos;

import io.intino.sumus.chronos.Period;
import io.intino.sumus.chronos.Reel;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ReelFile {
    private final File file;
    private final Header header;
    private final Instant from;

    private ReelFile(File file, List<Group> groups) {
        this.file = file;
        this.header = new Header(groups);
        this.from = this.readFirstInstantFrom(file);
    }

    public static ReelFile open(File file) throws IOException {
        return new ReelFile(file, Header.read(file));
    }

    public static ReelFile create(File file) throws IOException {
        Header.create(file);
        return new ReelFile(file, Collections.emptyList());
    }

    public ReelFile set(Instant instant, String group, String ... signals) throws IOException {
        return this.set(instant, this.header.get(group.hashCode()), signals);
    }

    public ReelFile set(Instant instant, Group group, String ... signals) throws IOException {
        ArrayList<Reel.Shot> shots = new ArrayList<Reel.Shot>();
        shots.addAll(group.shotsToTurnOff(instant, group.signalsThatAreNotIn(signals)));
        shots.addAll(group.shotsToTurnOn(instant, signals));
        return this.append(group, shots);
    }

    public ReelFile append(String header, Reel.Shot ... shots) throws IOException {
        return this.append(header, List.of(shots));
    }

    public ReelFile append(String group, List<Reel.Shot> shots) throws IOException {
        return this.append(this.header.get(group.hashCode()), shots);
    }

    private ReelFile append(Group group, List<Reel.Shot> shots) throws IOException {
        boolean dirty = false;
        this.header.add(group);
        for (Reel.Shot shot : shots) {
            if (group.get(ReelFile.hashOf(shot.signal)) == shot.state) continue;
            Files.write(this.file.toPath(), this.serialize(shot), StandardOpenOption.APPEND);
            if (shot.state == Reel.State.On) {
                group.put(shot.signal);
            } else {
                group.remove(shot.signal);
            }
            dirty = true;
        }
        if (dirty) {
            this.header.write(this.file);
        }
        return this;
    }

    private static Set<Integer> hashesOf(String[] signals) {
        return Stream.of(signals).map(String::hashCode).collect(Collectors.toSet());
    }

    public Instant start() {
        return this.from;
    }

    private static int hashOf(String signal) {
        return signal.startsWith("#") ? Integer.parseInt(signal.substring(1)) : signal.hashCode();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] serialize(Reel.Shot shot) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream dos = new DataOutputStream(bos);){
                dos.writeLong(shot.ts.getEpochSecond());
                dos.writeByte(shot.state == Reel.State.On ? 1 : 0);
                if (shot.state == Reel.State.On) {
                    dos.writeUTF(shot.signal);
                } else {
                    dos.writeInt(shot.hash);
                }
                byArray = bos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Processor reel(Instant from, Instant to) {
        return new Processor(from, to);
    }

    public Processor reel(Instant to) {
        return new Processor(this.from, to);
    }

    public Processor reel() {
        return new Processor(this.from, Instant.now());
    }

    public Reel.State stateOf(String signal) {
        return Reel.State.of(this.header.contains(signal));
    }

    private Instant readFirstInstantFrom(File file) {
        Instant instant;
        DataInputStream is = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        try {
            is.skip(4096L);
            long epochSecond = is.readLong();
            instant = Instant.ofEpochSecond(epochSecond);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return Instant.now();
            }
        }
        is.close();
        return instant;
    }

    private static class Header {
        private static final int SIZE = 4096;
        private final Map<Integer, Group> groups;

        public Header(List<Group> groups) {
            this.groups = groups.stream().collect(Collectors.toMap(h -> h.id, h -> h));
        }

        public void add(Group group) {
            if (this.groups.containsKey(group.id)) {
                return;
            }
            this.groups.put(group.id, group);
        }

        public boolean contains(String signal) {
            return this.groups.values().stream().anyMatch(g -> g.contains(signal));
        }

        public Group get(int id) {
            return this.groups.getOrDefault(id, new Group(id));
        }

        public static void create(File file) throws IOException {
            try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
                raf.write(new byte[4096]);
            }
        }

        public static List<Group> read(File file) {
            ArrayList<Group> list = new ArrayList<Group>();
            try (DataInputStream is = new DataInputStream(new FileInputStream(file));){
                int id;
                while ((id = is.readInt()) != 0) {
                    Group group = Header.read(id, is);
                    list.add(group);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return list;
        }

        private static Group read(int id, DataInputStream is) throws IOException {
            int signal;
            HashSet<Integer> set = new HashSet<Integer>();
            while ((signal = is.readInt()) != 0) {
                set.add(signal);
            }
            return new Group(id, set);
        }

        public void write(File file) throws IOException {
            try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
                raf.seek(0L);
                for (int id : this.groups.keySet()) {
                    raf.writeInt(id);
                    for (int signal : this.signalsOf(id)) {
                        raf.writeInt(signal);
                    }
                    raf.writeInt(0);
                }
                raf.writeInt(0);
            }
        }

        private Set<Integer> signalsOf(int name) {
            return this.get((int)name).signals;
        }
    }

    public class Processor {
        private final Instant from;
        private final Instant to;

        public Processor(Instant from, Instant to) {
            this.from = from;
            this.to = to;
        }

        public Reel by(Period period) {
            Reel.Builder builder = new Reel.Builder(this.from, this.to).by(period);
            try {
                DataInputStream is = new DataInputStream(new BufferedInputStream(new FileInputStream(ReelFile.this.file)));
                try {
                    is.skipBytes(4096);
                    while (true) {
                        long seconds = is.readLong();
                        byte state = is.readByte();
                        if (state == 1) {
                            String signal = is.readUTF();
                            builder.add(this.on(seconds, signal));
                            continue;
                        }
                        int signal = is.readInt();
                        builder.add(this.off(seconds, signal));
                    }
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                return builder.close();
            }
        }

        private Reel.Shot on(long seconds, String signal) {
            return new Reel.Shot(Instant.ofEpochSecond(seconds), Reel.State.On, signal);
        }

        private Reel.Shot off(long seconds, int signal) {
            return new Reel.Shot(Instant.ofEpochSecond(seconds), Reel.State.Off, signal);
        }
    }

    private static class Group {
        private final int id;
        private final Set<Integer> signals;

        public Group(int id) {
            this(id, new HashSet<Integer>());
        }

        public Group(int id, Set<Integer> signals) {
            this.id = id;
            this.signals = signals;
        }

        public Reel.State get(String signal) {
            return this.get(signal.hashCode());
        }

        public Reel.State get(int signal) {
            return Reel.State.of(this.contains(signal));
        }

        public void put(String signal) {
            this.put(signal.hashCode());
        }

        public void put(int signal) {
            if (this.contains(signal)) {
                return;
            }
            this.signals.add(signal);
        }

        public List<Reel.Shot> shotsToTurnOn(Instant now, String[] signals) {
            return Arrays.stream(signals).filter(s -> !s.isEmpty() && !this.contains((String)s)).map(s -> new Reel.Shot(now, Reel.State.On, (String)s)).collect(Collectors.toList());
        }

        private List<Reel.Shot> shotsToTurnOff(Instant now, Set<Integer> signals) {
            return signals.stream().map(s -> new Reel.Shot(now, Reel.State.Off, (int)s)).collect(Collectors.toList());
        }

        private Set<Integer> signalsThatAreNotIn(String[] signals) {
            HashSet<Integer> result = new HashSet<Integer>(this.signals);
            result.removeAll(ReelFile.hashesOf(signals));
            return result;
        }

        public void remove(String signal) {
            this.remove(ReelFile.hashOf(signal));
        }

        public void remove(int signal) {
            if (!this.contains(signal)) {
                return;
            }
            this.signals.remove(signal);
        }

        public boolean contains(String signal) {
            return this.signals.contains(signal.hashCode());
        }

        public boolean contains(int signal) {
            return this.signals.contains(signal);
        }

        public String toString() {
            return this.id + "-" + this.signals.size();
        }
    }
}

