/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos;

import io.intino.sumus.chronos.Period;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Reel {
    public final Instant from;
    public final Instant to;
    public final int step;
    private final int length;
    private final Map<String, byte[]> signals;
    private static final Map<Integer, String> Chunks = Reel.createChunks();

    private Reel(Instant from, Instant to, int step, int length, Map<String, byte[]> signals) {
        this.from = from;
        this.to = to;
        this.step = step;
        this.length = length;
        this.signals = signals;
    }

    public Set<String> signals() {
        return this.signals.keySet();
    }

    public String get(String signal) {
        return this.get(this.signals.getOrDefault(signal, new byte[0]));
    }

    private String get(byte[] states) {
        StringBuilder sb = new StringBuilder(this.length);
        for (byte state : states) {
            sb.append(Reel.chunk(state));
        }
        while (sb.length() < this.length) {
            sb.append(' ');
        }
        return sb.substring(0, this.length);
    }

    private static String chunk(int i) {
        return Chunks.get(i & 0xFF);
    }

    private static Map<Integer, String> createChunks() {
        return IntStream.range(0, 256).boxed().collect(Collectors.toMap(i -> i, Reel::createChunk));
    }

    private static String createChunk(int i) {
        return Integer.toBinaryString((i & 0xFF) + 256).substring(1).replace('0', ' ').replace('1', '-');
    }

    public static enum State {
        On,
        Off;


        public static State of(String value) {
            return State.of(value.equals("1"));
        }

        public static State of(boolean value) {
            return value ? On : Off;
        }
    }

    public static class Shot {
        public final Instant ts;
        public final String signal;
        public final int hash;
        public final State state;

        public Shot(Instant ts, State state, int signal) {
            this.ts = ts;
            this.state = state;
            this.signal = "#" + signal;
            this.hash = signal;
        }

        public Shot(Instant ts, State state, String signal) {
            this.ts = ts;
            this.state = state;
            this.signal = signal;
            this.hash = signal.hashCode();
        }

        public String toString() {
            return String.join((CharSequence)" ", this.ts.toString(), this.signal, this.state.toString());
        }
    }

    public static class Builder {
        private final Instant from;
        private final Instant to;
        private final Map<Integer, String> names;
        private final Map<Integer, byte[]> signals;
        private int step;

        public Builder(Instant from, Instant to) {
            this.from = from;
            this.to = to;
            this.step = 1;
            this.names = new HashMap<Integer, String>();
            this.signals = new HashMap<Integer, byte[]>();
        }

        public Builder add(Shot shot) {
            return shot.state == State.On ? this.on(shot.signal, shot.ts) : this.off(shot.hash, shot.ts);
        }

        public Builder on(String signal, Instant ts) {
            this.createSignalNameIfNotExists(signal.hashCode(), signal);
            return this.on(signal.hashCode(), ts);
        }

        private Builder on(int hash, Instant ts) {
            if (this.isInRange(ts)) {
                this.fillFrom(this.signalOf(hash), this.indexOf(ts), true);
            }
            return this;
        }

        public Builder off(String signal, Instant ts) {
            return this.off(signal.hashCode(), ts);
        }

        public Builder off(int hash, Instant ts) {
            if (this.isInRange(ts)) {
                this.fillFrom(this.signalOf(hash), this.indexOf(ts), false);
            }
            return this;
        }

        private boolean isInRange(Instant ts) {
            return ts.getEpochSecond() <= this.to.getEpochSecond();
        }

        private byte[] signalOf(int hash) {
            this.createIfNotExists(hash);
            return this.signals.get(hash);
        }

        private void createIfNotExists(int hash) {
            if (this.signals.containsKey(hash)) {
                return;
            }
            this.signals.put(hash, new byte[this.size()]);
        }

        private void createSignalNameIfNotExists(int hash, String signal) {
            if (this.names.containsKey(hash)) {
                return;
            }
            this.names.put(hash, signal);
        }

        private int size() {
            return (int)Math.ceil((double)this.length() / 8.0);
        }

        private int length() {
            return (int)this.indexOf(this.to);
        }

        private void fillFrom(byte[] values, long index, boolean set) {
            int position = (int)(index >> 3);
            if (position < 0 || position >= values.length) {
                return;
            }
            values[position] = set ? (byte)(values[position] | Builder.mask(Builder.offset(index))) : (byte)(values[position] & ~Builder.mask(Builder.offset(index)));
            byte value = (byte)(set ? 255 : 0);
            int size = this.size();
            for (int i = position + 1; i < size; ++i) {
                values[i] = value;
            }
        }

        private static byte offset(long index) {
            return (byte)(index & 7L);
        }

        private static byte mask(int offset) {
            return (byte)((1 << 8 - offset) - 1);
        }

        private long indexOf(Instant ts) {
            long index = (ts.getEpochSecond() - this.from.getEpochSecond()) / (long)this.step;
            return index >= 0L ? index : 0L;
        }

        public Reel close() {
            return new Reel(this.from, this.to, this.step, this.length(), this.consolidate());
        }

        private Map<String, byte[]> consolidate() {
            return this.signals.keySet().stream().filter(this::hasAnyNonZero).collect(Collectors.toMap(this.names::get, this.signals::get));
        }

        private boolean hasAnyNonZero(int hash) {
            return Builder.hasAnyNonZero(this.signals.get(hash));
        }

        private static boolean hasAnyNonZero(byte[] bytes) {
            return IntStream.range(0, bytes.length).anyMatch(i -> bytes[i] != 0);
        }

        public Builder by(Period period) {
            this.step = (int)period.duration();
            return this;
        }

        public Builder by(int seconds) {
            this.step = seconds;
            return this;
        }
    }
}

