/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos;

import io.intino.sumus.chronos.Magnitude;
import io.intino.sumus.chronos.TimeSeries;
import io.intino.sumus.chronos.Timeline;
import io.intino.sumus.chronos.filters.Denoise;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public interface Program {
    public Timeline run(Timeline var1);

    public static class Manual
    implements Program {
        private final List<Sentence> sentences = new ArrayList<Sentence>();

        public Manual add(Sentence sentence) {
            this.sentences.add(sentence);
            return this;
        }

        @Override
        public Timeline run(Timeline timeline) {
            return new Execution(timeline).execute();
        }

        public static Operator inverse() {
            return TimeSeries::inverse;
        }

        public static Operator negate() {
            return TimeSeries::negate;
        }

        public static Operator square() {
            return TimeSeries::square;
        }

        public static Operator differential() {
            return TimeSeries::differential;
        }

        public static Operator rateOfGrowth() {
            return TimeSeries::rateOfGrowth;
        }

        public static Operator log() {
            return TimeSeries::log;
        }

        public static Operator movingAverage(int observations) {
            return t2 -> t2.movingAverage(observations);
        }

        public static Operator movingAverage(double factor) {
            return t2 -> t2.movingAverage(factor);
        }

        public static Operator denoise(Denoise.Mode mode) {
            return t2 -> t2.denoise(mode);
        }

        public static Operator normalize() {
            return TimeSeries::normalize;
        }

        public static Operator normalize(double min, double max) {
            return t2 -> t2.normalize(min, max);
        }

        public static Operator standardize() {
            return TimeSeries::standardize;
        }

        public static Method all() {
            return timeline -> timeline;
        }

        public static Method total(Function<Magnitude, Magnitude> function) {
            return timeline -> timeline.compose(function);
        }

        public static Method total() {
            return timeline -> timeline.compose(m -> new Magnitude("total"));
        }

        public static class Sentence {
            public final Instruction instruction;
            private String source;
            private String target;

            private Sentence(Instruction instruction) {
                this.instruction = instruction;
            }

            public static Sentence calculate(Operator operator) {
                return new Sentence(operator);
            }

            public static Sentence include(Method method) {
                return new Sentence(method);
            }

            public void execute(Timeline input, Timeline.Builder builder) {
                if (this.instruction instanceof Operator) {
                    this.execute(builder, (Operator)this.instruction);
                }
                if (this.instruction instanceof Method) {
                    this.execute(input, builder, (Method)this.instruction);
                }
            }

            private void execute(Timeline timeline, Timeline.Builder builder, Method method) {
                Timeline result = method.execute(timeline);
                builder.put(result);
            }

            private void execute(Timeline.Builder builder, Operator operator) {
                Magnitude source = builder.get(this.source);
                Magnitude target = new Magnitude(this.target, source.model);
                TimeSeries result = operator.execute(builder.series(source));
                builder.put(target, result);
            }

            public Sentence of(String source) {
                this.source = source;
                return this;
            }

            public Sentence as(String target) {
                this.target = target;
                return this;
            }
        }

        public static interface Operator
        extends Instruction {
            public TimeSeries execute(TimeSeries var1);
        }

        public static interface Method
        extends Instruction {
            public Timeline execute(Timeline var1);
        }

        public static interface Instruction {
        }

        private class Execution {
            private final Timeline input;
            private final Timeline.Builder builder;

            Execution(Timeline timeline) {
                this.input = timeline;
                this.builder = new Timeline.Builder(this.input.instants);
            }

            Timeline execute() {
                Manual.this.sentences.forEach(sentence -> sentence.execute(this.input, this.builder));
                return this.builder.close();
            }
        }
    }
}

