/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.messages.monitoring;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Incident
extends MessageEvent
implements Serializable {
    public Incident(String ss) {
        this(new MessageEvent("Incident", ss).toMessage());
    }

    public Incident(MessageEvent event) {
        this(event.toMessage());
    }

    public Incident(Message message) {
        super(message);
    }

    private Incident(Message message, String id) {
        super(message.set("id", Objects.requireNonNull(id, "Assertion Id cannot be null")));
    }

    @Override
    public Incident ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    @Override
    public Incident ss(String ss) {
        super.ss(ss);
        return this;
    }

    public static Incident fromString(String event) {
        return new Incident(new MessageReader(event).next());
    }

    public String id() {
        return !this.message.contains("id") ? null : this.message.get("id").asString();
    }

    public String name() {
        return !this.message.contains("name") ? null : this.message.get("name").asString();
    }

    public String place() {
        return !this.message.contains("place") ? null : this.message.get("place").asString();
    }

    public String observable() {
        return !this.message.contains("observable") ? null : this.message.get("observable").asString();
    }

    public Level level() {
        return !this.message.contains("level") ? null : Level.valueOf(this.message.get("level").asString());
    }

    public String description() {
        return !this.message.contains("description") ? null : this.message.get("description").asString();
    }

    public List<String> variables() {
        return new ArrayList<String>(this.message.contains("variables") ? Arrays.asList(this.message.get("variables").as(String[].class)) : Collections.emptyList()){

            @Override
            public boolean add(String value) {
                super.add(value);
                Incident.this.message.append("variables", value);
                return true;
            }

            @Override
            public void add(int index, String element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object value) {
                if (!(value instanceof String)) {
                    return false;
                }
                super.remove(value);
                Incident.this.message.remove("variables", value);
                return true;
            }

            @Override
            public String remove(int index) {
                String type = (String)this.get(index);
                this.remove(type);
                return type;
            }

            @Override
            public boolean removeIf(Predicate<? super String> filter) {
                return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((String)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                c.forEach(this::remove);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends String> c) {
                c.forEach(this::add);
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends String> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                super.clear();
                Incident.this.message.remove("variables");
            }
        };
    }

    public String extraInfo() {
        return !this.message.contains("extraInfo") ? null : this.message.get("extraInfo").asString();
    }

    public Incident id(String id) {
        if (id == null) {
            this.message.remove("id");
        } else {
            this.message.set("id", id);
        }
        return this;
    }

    public Incident name(String name) {
        if (name == null) {
            this.message.remove("name");
        } else {
            this.message.set("name", name);
        }
        return this;
    }

    public Incident place(String place) {
        if (place == null) {
            this.message.remove("place");
        } else {
            this.message.set("place", place);
        }
        return this;
    }

    public Incident observable(String observable) {
        if (observable == null) {
            this.message.remove("observable");
        } else {
            this.message.set("observable", observable);
        }
        return this;
    }

    public Incident level(Level level) {
        if (level == null) {
            this.message.remove("level");
        } else {
            this.message.set("level", level.name());
        }
        return this;
    }

    public Incident description(String description) {
        if (description == null) {
            this.message.remove("description");
        } else {
            this.message.set("description", description);
        }
        return this;
    }

    public Incident variables(List<String> variables) {
        this.message.set("variables", variables);
        return this;
    }

    public Incident extraInfo(String extraInfo) {
        if (extraInfo == null) {
            this.message.remove("extraInfo");
        } else {
            this.message.set("extraInfo", extraInfo);
        }
        return this;
    }

    @Override
    public Message toMessage() {
        return super.toMessage();
    }

    public static enum Level {
        Low,
        Medium,
        High;

    }
}

