/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.messages.actuation;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Push
extends MessageEvent
implements Serializable {
    private List<Outsourcing> outsourcingList = null;

    public Push(String ss) {
        this(new MessageEvent("Push", ss).toMessage());
    }

    public Push(MessageEvent event) {
        this(event.toMessage());
    }

    public Push(Message message) {
        super(message);
    }

    private Push(Message message, String id) {
        super(message.set("id", Objects.requireNonNull(id, "Assertion Id cannot be null")));
    }

    @Override
    public Push ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    @Override
    public Push ss(String ss) {
        super.ss(ss);
        return this;
    }

    public static Push fromString(String event) {
        return new Push(new MessageReader(event).next());
    }

    public String id() {
        return !this.message.contains("id") ? null : this.message.get("id").asString();
    }

    public String code() {
        return !this.message.contains("code") ? null : this.message.get("code").asString();
    }

    public String dueDate() {
        return !this.message.contains("dueDate") ? null : this.message.get("dueDate").asString();
    }

    public String input() {
        return !this.message.contains("input") ? null : this.message.get("input").asString();
    }

    public String origin() {
        return !this.message.contains("origin") ? null : this.message.get("origin").asString();
    }

    public String observable() {
        return !this.message.contains("observable") ? null : this.message.get("observable").asString();
    }

    public Category category() {
        return !this.message.contains("category") ? null : Category.valueOf(this.message.get("category").asString());
    }

    public Outsourcing outsourcing() {
        List<Message> components = this.message.components("Outsourcing");
        return components.isEmpty() ? null : new Outsourcing(components.get(0));
    }

    public Push id(String id) {
        if (id == null) {
            this.message.remove("id");
        } else {
            this.message.set("id", id);
        }
        return this;
    }

    public Push code(String code) {
        if (code == null) {
            this.message.remove("code");
        } else {
            this.message.set("code", code);
        }
        return this;
    }

    public Push dueDate(String dueDate) {
        if (dueDate == null) {
            this.message.remove("dueDate");
        } else {
            this.message.set("dueDate", dueDate);
        }
        return this;
    }

    public Push input(String input) {
        if (input == null) {
            this.message.remove("input");
        } else {
            this.message.set("input", input);
        }
        return this;
    }

    public Push origin(String origin) {
        if (origin == null) {
            this.message.remove("origin");
        } else {
            this.message.set("origin", origin);
        }
        return this;
    }

    public Push observable(String observable) {
        if (observable == null) {
            this.message.remove("observable");
        } else {
            this.message.set("observable", observable);
        }
        return this;
    }

    public Push category(Category category) {
        if (category == null) {
            this.message.remove("category");
        } else {
            this.message.set("category", category.name());
        }
        return this;
    }

    public Push outsourcing(Outsourcing outsourcing) {
        this.message.components("Outsourcing").forEach(v -> this.message.remove((Message)v));
        if (outsourcing != null) {
            this.message.add(outsourcing.toMessage());
        }
        return this;
    }

    @Override
    public Message toMessage() {
        return super.toMessage();
    }

    public static enum Category {
        Preventive,
        Corrective,
        Administrative;

    }

    public static class Outsourcing
    implements Serializable {
        protected Message message;

        public Outsourcing() {
            this.message = new Message("Outsourcing");
        }

        public Outsourcing(Message message) {
            this.message = message;
        }

        public String recipient() {
            return !this.message.contains("recipient") ? null : this.message.get("recipient").asString();
        }

        public List<String> cc() {
            return new ArrayList<String>(this.message.contains("cc") ? Arrays.asList(this.message.get("cc").as(String[].class)) : Collections.emptyList()){

                @Override
                public boolean add(String value) {
                    super.add(value);
                    message.append("cc", value);
                    return true;
                }

                @Override
                public void add(int index, String element) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean remove(Object value) {
                    if (!(value instanceof String)) {
                        return false;
                    }
                    super.remove(value);
                    message.remove("cc", value);
                    return true;
                }

                @Override
                public String remove(int index) {
                    String type = (String)this.get(index);
                    this.remove(type);
                    return type;
                }

                @Override
                public boolean removeIf(Predicate<? super String> filter) {
                    return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((String)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    c.forEach(this::remove);
                    return true;
                }

                @Override
                public boolean addAll(Collection<? extends String> c) {
                    c.forEach(this::add);
                    return true;
                }

                @Override
                public boolean addAll(int index, Collection<? extends String> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void clear() {
                    super.clear();
                    message.remove("cc");
                }
            };
        }

        public List<String> bcc() {
            return new ArrayList<String>(this.message.contains("bcc") ? Arrays.asList(this.message.get("bcc").as(String[].class)) : Collections.emptyList()){

                @Override
                public boolean add(String value) {
                    super.add(value);
                    message.append("bcc", value);
                    return true;
                }

                @Override
                public void add(int index, String element) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean remove(Object value) {
                    if (!(value instanceof String)) {
                        return false;
                    }
                    super.remove(value);
                    message.remove("bcc", value);
                    return true;
                }

                @Override
                public String remove(int index) {
                    String type = (String)this.get(index);
                    this.remove(type);
                    return type;
                }

                @Override
                public boolean removeIf(Predicate<? super String> filter) {
                    return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((String)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    c.forEach(this::remove);
                    return true;
                }

                @Override
                public boolean addAll(Collection<? extends String> c) {
                    c.forEach(this::add);
                    return true;
                }

                @Override
                public boolean addAll(int index, Collection<? extends String> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void clear() {
                    super.clear();
                    message.remove("bcc");
                }
            };
        }

        public Outsourcing recipient(String recipient) {
            if (recipient == null) {
                this.message.remove("recipient");
            } else {
                this.message.set("recipient", recipient);
            }
            return this;
        }

        public Outsourcing cc(List<String> cc) {
            this.message.set("cc", cc);
            return this;
        }

        public Outsourcing bcc(List<String> bcc) {
            this.message.set("bcc", bcc);
            return this;
        }

        public Message toMessage() {
            return this.message;
        }
    }
}

