/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.messages.actuation;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class OperationExecuted
extends MessageEvent
implements Serializable {
    private List<Result> resultList = null;
    private List<Parameter> parameterList = null;

    public OperationExecuted(String ss) {
        this(new MessageEvent("OperationExecuted", ss).toMessage());
    }

    public OperationExecuted(MessageEvent event) {
        this(event.toMessage());
    }

    public OperationExecuted(Message message) {
        super(message);
    }

    private OperationExecuted(Message message, String id) {
        super(message.set("id", Objects.requireNonNull(id, "Assertion Id cannot be null")));
    }

    @Override
    public OperationExecuted ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    @Override
    public OperationExecuted ss(String ss) {
        super.ss(ss);
        return this;
    }

    public static OperationExecuted fromString(String event) {
        return new OperationExecuted(new MessageReader(event).next());
    }

    public String observable() {
        return !this.message.contains("observable") ? null : this.message.get("observable").asString();
    }

    public String activity() {
        return !this.message.contains("activity") ? null : this.message.get("activity").asString();
    }

    public String operation() {
        return !this.message.contains("operation") ? null : this.message.get("operation").asString();
    }

    public Result result() {
        List<Message> components = this.message.components("Result");
        return components.isEmpty() ? null : new Result(components.get(0));
    }

    public List<Parameter> parameterList() {
        if (this.parameterList != null) {
            return this.parameterList;
        }
        this.parameterList = new ArrayList<Parameter>((Collection)this.message.components("Parameter").stream().map(c -> new Parameter((Message)c)).collect(Collectors.toList())){

            @Override
            public boolean add(Parameter element) {
                super.add(element);
                OperationExecuted.this.message.add(element.toMessage());
                return true;
            }

            @Override
            public void add(int index, Parameter element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Parameter)) {
                    return false;
                }
                super.remove(o);
                OperationExecuted.this.message.remove(((Parameter)o).toMessage());
                return true;
            }

            @Override
            public Parameter remove(int index) {
                Parameter type = (Parameter)this.get(index);
                this.remove(type);
                return type;
            }

            @Override
            public boolean removeIf(Predicate<? super Parameter> filter) {
                return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((Parameter)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                c.forEach(this::remove);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends Parameter> c) {
                c.forEach(this::add);
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends Parameter> c) {
                throw new UnsupportedOperationException();
            }
        };
        return this.parameterList;
    }

    public OperationExecuted observable(String observable) {
        if (observable == null) {
            this.message.remove("observable");
        } else {
            this.message.set("observable", observable);
        }
        return this;
    }

    public OperationExecuted activity(String activity) {
        if (activity == null) {
            this.message.remove("activity");
        } else {
            this.message.set("activity", activity);
        }
        return this;
    }

    public OperationExecuted operation(String operation) {
        if (operation == null) {
            this.message.remove("operation");
        } else {
            this.message.set("operation", operation);
        }
        return this;
    }

    public OperationExecuted result(Result result) {
        this.message.components("Result").forEach(v -> this.message.remove((Message)v));
        if (result != null) {
            this.message.add(result.toMessage());
        }
        return this;
    }

    public OperationExecuted parameterList(List<Parameter> parameter) {
        new ArrayList<Parameter>(this.parameterList()).forEach((Consumer<Parameter>)((Consumer<Object>)v -> this.parameterList.remove(v)));
        this.parameterList.addAll(parameter);
        return this;
    }

    @Override
    public Message toMessage() {
        return super.toMessage();
    }

    public static class Result
    implements Serializable {
        protected Message message;

        public Result() {
            this.message = new Message("Result");
        }

        public Result(Message message) {
            this.message = message;
        }

        public Boolean success() {
            return this.message.get("success").asBoolean();
        }

        public String message() {
            return !this.message.contains("message") ? null : this.message.get("message").asString();
        }

        public Result success(Boolean success) {
            if (success == null) {
                this.message.remove("success");
            } else {
                this.message.set("success", success);
            }
            return this;
        }

        public Result message(String message) {
            if (message == null) {
                this.message.remove("message");
            } else {
                this.message.set("message", message);
            }
            return this;
        }

        public Message toMessage() {
            return this.message;
        }
    }

    public static class Parameter
    implements Serializable {
        protected Message message;

        public Parameter() {
            this.message = new Message("Parameter");
        }

        public Parameter(Message message) {
            this.message = message;
        }

        public String name() {
            return !this.message.contains("name") ? null : this.message.get("name").asString();
        }

        public String value() {
            return !this.message.contains("value") ? null : this.message.get("value").asString();
        }

        public Parameter name(String name) {
            if (name == null) {
                this.message.remove("name");
            } else {
                this.message.set("name", name);
            }
            return this;
        }

        public Parameter value(String value) {
            if (value == null) {
                this.message.remove("value");
            } else {
                this.message.set("value", value);
            }
            return this;
        }

        public Message toMessage() {
            return this.message;
        }
    }
}

