/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.datamarts.master.mounters;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.cosmos.datahub.datamarts.master.MasterDatamart;
import io.intino.cosmos.datahub.datamarts.master.MasterEntity;
import io.intino.cosmos.datahub.datamarts.master.MasterMounter;
import io.intino.cosmos.datahub.datamarts.master.entities.Area;
import io.intino.ness.master.Datamart;
import java.util.List;

public class AreaMounter
implements MasterMounter {
    private final MasterDatamart.Entities entities;
    private final List<Datamart.EntityListener> listeners;

    public AreaMounter(MasterDatamart.Entities entities, List<Datamart.EntityListener> listeners) {
        this.entities = entities;
        this.listeners = listeners;
    }

    @Override
    public void mount(Event event) {
        Message message = ((MessageEvent)event).toMessage();
        String id = message.get("id").asString();
        MasterMounter.Operation[] operation = new MasterMounter.Operation[]{MasterMounter.Operation.Update};
        MasterEntity entity = this.findOrCreateEntity(id, operation);
        this.updateAttributes(message, operation, entity);
        if (operation[0] != MasterMounter.Operation.Skip) {
            this.notifyListeners(operation[0], entity);
        }
    }

    private void updateAttributes(Message message, MasterMounter.Operation[] operation, MasterEntity owner) {
        for (String attr : message.attributes()) {
            this.update(owner, attr, this.parse(attr, message));
            if (!attr.equals("enabled") || message.get("enabled").asBoolean().booleanValue()) continue;
            operation[0] = operation[0] == MasterMounter.Operation.Create ? MasterMounter.Operation.Skip : MasterMounter.Operation.Remove;
            this.entities.remove(owner.id());
            return;
        }
    }

    private MasterEntity findOrCreateEntity(String id, MasterMounter.Operation[] operation) {
        Object entity = this.entities.get(Area.definition, id);
        if (entity == null) {
            entity = new Area(id, this.entities.datamart());
            this.entities.add((MasterEntity)entity);
            operation[0] = MasterMounter.Operation.Create;
        }
        return entity;
    }

    private void notifyListeners(MasterMounter.Operation operation, MasterEntity entity) {
        for (Datamart.EntityListener listener : this.listeners) {
            switch (operation) {
                case Create: {
                    listener.onCreate(entity);
                    break;
                }
                case Update: {
                    listener.onUpdate(entity);
                    break;
                }
                case Remove: {
                    listener.onRemove(entity);
                }
            }
        }
    }

    private Object parse(String attribute, Message message) {
        if (message.get(attribute).isNull()) {
            return null;
        }
        switch (attribute) {
            case "label": {
                return this.parseLabel(message);
            }
        }
        return message.get(attribute).asString();
    }

    private String parseLabel(Message m) {
        return m.get("label").as(String.class);
    }
}

