/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.datamarts.master;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.terminal.Connector;
import io.intino.alexandria.terminal.StubConnector;
import io.intino.alexandria.zim.ZimStream;
import io.intino.cosmos.datahub.ObserverTerminal;
import io.intino.cosmos.datahub.datamarts.master.MasterDatamart;
import io.intino.cosmos.datahub.datamarts.master.MasterMounter;
import io.intino.cosmos.datahub.datamarts.master.entities.Appliance;
import io.intino.cosmos.datahub.datamarts.master.entities.Application;
import io.intino.cosmos.datahub.datamarts.master.entities.Area;
import io.intino.cosmos.datahub.datamarts.master.entities.Asset;
import io.intino.cosmos.datahub.datamarts.master.entities.Computer;
import io.intino.cosmos.datahub.datamarts.master.entities.Hardware;
import io.intino.cosmos.datahub.datamarts.master.entities.IncidentRule;
import io.intino.cosmos.datahub.datamarts.master.entities.JavaApplication;
import io.intino.cosmos.datahub.datamarts.master.entities.Model;
import io.intino.cosmos.datahub.datamarts.master.entities.Observable;
import io.intino.cosmos.datahub.datamarts.master.entities.Observer;
import io.intino.cosmos.datahub.datamarts.master.entities.OrderType;
import io.intino.cosmos.datahub.datamarts.master.entities.Part;
import io.intino.cosmos.datahub.datamarts.master.entities.Person;
import io.intino.cosmos.datahub.datamarts.master.entities.Place;
import io.intino.cosmos.datahub.datamarts.master.entities.Process;
import io.intino.cosmos.datahub.datamarts.master.entities.Service;
import io.intino.cosmos.datahub.datamarts.master.entities.Software;
import io.intino.cosmos.datahub.datamarts.master.mounters.ApplianceMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.ApplicationMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.AreaMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.AssetMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.ComputerMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.HardwareMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.IncidentRuleMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.JavaApplicationMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.ModelMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.ObserverMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.OrderTypeMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.PartMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.PersonMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.PlaceMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.ProcessMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.ServiceMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.SoftwareMounter;
import io.intino.ness.master.Datamart;
import io.intino.ness.master.model.Entity;
import io.intino.ness.master.reflection.AttributeDefinition;
import io.intino.ness.master.reflection.ConceptDefinition;
import io.intino.ness.master.reflection.DatamartDefinition;
import io.intino.ness.master.reflection.EntityDefinition;
import io.intino.ness.master.reflection.StructDefinition;
import io.intino.sumus.chronos.Period;
import io.intino.sumus.chronos.Reel;
import io.intino.sumus.chronos.ReelFile;
import io.intino.sumus.chronos.Timeline;
import io.intino.sumus.chronos.TimelineFile;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.apache.activemq.command.ActiveMQTextMessage;

public class MasterDatamartImpl
implements MasterDatamart {
    private static final String DATAHUB_MESSAGE_TOPIC = "service.ness.datamarts";
    private static final MasterDatamartDefinition definition = new MasterDatamartDefinition();
    private static final Set<String> TIMELINE_EVENTS = Set.of("Computer", "Switch", "CellularGateway", "Wireless", "Camera", "Application");
    private static final Set<String> REEL_EVENTS = Set.of("status");
    private final Connector connector;
    private final ObserverTerminal.DatamartsRetryConfig retryConfig;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final List<Datamart.EntityListener> entityListeners = new ArrayList<Datamart.EntityListener>();
    private final Map<String, List<MasterMounter>> mounters = new HashMap<String, List<MasterMounter>>();
    private final MasterDatamart.Entities entities;
    private Instant ts;
    private final Map<String, TimelineNodeImpl> timelines = new ConcurrentHashMap<String, TimelineNodeImpl>();
    private final Map<String, ReelNodeImpl> reels = new ConcurrentHashMap<String, ReelNodeImpl>();

    public MasterDatamartImpl(Connector connector, ObserverTerminal.DatamartsRetryConfig retryConfig) {
        this.connector = Objects.requireNonNull(connector);
        this.retryConfig = Objects.requireNonNull(retryConfig);
        this.entities = new MasterDatamart.Entities(this);
        this.initMounters();
    }

    public synchronized MasterDatamartImpl init(String datamartSourceSelector) {
        try {
            if (!this.initialized.compareAndSet(false, true)) {
                return this;
            }
            this.downloadDatamartFromDatahub(datamartSourceSelector);
            Logger.info("MasterDatamart (" + (String)(this.snapshotTimetag().isEmpty() ? "" : "snapshot " + this.snapshotTimetag() + ", ") + this.connector.clientId() + ") initialized successfully.");
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError("MasterDatamart failed to start because a " + e.getClass().getName() + " occurred: " + e.getMessage());
        }
        return this;
    }

    @Override
    public int size() {
        return this.entities.size();
    }

    @Override
    public <T extends Entity> T get(String id) {
        return (T)this.entities.get(id);
    }

    @Override
    public Stream<Entity> entities() {
        return this.entities.streamGeneric();
    }

    @Override
    public void addEntityListener(Datamart.EntityListener listener) {
        if (listener == null) {
            throw new NullPointerException("EntityListener cannot be null");
        }
        this.entityListeners.add(listener);
    }

    @Override
    public DatamartDefinition getDefinition() {
        return definition;
    }

    @Override
    public List<String> listSnapshots() {
        try {
            Message message = this.requestResponseFromDatahub("listSnapshots", this.listSnapshotsRequest());
            if (!message.getBooleanProperty("success")) {
                throw new Exception(((TextMessage)message).getText());
            }
            return this.handleListSnapshotsResponse(message);
        }
        catch (Exception e) {
            Logger.error("Could not download list of available snapshots: " + e.getMessage(), e);
            return Collections.emptyList();
        }
    }

    private Message listSnapshotsRequest() throws Exception {
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setText("datamart=" + this.name() + ";operation=snapshots");
        return message;
    }

    private List<String> handleListSnapshotsResponse(Message message) throws Exception {
        return Arrays.stream(((TextMessage)message).getText().split(",")).collect(Collectors.toList());
    }

    @Override
    public synchronized MasterDatamart snapshot(final String timetag) {
        if (timetag == null) {
            return this;
        }
        return new MasterDatamartImpl(this.connector, this.retryConfig){

            @Override
            protected String snapshotTimetag() {
                return timetag;
            }

            @Override
            public synchronized MasterDatamart snapshot(String timetag2) {
                throw new UnsupportedOperationException("Cannot request snapshots to snapshot instances of a datamart");
            }
        }.init(null);
    }

    public Instant ts() {
        return this.ts;
    }

    @Override
    public Place place(String id) {
        return id == null ? null : (Place)this.entities.get(MasterDatamartImpl.definition.placeEntityDefinition, id);
    }

    @Override
    public Stream<Place> places() {
        return this.entities.stream(MasterDatamartImpl.definition.placeEntityDefinition);
    }

    @Override
    public Area area(String id) {
        return id == null ? null : (Area)this.entities.get(MasterDatamartImpl.definition.areaEntityDefinition, id);
    }

    @Override
    public Stream<Area> areas() {
        return this.entities.stream(MasterDatamartImpl.definition.areaEntityDefinition);
    }

    @Override
    public IncidentRule incidentRule(String id) {
        return id == null ? null : (IncidentRule)this.entities.get(MasterDatamartImpl.definition.incidentRuleEntityDefinition, id);
    }

    @Override
    public Stream<IncidentRule> incidentRules() {
        return this.entities.stream(MasterDatamartImpl.definition.incidentRuleEntityDefinition);
    }

    @Override
    public Model model(String id) {
        return id == null ? null : (Model)this.entities.get(MasterDatamartImpl.definition.modelEntityDefinition, id);
    }

    @Override
    public Stream<Model> models() {
        return this.entities.stream(MasterDatamartImpl.definition.modelEntityDefinition);
    }

    @Override
    public OrderType orderType(String id) {
        return id == null ? null : (OrderType)this.entities.get(MasterDatamartImpl.definition.orderTypeEntityDefinition, id);
    }

    @Override
    public Stream<OrderType> orderTypes() {
        return this.entities.stream(MasterDatamartImpl.definition.orderTypeEntityDefinition);
    }

    @Override
    public Observable observable(String id) {
        return id == null ? null : (Observable)this.entities.getDescendant(MasterDatamartImpl.definition.observableEntityDefinition, id);
    }

    @Override
    public Stream<Observable> observables() {
        return Stream.of(this.persons(), this.processes(), this.assets(), this.parts(), this.hardwares(), this.softwares()).flatMap(Function.identity());
    }

    @Override
    public Person person(String id) {
        return id == null ? null : (Person)this.entities.get(MasterDatamartImpl.definition.personEntityDefinition, id);
    }

    @Override
    public Stream<Person> persons() {
        return this.entities.stream(MasterDatamartImpl.definition.personEntityDefinition);
    }

    @Override
    public Process process(String id) {
        return id == null ? null : (Process)this.entities.get(MasterDatamartImpl.definition.processEntityDefinition, id);
    }

    @Override
    public Stream<Process> processes() {
        return this.entities.stream(MasterDatamartImpl.definition.processEntityDefinition);
    }

    @Override
    public Asset asset(String id) {
        return id == null ? null : (Asset)this.entities.get(MasterDatamartImpl.definition.assetEntityDefinition, id);
    }

    @Override
    public Stream<Asset> assets() {
        return this.entities.stream(MasterDatamartImpl.definition.assetEntityDefinition);
    }

    @Override
    public Part part(String id) {
        return id == null ? null : (Part)this.entities.get(MasterDatamartImpl.definition.partEntityDefinition, id);
    }

    @Override
    public Stream<Part> parts() {
        return this.entities.stream(MasterDatamartImpl.definition.partEntityDefinition);
    }

    @Override
    public Hardware hardware(String id) {
        return id == null ? null : (Hardware)this.entities.getDescendant(MasterDatamartImpl.definition.hardwareEntityDefinition, id);
    }

    @Override
    public Stream<Hardware> hardwares() {
        return Stream.of(this.entities.stream(MasterDatamartImpl.definition.hardwareEntityDefinition), this.appliances(), this.computers()).flatMap(Function.identity());
    }

    @Override
    public Appliance appliance(String id) {
        return id == null ? null : (Appliance)this.entities.get(MasterDatamartImpl.definition.applianceEntityDefinition, id);
    }

    @Override
    public Stream<Appliance> appliances() {
        return this.entities.stream(MasterDatamartImpl.definition.applianceEntityDefinition);
    }

    @Override
    public Computer computer(String id) {
        return id == null ? null : (Computer)this.entities.get(MasterDatamartImpl.definition.computerEntityDefinition, id);
    }

    @Override
    public Stream<Computer> computers() {
        return this.entities.stream(MasterDatamartImpl.definition.computerEntityDefinition);
    }

    @Override
    public Software software(String id) {
        return id == null ? null : (Software)this.entities.getDescendant(MasterDatamartImpl.definition.softwareEntityDefinition, id);
    }

    @Override
    public Stream<Software> softwares() {
        return Stream.of(this.entities.stream(MasterDatamartImpl.definition.softwareEntityDefinition), this.observers(), this.services(), this.applications()).flatMap(Function.identity());
    }

    @Override
    public Observer observer(String id) {
        return id == null ? null : (Observer)this.entities.get(MasterDatamartImpl.definition.observerEntityDefinition, id);
    }

    @Override
    public Stream<Observer> observers() {
        return this.entities.stream(MasterDatamartImpl.definition.observerEntityDefinition);
    }

    @Override
    public Service service(String id) {
        return id == null ? null : (Service)this.entities.get(MasterDatamartImpl.definition.serviceEntityDefinition, id);
    }

    @Override
    public Stream<Service> services() {
        return this.entities.stream(MasterDatamartImpl.definition.serviceEntityDefinition);
    }

    @Override
    public Application application(String id) {
        return id == null ? null : (Application)this.entities.getDescendant(MasterDatamartImpl.definition.applicationEntityDefinition, id);
    }

    @Override
    public Stream<Application> applications() {
        return Stream.of(this.entities.stream(MasterDatamartImpl.definition.applicationEntityDefinition), this.javaApplications()).flatMap(Function.identity());
    }

    @Override
    public JavaApplication javaApplication(String id) {
        return id == null ? null : (JavaApplication)this.entities.get(MasterDatamartImpl.definition.javaApplicationEntityDefinition, id);
    }

    @Override
    public Stream<JavaApplication> javaApplications() {
        return this.entities.stream(MasterDatamartImpl.definition.javaApplicationEntityDefinition);
    }

    @Override
    public Stream<MasterDatamart.TimelineNode> timelines(String id) {
        Stream<MasterDatamart.TimelineNode> stream = this.timelines.values().stream().filter(t2 -> t2.id.equals(id)).toList().stream();
        return stream;
    }

    @Override
    public MasterDatamart.TimelineNode computerTimeline(String id) {
        return this.timelines.computeIfAbsent(id + ":Computer", theId -> new TimelineNodeImpl(id, "Computer", Set.of("Computer", "ComputerAssertion")));
    }

    @Override
    public MasterDatamart.TimelineNode switchTimeline(String id) {
        return this.timelines.computeIfAbsent(id + ":Switch", theId -> new TimelineNodeImpl(id, "Switch", Set.of("Switch", "ApplianceAssertion")));
    }

    @Override
    public MasterDatamart.TimelineNode cellularGatewayTimeline(String id) {
        return this.timelines.computeIfAbsent(id + ":CellularGateway", theId -> new TimelineNodeImpl(id, "CellularGateway", Set.of("CellularGateway", "ApplianceAssertion")));
    }

    @Override
    public MasterDatamart.TimelineNode wirelessTimeline(String id) {
        return this.timelines.computeIfAbsent(id + ":Wireless", theId -> new TimelineNodeImpl(id, "Wireless", Set.of("Wireless", "ApplianceAssertion")));
    }

    @Override
    public MasterDatamart.TimelineNode cameraTimeline(String id) {
        return this.timelines.computeIfAbsent(id + ":Camera", theId -> new TimelineNodeImpl(id, "Camera", Set.of("Camera", "ApplianceAssertion")));
    }

    @Override
    public MasterDatamart.TimelineNode applicationTimeline(String id) {
        return this.timelines.computeIfAbsent(id + ":Application", theId -> new TimelineNodeImpl(id, "Application", Set.of("Application", "ApplicationAssertion")));
    }

    @Override
    public Stream<MasterDatamart.ReelNode> reels(String id) {
        Stream<MasterDatamart.ReelNode> stream = this.reels.values().stream().filter(r -> r.id.equals(id)).toList().stream();
        return stream;
    }

    @Override
    public MasterDatamart.ReelNode statusReel(String id) {
        return this.reels.computeIfAbsent(id + ":Status", theId -> new ReelNodeImpl(id, "Status", Set.of("Datalake#dl$status")));
    }

    @Override
    public Stream<MasterDatamart.ReelNode> statusReels() {
        Stream<MasterDatamart.ReelNode> stream = this.reels.values().stream().filter(r -> r.type.equals("Status")).toList().stream();
        return stream;
    }

    private void downloadDatamartFromDatahub(String datamartSourceSelector) {
        if (this.connector instanceof StubConnector) {
            return;
        }
        Logger.debug("Downloading datamart from datahub...");
        long start = System.currentTimeMillis();
        Logger.debug("Downloading entities...");
        int[] eventCount = new int[1];
        this.loadEntitiesFromEvents(this.downloadEntities(eventCount, datamartSourceSelector), eventCount);
        this.loadTimelinesFromDatahub();
        this.loadReelsFromDatahub();
        long time = System.currentTimeMillis() - start;
        Logger.debug("Datamart downloaded from datahub after " + time + " ms");
    }

    private void loadTimelinesFromDatahub() {
        Logger.debug("Downloading timelines...");
        for (String filename : this.listTimelineFiles()) {
            if (filename == null || filename.isBlank()) continue;
            try {
                File file = new File(filename);
                String id = file.getName().replace(".timeline", "");
                String type = file.getParentFile().getName();
                TimelineNodeImpl node = new TimelineNodeImpl(id, type, MasterDatamartImpl.sourcesOfTimeline(type), file.exists() ? file : null);
                this.timelines.put(id + ":" + type, node);
            }
            catch (Exception e) {
                Logger.debug("Could not load timeline " + filename + " -> " + e.getClass().getSimpleName() + ": " + e.getMessage());
            }
        }
        Logger.debug("Loaded " + this.timelines.size() + " timelines");
    }

    private String[] listTimelineFiles() {
        try {
            ActiveMQTextMessage request = new ActiveMQTextMessage();
            request.setText("datamart=" + this.name() + ";operation=list-timelines;");
            Message message = this.requestResponseFromDatahub("list-timelines", request);
            if (!message.getBooleanProperty("success")) {
                throw new Exception(((TextMessage)message).getText());
            }
            return ((TextMessage)message).getText().split(",");
        }
        catch (Exception e) {
            Logger.error(e);
            return new String[0];
        }
    }

    private void loadReelsFromDatahub() {
        Logger.debug("Downloading reels...");
        for (String filename : this.listReelFiles()) {
            if (filename == null || filename.isBlank()) continue;
            try {
                File file = new File(filename);
                String id = file.getName().replace(".reel", "");
                String type = file.getParentFile().getName();
                ReelNodeImpl node = new ReelNodeImpl(id, type, MasterDatamartImpl.sourcesOfReel(type), file.exists() ? file : null);
                this.reels.put(id + ":" + type, node);
            }
            catch (Exception e) {
                Logger.debug("Could not load reel " + filename + " -> " + e.getClass().getSimpleName() + ": " + e.getMessage());
            }
        }
        Logger.debug("Loaded " + this.reels.size() + " reels");
    }

    private String[] listReelFiles() {
        try {
            ActiveMQTextMessage request = new ActiveMQTextMessage();
            request.setText("datamart=" + this.name() + ";operation=list-reels;");
            Message message = this.requestResponseFromDatahub("list-reels", request);
            if (!message.getBooleanProperty("success")) {
                throw new Exception(((TextMessage)message).getText());
            }
            return ((TextMessage)message).getText().split(",");
        }
        catch (Exception e) {
            Logger.error(e);
            return new String[0];
        }
    }

    private Stream<Event> downloadEntities(int[] eventCount, String datamartSourceSelector) {
        try {
            Message message = this.requestResponseFromDatahub("downloadEvents", this.downloadEntitiesRequest(datamartSourceSelector));
            if (!message.getBooleanProperty("success")) {
                throw new Exception(((TextMessage)message).getText());
            }
            return this.handleDownloadResponse(message, eventCount);
        }
        catch (NullPointerException e) {
            throw new NullPointerException("Could not download datamart: no response from datahub.");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not download datamart: " + e.getMessage());
        }
    }

    private Message downloadEntitiesRequest(String datamartSourceSelector) throws Exception {
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setText("datamart=" + this.name() + ";operation=entities" + (String)(this.snapshotTimetag().isEmpty() ? "" : ";timetag=" + this.snapshotTimetag()) + (String)(datamartSourceSelector == null ? "" : ";sourceSelector=" + datamartSourceSelector));
        return message;
    }

    protected String snapshotTimetag() {
        return "";
    }

    private Stream<Event> handleDownloadResponse(Message message, int[] eventCount) throws Exception {
        BytesMessage m = (BytesMessage)message;
        eventCount[0] = m.getIntProperty("size");
        int size = m.getIntProperty("size");
        byte[] bytes = new byte[size];
        m.readBytes(bytes, size);
        return ZimStream.of(new ByteArrayInputStream(bytes)).map(MessageEvent::new);
    }

    private void loadEntitiesFromEvents(Stream<Event> events, int[] eventCount) {
        events.forEach(this::mount);
    }

    public synchronized void mount(Event event) {
        if (event == null) {
            return;
        }
        this.ts = event.ts();
        this.mountEntities(event);
        this.mountTimelines(event);
        this.mountReels(event);
    }

    private void mountReels(Event event) {
        String type;
        if (!REEL_EVENTS.contains(event.type())) {
            return;
        }
        String id = MasterDatamartImpl.sensorParameter(event.ss());
        String key = id + ":" + (type = event.type());
        if (!this.reels.containsKey(key)) {
            ReelNodeImpl node = new ReelNodeImpl(id, type, MasterDatamartImpl.sourcesOfReel(type), null);
            this.reels.put(key, node);
        }
        this.reels.values().forEach(reel -> reel.notifyEvent(event));
    }

    private void mountTimelines(Event event) {
        if (!TIMELINE_EVENTS.contains(event.type())) {
            return;
        }
        String id = MasterDatamartImpl.sensorParameter(event.ss());
        String type = event.type();
        TimelineNodeImpl node = this.timelines.computeIfAbsent(id + ":" + type, k -> new TimelineNodeImpl(id, type, MasterDatamartImpl.sourcesOfTimeline(type), null));
        node.notifyEvent(event);
    }

    private static String sensorParameter(String ss) {
        if (ss.contains("?")) {
            try {
                Map<String, String> map = Arrays.stream(ss.substring(ss.indexOf("?") + 1).split(";")).map(p -> p.split("=")).collect(Collectors.toMap(f -> f[0], f -> f[1]));
                if (map.containsKey("sensor")) {
                    return map.get("sensor");
                }
                ss.substring(0, ss.indexOf("?"));
            }
            catch (Exception e) {
                Logger.error(e);
            }
        }
        return ss;
    }

    private void mountEntities(Event event) {
        try {
            Optional.ofNullable(this.mounters.get(event.type())).ifPresent(mounters -> mounters.forEach(mounter -> mounter.mount(event)));
        }
        catch (Exception e) {
            Logger.error("Failed to mount event of type " + event.type() + ": " + e.getMessage(), e);
        }
    }

    private void initMounters() {
        this.mounters.computeIfAbsent("PlaceAssertion", type -> new ArrayList(1)).add(new PlaceMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("AreaAssertion", type -> new ArrayList(1)).add(new AreaMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("IncidentRuleAssertion", type -> new ArrayList(1)).add(new IncidentRuleMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ModelAssertion", type -> new ArrayList(1)).add(new ModelMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("OrderTypeAssertion", type -> new ArrayList(1)).add(new OrderTypeMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("PersonAssertion", type -> new ArrayList(1)).add(new PersonMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ProcessAssertion", type -> new ArrayList(1)).add(new ProcessMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("AssetAssertion", type -> new ArrayList(1)).add(new AssetMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("PartAssertion", type -> new ArrayList(1)).add(new PartMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("HardwareAssertion", type -> new ArrayList(1)).add(new HardwareMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ApplianceAssertion", type -> new ArrayList(1)).add(new ApplianceMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ComputerAssertion", type -> new ArrayList(1)).add(new ComputerMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("SoftwareAssertion", type -> new ArrayList(1)).add(new SoftwareMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ObserverAssertion", type -> new ArrayList(1)).add(new ObserverMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ServiceAssertion", type -> new ArrayList(1)).add(new ServiceMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ApplicationAssertion", type -> new ArrayList(1)).add(new ApplicationMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ApplicationJavaAssertion", type -> new ArrayList(1)).add(new JavaApplicationMounter(this.entities, this.entityListeners));
    }

    private static int availableThreads() {
        return Runtime.getRuntime().availableProcessors();
    }

    private Message requestResponseFromDatahub(String requestName, Message request) throws Exception {
        long timeout = this.retryConfig.initialTimeoutAmount;
        for (int i = 0; i < this.retryConfig.maxAttempts; ++i) {
            Message message = this.connector.requestResponse(DATAHUB_MESSAGE_TOPIC, request, timeout, this.retryConfig.timeoutUnit);
            if (message != null) {
                return message;
            }
            if (i < this.retryConfig.maxAttempts - 1) {
                Logger.warn("(" + (i + 1) + ") Datahub did not respond after " + timeout + " " + this.retryConfig.timeoutUnit + " to the request '" + requestName + "'. Trying again...");
            }
            timeout = (long)((float)timeout * this.retryConfig.timeoutMultiplier);
        }
        throw new RuntimeException("Datahub did not respond to the request '" + requestName + "' after " + this.retryConfig.maxAttempts);
    }

    private static Set<String> sourcesOfTimeline(String type) {
        return switch (type) {
            case "Computer" -> Set.of("Computer", "ComputerAssertion");
            case "Switch" -> Set.of("Switch", "ApplianceAssertion");
            case "CellularGateway" -> Set.of("CellularGateway", "ApplianceAssertion");
            case "Wireless" -> Set.of("Wireless", "ApplianceAssertion");
            case "Camera" -> Set.of("Camera", "ApplianceAssertion");
            case "Application" -> Set.of("Application", "ApplicationAssertion");
            default -> Collections.emptySet();
        };
    }

    private static Set<String> sourcesOfReel(String type) {
        return switch (type) {
            case "Status" -> Set.of("Datalake#dl$status");
            default -> Collections.emptySet();
        };
    }

    static {
        try {
            Object ref = MasterDatamart.class.getDeclaredField("definition").get(null);
            Field field = ref.getClass().getDeclaredField("definition");
            field.setAccessible(true);
            field.set(ref, definition);
            field.setAccessible(false);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError("Could not set MasterDatamart.definition field");
        }
    }

    public static final class MasterDatamartDefinition
    implements DatamartDefinition {
        public final EntityDefinition placeEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Place";
            }

            @Override
            public String name() {
                return "Place";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.empty();
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of();
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Place.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "id";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "enabled";
                    }

                    @Override
                    public Class<?> type() {
                        return Boolean.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "label";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "coordinates";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "timeOffset";
                    }

                    @Override
                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "region";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "city";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "area";
                    }

                    @Override
                    public Class<?> type() {
                        return Area.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "address";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "postalCode";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition areaEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Area";
            }

            @Override
            public String name() {
                return "Area";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.empty();
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of();
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Area.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "id";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "enabled";
                    }

                    @Override
                    public Class<?> type() {
                        return Boolean.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "label";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition incidentRuleEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "IncidentRule";
            }

            @Override
            public String name() {
                return "IncidentRule";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.empty();
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of();
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return IncidentRule.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "id";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "enabled";
                    }

                    @Override
                    public Class<?> type() {
                        return Boolean.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "description";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "target";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "model";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "level";
                    }

                    @Override
                    public Class<?> type() {
                        return IncidentRule.Level.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "tracking";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "triggers";
                    }

                    @Override
                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    @Override
                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            @Override
                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            @Override
                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "precondition";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "condition";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "countermeasures";
                    }

                    @Override
                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    @Override
                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            @Override
                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            @Override
                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "orderTypes";
                    }

                    @Override
                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    @Override
                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            @Override
                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            @Override
                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition modelEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Model";
            }

            @Override
            public String name() {
                return "Model";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.empty();
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of();
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Model.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "id";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "enabled";
                    }

                    @Override
                    public Class<?> type() {
                        return Boolean.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "type";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "target";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "profile";
                    }

                    @Override
                    public Class<?> type() {
                        return Model.Profile.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition orderTypeEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "OrderType";
            }

            @Override
            public String name() {
                return "OrderType";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.empty();
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of();
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return OrderType.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "id";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "enabled";
                    }

                    @Override
                    public Class<?> type() {
                        return Boolean.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition observableEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable";
            }

            @Override
            public String name() {
                return "Observable";
            }

            @Override
            public boolean isAbstract() {
                return true;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.empty();
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of();
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of(personEntityDefinition, processEntityDefinition, assetEntityDefinition, partEntityDefinition, hardwareEntityDefinition, applianceEntityDefinition, computerEntityDefinition, softwareEntityDefinition, observerEntityDefinition, serviceEntityDefinition, applicationEntityDefinition, javaApplicationEntityDefinition);
            }

            @Override
            public Class<?> javaClass() {
                return Observable.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "id";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "enabled";
                    }

                    @Override
                    public Class<?> type() {
                        return Boolean.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "label";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "place";
                    }

                    @Override
                    public Class<?> type() {
                        return Place.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "team";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "model";
                    }

                    @Override
                    public Class<?> type() {
                        return Model.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "container";
                    }

                    @Override
                    public Class<?> type() {
                        return Observable.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "observer";
                    }

                    @Override
                    public Class<?> type() {
                        return Observer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "responsible";
                    }

                    @Override
                    public Class<?> type() {
                        return Person.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "tags";
                    }

                    @Override
                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    @Override
                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            @Override
                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            @Override
                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "operationList";
                    }

                    @Override
                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    @Override
                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            @Override
                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.of(this.datamart().observable$OperationStructDefinition);
                            }

                            @Override
                            public Class<?> javaClass() {
                                return Observable.Operation.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition personEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable.Person";
            }

            @Override
            public String name() {
                return "Person";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.of(observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of(observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Person.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "area";
                    }

                    @Override
                    public Class<?> type() {
                        return Area.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "role";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "supervisor";
                    }

                    @Override
                    public Class<?> type() {
                        return Person.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "email";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "phone";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition processEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable.Process";
            }

            @Override
            public String name() {
                return "Process";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.of(observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of(observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Process.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList list = new ArrayList();
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition assetEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable.Asset";
            }

            @Override
            public String name() {
                return "Asset";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.of(observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of(observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Asset.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList list = new ArrayList();
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition partEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable.Part";
            }

            @Override
            public String name() {
                return "Part";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.of(observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of(observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Part.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList list = new ArrayList();
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition hardwareEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable.Hardware";
            }

            @Override
            public String name() {
                return "Hardware";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.of(observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of(observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of(applianceEntityDefinition, computerEntityDefinition);
            }

            @Override
            public Class<?> javaClass() {
                return Hardware.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "sn";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "ip";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "publicIp";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition applianceEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable.Hardware.Appliance";
            }

            @Override
            public String name() {
                return "Appliance";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.of(hardwareEntityDefinition);
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of(hardwareEntityDefinition, observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Appliance.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList list = new ArrayList();
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition computerEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable.Hardware.Computer";
            }

            @Override
            public String name() {
                return "Computer";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.of(hardwareEntityDefinition);
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of(hardwareEntityDefinition, observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Computer.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "architecture";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "os";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "cores";
                    }

                    @Override
                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "diskSize";
                    }

                    @Override
                    public Class<?> type() {
                        return Long.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "memorySize";
                    }

                    @Override
                    public Class<?> type() {
                        return Long.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "processes";
                    }

                    @Override
                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "maxOpenFiles";
                    }

                    @Override
                    public Class<?> type() {
                        return Long.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "jvm";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "isp";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition softwareEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable.Software";
            }

            @Override
            public String name() {
                return "Software";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.of(observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of(observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of(observerEntityDefinition, serviceEntityDefinition, applicationEntityDefinition, javaApplicationEntityDefinition);
            }

            @Override
            public Class<?> javaClass() {
                return Software.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList list = new ArrayList();
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition observerEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable.Software.Observer";
            }

            @Override
            public String name() {
                return "Observer";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.of(softwareEntityDefinition);
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of(softwareEntityDefinition, observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Observer.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "version";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "installedActivities";
                    }

                    @Override
                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    @Override
                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            @Override
                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            @Override
                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "enabledActivities";
                    }

                    @Override
                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    @Override
                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            @Override
                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            @Override
                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition serviceEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable.Software.Service";
            }

            @Override
            public String name() {
                return "Service";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.of(softwareEntityDefinition);
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of(softwareEntityDefinition, observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Service.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<1> list = new ArrayList<1>();
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "url";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition applicationEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable.Software.Application";
            }

            @Override
            public String name() {
                return "Application";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.of(softwareEntityDefinition);
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of(softwareEntityDefinition, observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of(javaApplicationEntityDefinition);
            }

            @Override
            public Class<?> javaClass() {
                return Application.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "name";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "user";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "systemService";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "startingTime";
                    }

                    @Override
                    public Class<?> type() {
                        return LocalDateTime.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "pid";
                    }

                    @Override
                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "commandLine";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "state";
                    }

                    @Override
                    public Class<?> type() {
                        return Application.State.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition javaApplicationEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable.Software.Application.JavaApplication";
            }

            @Override
            public String name() {
                return "JavaApplication";
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<EntityDefinition> parent() {
                return Optional.of(applicationEntityDefinition);
            }

            @Override
            public List<EntityDefinition> ancestors() {
                return List.of(applicationEntityDefinition, softwareEntityDefinition, observableEntityDefinition);
            }

            @Override
            public List<EntityDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return JavaApplication.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "classpathPrefix";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "mainArtifact";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "debugPort";
                    }

                    @Override
                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "jmxPort";
                    }

                    @Override
                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "minMemory";
                    }

                    @Override
                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "maxMemory";
                    }

                    @Override
                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "classpath";
                    }

                    @Override
                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    @Override
                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            @Override
                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            @Override
                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "inputArguments";
                    }

                    @Override
                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    @Override
                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            @Override
                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            @Override
                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "jvmParameter";
                    }

                    @Override
                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    @Override
                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            @Override
                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            @Override
                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "jvmVersion";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final StructDefinition model$ProfileStructDefinition = new StructDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Model$Profile";
            }

            @Override
            public String name() {
                return "Profile";
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<StructDefinition> parent() {
                return Optional.empty();
            }

            @Override
            public List<StructDefinition> ancestors() {
                return List.of();
            }

            @Override
            public List<StructDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Model.Profile.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<MasterDatamartDefinition.1> list = new ArrayList<MasterDatamartDefinition.1>();
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "variableList";
                    }

                    @Override
                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    @Override
                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            @Override
                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.of(this.datamart().model$Profile$VariableStructDefinition);
                            }

                            @Override
                            public Class<?> javaClass() {
                                return Model.Profile.Variable.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((StructDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final StructDefinition model$Profile$VariableStructDefinition = new StructDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Model$Profile$Variable";
            }

            @Override
            public String name() {
                return "Variable";
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<StructDefinition> parent() {
                return Optional.empty();
            }

            @Override
            public List<StructDefinition> ancestors() {
                return List.of();
            }

            @Override
            public List<StructDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Model.Profile.Variable.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "name";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "className";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "label";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "type";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "operator";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "unit";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "symbol";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "values";
                    }

                    @Override
                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    @Override
                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            @Override
                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            @Override
                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "min";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "max";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "description";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "format";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((StructDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final StructDefinition observable$OperationStructDefinition = new StructDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable$Operation";
            }

            @Override
            public String name() {
                return "Operation";
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<StructDefinition> parent() {
                return Optional.empty();
            }

            @Override
            public List<StructDefinition> ancestors() {
                return List.of();
            }

            @Override
            public List<StructDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Observable.Operation.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "activity";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "name";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "procedureList";
                    }

                    @Override
                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    @Override
                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            @Override
                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.of(this.datamart().observable$Operation$ProcedureStructDefinition);
                            }

                            @Override
                            public Class<?> javaClass() {
                                return Observable.Operation.Procedure.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((StructDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final StructDefinition observable$Operation$ProcedureStructDefinition = new StructDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable$Operation$Procedure";
            }

            @Override
            public String name() {
                return "Procedure";
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<StructDefinition> parent() {
                return Optional.empty();
            }

            @Override
            public List<StructDefinition> ancestors() {
                return List.of();
            }

            @Override
            public List<StructDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Observable.Operation.Procedure.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "name";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "returnType";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "description";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "parameterList";
                    }

                    @Override
                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    @Override
                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            @Override
                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.of(this.datamart().observable$Operation$Procedure$ParameterStructDefinition);
                            }

                            @Override
                            public Class<?> javaClass() {
                                return Observable.Operation.Procedure.Parameter.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((StructDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final StructDefinition observable$Operation$Procedure$ParameterStructDefinition = new StructDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            @Override
            public String fullName() {
                return "Observable$Operation$Procedure$Parameter";
            }

            @Override
            public String name() {
                return "Parameter";
            }

            @Override
            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            @Override
            public Optional<StructDefinition> parent() {
                return Optional.empty();
            }

            @Override
            public List<StructDefinition> ancestors() {
                return List.of();
            }

            @Override
            public List<StructDefinition> descendants() {
                return List.of();
            }

            @Override
            public Class<?> javaClass() {
                return Observable.Operation.Procedure.Parameter.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "type";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    @Override
                    public String name() {
                        return "name";
                    }

                    @Override
                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((StructDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };

        @Override
        public String name() {
            return "master";
        }

        @Override
        public Datamart.Scale scale() {
            return Datamart.Scale.Day;
        }

        @Override
        public DatamartDefinition.Query<EntityDefinition> entities() {
            return new DatamartDefinition.Query<EntityDefinition>(List.of(this.placeEntityDefinition, this.areaEntityDefinition, this.incidentRuleEntityDefinition, this.modelEntityDefinition, this.orderTypeEntityDefinition, this.observableEntityDefinition, this.personEntityDefinition, this.processEntityDefinition, this.assetEntityDefinition, this.partEntityDefinition, this.hardwareEntityDefinition, this.applianceEntityDefinition, this.computerEntityDefinition, this.softwareEntityDefinition, this.observerEntityDefinition, this.serviceEntityDefinition, this.applicationEntityDefinition, this.javaApplicationEntityDefinition));
        }

        @Override
        public DatamartDefinition.Query<StructDefinition> structs() {
            return new DatamartDefinition.Query<StructDefinition>(List.of(this.model$ProfileStructDefinition, this.model$Profile$VariableStructDefinition, this.observable$OperationStructDefinition, this.observable$Operation$ProcedureStructDefinition, this.observable$Operation$Procedure$ParameterStructDefinition));
        }

        @Override
        public Optional<EntityDefinition> entity(String name) {
            switch (name) {
                case "Place": {
                    return Optional.of(this.placeEntityDefinition);
                }
                case "Area": {
                    return Optional.of(this.areaEntityDefinition);
                }
                case "IncidentRule": {
                    return Optional.of(this.incidentRuleEntityDefinition);
                }
                case "Model": {
                    return Optional.of(this.modelEntityDefinition);
                }
                case "OrderType": {
                    return Optional.of(this.orderTypeEntityDefinition);
                }
                case "Observable": {
                    return Optional.of(this.observableEntityDefinition);
                }
                case "Person": {
                    return Optional.of(this.personEntityDefinition);
                }
                case "Process": {
                    return Optional.of(this.processEntityDefinition);
                }
                case "Asset": {
                    return Optional.of(this.assetEntityDefinition);
                }
                case "Part": {
                    return Optional.of(this.partEntityDefinition);
                }
                case "Hardware": {
                    return Optional.of(this.hardwareEntityDefinition);
                }
                case "Appliance": {
                    return Optional.of(this.applianceEntityDefinition);
                }
                case "Computer": {
                    return Optional.of(this.computerEntityDefinition);
                }
                case "Software": {
                    return Optional.of(this.softwareEntityDefinition);
                }
                case "Observer": {
                    return Optional.of(this.observerEntityDefinition);
                }
                case "Service": {
                    return Optional.of(this.serviceEntityDefinition);
                }
                case "Application": {
                    return Optional.of(this.applicationEntityDefinition);
                }
                case "JavaApplication": {
                    return Optional.of(this.javaApplicationEntityDefinition);
                }
            }
            return Optional.empty();
        }

        @Override
        public Optional<StructDefinition> struct(String name) {
            switch (name) {
                case "Model$Profile": {
                    return Optional.of(this.model$ProfileStructDefinition);
                }
                case "Model$Profile$Variable": {
                    return Optional.of(this.model$Profile$VariableStructDefinition);
                }
                case "Observable$Operation": {
                    return Optional.of(this.observable$OperationStructDefinition);
                }
                case "Observable$Operation$Procedure": {
                    return Optional.of(this.observable$Operation$ProcedureStructDefinition);
                }
                case "Observable$Operation$Procedure$Parameter": {
                    return Optional.of(this.observable$Operation$Procedure$ParameterStructDefinition);
                }
            }
            return Optional.empty();
        }

        private MasterDatamartDefinition datamart() {
            return this;
        }
    }

    private class TimelineNodeImpl
    implements MasterDatamart.TimelineNode {
        private final String id;
        private final String type;
        private final Set<String> sources;
        private volatile File file;
        private volatile TimelineFile timelineFile;
        private volatile SoftReference<Timeline> cache;
        private volatile MasterDatamart.TimelineNode.EventListener listener;
        private volatile boolean disposed;

        private TimelineNodeImpl(String id, String type, Set<String> sources) {
            this(id, type, sources, null);
        }

        private TimelineNodeImpl(String id, String type, Set<String> sources, File file) {
            this.id = Objects.requireNonNull(id);
            this.type = Objects.requireNonNull(type);
            this.sources = Objects.requireNonNull(sources);
            this.file = file;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public String type() {
            return this.type;
        }

        @Override
        public boolean exists() {
            return this.timelineFile() != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            TimelineNodeImpl timelineNodeImpl = this;
            synchronized (timelineNodeImpl) {
                if (this.disposed) {
                    return;
                }
                this.clearCache();
                this.listener = null;
                MasterDatamartImpl.this.timelines.remove(this.id + ":" + this.type);
                this.disposed = true;
            }
        }

        @Override
        public TimelineFile.TimeModel timeModel() {
            return this.timelineFile().timeModel();
        }

        @Override
        public TimelineFile.SensorModel sensorModel() {
            return this.timelineFile().sensorModel();
        }

        @Override
        public Instant first() {
            return this.timelineFile().first();
        }

        @Override
        public Instant last() {
            return this.timelineFile().last();
        }

        @Override
        public Timeline get() {
            TimelineNodeImpl timelineNodeImpl = this;
            synchronized (timelineNodeImpl) {
                if (this.disposed) {
                    throw new IllegalStateException("This " + this.getClass().getSimpleName() + " is disposed.");
                }
                try {
                    Timeline timeline;
                    if (this.cache != null && (timeline = this.cache.get()) != null) {
                        return timeline;
                    }
                    timeline = this.timelineFile().timeline();
                    this.cache = new SoftReference<Timeline>(timeline);
                    return timeline;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private TimelineFile timelineFile() {
            TimelineNodeImpl timelineNodeImpl = this;
            synchronized (timelineNodeImpl) {
                if (this.disposed) {
                    throw new IllegalStateException("This " + this.getClass().getSimpleName() + " is disposed.");
                }
                try {
                    if (this.timelineFile != null) {
                        return this.timelineFile;
                    }
                    this.timelineFile = !MasterDatamart.TimelineNode.AlwaysDownloadFromDatahub.get() && this.file != null && this.file.exists() ? this.loadFile() : this.downloadFromDatahub();
                    return this.timelineFile;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public void setEventListener(MasterDatamart.TimelineNode.EventListener listener) {
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyEvent(Event event) {
            TimelineNodeImpl timelineNodeImpl = this;
            synchronized (timelineNodeImpl) {
                if (this.disposed) {
                    return;
                }
                try {
                    if (!this.sources.contains(event.type())) {
                        return;
                    }
                    this.clearCache();
                    if (this.listener != null) {
                        this.listener.onEventReceived(this, event);
                    }
                }
                catch (Throwable e) {
                    Logger.error(e);
                }
            }
        }

        private void clearCache() {
            if (this.cache != null) {
                this.cache.enqueue();
                this.cache = null;
            }
            this.timelineFile = null;
            this.file = null;
        }

        private TimelineFile loadFile() throws Exception {
            return TimelineFile.open(this.file);
        }

        private TimelineFile downloadFromDatahub() throws Exception {
            Message response = MasterDatamartImpl.this.requestResponseFromDatahub("get-timeline=" + this.id(), this.request(MasterDatamart.TimelineNode.AlwaysDownloadFromDatahub.get() ? "download" : "path"));
            if (!response.getBooleanProperty("success")) {
                return null;
            }
            if (response instanceof TextMessage) {
                TextMessage textResponse = (TextMessage)response;
                this.file = this.getFile(textResponse);
                if (this.file != null && this.file.exists()) {
                    return this.loadFile();
                }
                this.file = null;
                response = MasterDatamartImpl.this.requestResponseFromDatahub("get-timeline=" + this.id(), this.request("download"));
            }
            if (!response.getBooleanProperty("success")) {
                return null;
            }
            return this.readFromBytes((BytesMessage)response);
        }

        private TimelineFile readFromBytes(BytesMessage m) throws Exception {
            int size = m.getIntProperty("size");
            byte[] bytes = new byte[size];
            m.readBytes(bytes, size);
            this.file = File.createTempFile(this.id(), ".timeline");
            Files.write(this.file.toPath(), bytes, StandardOpenOption.CREATE);
            this.file.deleteOnExit();
            return this.loadFile();
        }

        private File getFile(TextMessage m) {
            try {
                return new File(m.getText());
            }
            catch (Exception e) {
                return null;
            }
        }

        private Message request(String mode) throws Exception {
            ActiveMQTextMessage message = new ActiveMQTextMessage();
            String command = "datamart=" + MasterDatamartImpl.this.name() + ";operation=get-timeline;id=" + this.id() + ";mode=" + mode + ";type=" + this.type;
            message.setText(command);
            return message;
        }
    }

    private class ReelNodeImpl
    implements MasterDatamart.ReelNode {
        private final String id;
        private final String type;
        private final Set<String> sources;
        private volatile File file;
        private volatile ReelFile reelFile;
        private volatile MasterDatamart.ReelNode.EventListener listener;
        private volatile boolean disposed;

        private ReelNodeImpl(String id, String type, Set<String> sources) {
            this(id, type, sources, null);
        }

        private ReelNodeImpl(String id, String type, Set<String> sources, File file) {
            this.id = Objects.requireNonNull(id);
            this.type = Objects.requireNonNull(type);
            this.sources = Objects.requireNonNull(sources);
            this.file = file;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public String type() {
            return this.type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            ReelNodeImpl reelNodeImpl = this;
            synchronized (reelNodeImpl) {
                if (this.disposed) {
                    return;
                }
                this.clearCache();
                this.listener = null;
                MasterDatamartImpl.this.reels.remove(this.id + ":" + this.type);
                this.disposed = true;
            }
        }

        @Override
        public Reel.State stateOf(String signal) {
            ReelFile reelFile = this.reelFile();
            if (reelFile == null) {
                throw new IllegalArgumentException("Reel file not found");
            }
            return reelFile.stateOf(signal);
        }

        @Override
        public List<Reel.State> stateOf(Stream<String> signals) {
            ReelFile reelFile = this.reelFile();
            if (reelFile == null) {
                throw new IllegalArgumentException("Reel file not found");
            }
            return signals.map(reelFile::stateOf).toList();
        }

        @Override
        public Reel get(Period period) {
            ReelFile reelFile = this.reelFile();
            if (reelFile == null) {
                throw new IllegalArgumentException("Reel file not found");
            }
            return this.reelFile().reel().by(period);
        }

        @Override
        public Reel get(Instant from, Instant to, Period period) {
            ReelFile reelFile = this.reelFile();
            if (reelFile == null) {
                throw new IllegalArgumentException("Reel file not found");
            }
            return reelFile.reel(from, to).by(period);
        }

        @Override
        public boolean exists() {
            return this.reelFile() != null;
        }

        private ReelFile reelFile() {
            ReelNodeImpl reelNodeImpl = this;
            synchronized (reelNodeImpl) {
                if (this.disposed) {
                    throw new IllegalStateException("This " + this.getClass().getSimpleName() + " is disposed.");
                }
                try {
                    if (this.reelFile != null) {
                        return this.reelFile;
                    }
                    this.reelFile = this.file != null && this.file.exists() ? this.loadFile() : this.downloadFromDatahub();
                    return this.reelFile;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public void setEventListener(MasterDatamart.ReelNode.EventListener listener) {
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyEvent(Event event) {
            ReelNodeImpl reelNodeImpl = this;
            synchronized (reelNodeImpl) {
                if (this.disposed) {
                    return;
                }
                try {
                    if (!this.sources.contains(event.type())) {
                        return;
                    }
                    this.clearCache();
                    if (this.listener != null) {
                        this.listener.onEventReceived(this, event);
                    }
                }
                catch (Throwable e) {
                    Logger.error(e);
                }
            }
        }

        private void clearCache() {
            this.reelFile = null;
            this.file = null;
        }

        private ReelFile loadFile() throws Exception {
            return ReelFile.open(this.file);
        }

        private ReelFile downloadFromDatahub() throws Exception {
            Message response = MasterDatamartImpl.this.requestResponseFromDatahub("get-reel=" + this.id(), this.request("path"));
            if (!response.getBooleanProperty("success")) {
                return null;
            }
            if (response instanceof TextMessage) {
                TextMessage textResponse = (TextMessage)response;
                this.file = this.getFile(textResponse);
                if (this.file != null && this.file.exists()) {
                    return this.loadFile();
                }
                this.file = null;
                response = MasterDatamartImpl.this.requestResponseFromDatahub("get-reel=" + this.id(), this.request("download"));
            }
            if (!response.getBooleanProperty("success")) {
                return null;
            }
            return this.readFromBytes((BytesMessage)response);
        }

        private ReelFile readFromBytes(BytesMessage m) throws Exception {
            int size = m.getIntProperty("size");
            byte[] bytes = new byte[size];
            m.readBytes(bytes, size);
            this.file = File.createTempFile(this.id(), ".reel");
            Files.write(this.file.toPath(), bytes, StandardOpenOption.CREATE);
            this.file.deleteOnExit();
            return this.loadFile();
        }

        private File getFile(TextMessage m) {
            try {
                return new File(m.getText());
            }
            catch (Exception e) {
                return null;
            }
        }

        private Message request(String mode) throws Exception {
            ActiveMQTextMessage message = new ActiveMQTextMessage();
            String command = "datamart=" + MasterDatamartImpl.this.name() + ";operation=get-reel;id=" + this.id() + ";mode=" + mode + ";type=" + this.type;
            message.setText(command);
            return message;
        }
    }
}

