/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.terminal;

import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.datalake.file.FileDatalake;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.jms.ConnectionConfig;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.terminal.JmsConnector;
import io.intino.alexandria.terminal.remotedatalake.RemoteDatalake;
import io.intino.consul.terminal.ConsulService;
import io.intino.cosmos.datahub.ObserverTerminal;
import io.intino.cosmos.datahub.datamarts.master.MasterDatamart;
import io.intino.cosmos.datahub.messages.universe.ApplicationAssertion;
import io.intino.cosmos.datahub.messages.universe.ApplicationJavaAssertion;
import io.intino.cosmos.datahub.messages.universe.ComputerAssertion;
import io.intino.cosmos.datahub.messages.universe.ObserverAssertion;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import org.apache.activemq.Service;
import org.apache.activemq.command.ActiveMQTextMessage;

public class Terminal
implements Service {
    private final String cosulID;
    private final JmsConnector connector;
    private final Map<BiConsumer<?, String>, List<Consumer<Event>>> consumers = new HashMap();
    private final ObserverTerminal terminal;
    private ConsulService service;

    public Terminal(String consulID, ConnectionConfig config) {
        this.cosulID = consulID;
        this.connector = new JmsConnector(config, null);
        this.terminal = new ObserverTerminal(this.connector);
    }

    @Override
    public void start() {
        this.startConnector();
        String tanks = String.join((CharSequence)", ", this.quote(ComputerAssertion.class.getSimpleName()), this.quote(ObserverAssertion.class.getSimpleName()), this.quote(ApplicationAssertion.class.getSimpleName()), this.quote(ApplicationJavaAssertion.class.getSimpleName()));
        this.terminal.initDatamarts("ss LIKE '" + this.cosulID + "%' AND type IN (" + tanks + ")");
        this.service = new ConsulService(this.connector, this.connector.clientId());
    }

    private String quote(String simpleName) {
        return "'" + simpleName + "'";
    }

    public MasterDatamart master() {
        return this.terminal.datamart();
    }

    @Override
    public void stop() {
        this.connector.stop();
    }

    private void startConnector() {
        if (this.connector.connection() != null) {
            return;
        }
        if (this.connector.connection() == null) {
            this.connector.start();
        }
        while (this.connector.connection() == null) {
            try {
                Thread.sleep(30000L);
                this.connector.start();
            }
            catch (InterruptedException e) {
                Logger.error(e);
            }
        }
    }

    public ConsulService service() {
        return this.service;
    }

    public JmsConnector connector() {
        return this.connector;
    }

    public void publish(Event event) {
        this.terminal.publish(event);
    }

    public void publish(Event first, Event ... others) {
        this.terminal.publish(first, others);
    }

    public void publish(Event[] events) {
        this.terminal.publish(events);
    }

    public void publish(Collection<Event> events) {
        this.terminal.publish(events);
    }

    public void publish(Stream<Event> events) {
        this.terminal.publish(events);
    }

    public Datalake datalake() {
        try {
            javax.jms.Message message = this.connector.requestResponse("service.ness.datalake.eventstore", this.request("Datalake"), 5L, TimeUnit.SECONDS);
            if (message == null) {
                return null;
            }
            String path = ((TextMessage)message).getText();
            if (path == null) {
                return null;
            }
            return new File(path).exists() ? new FileDatalake(new File(path)) : new RemoteDatalake(this.connector);
        }
        catch (JMSException e) {
            Logger.error(e);
            return null;
        }
    }

    private javax.jms.Message request(String type) {
        return this.request(type, Collections.emptyMap());
    }

    private javax.jms.Message request(String type, Map<String, String> attributes) {
        try {
            ActiveMQTextMessage m = new ActiveMQTextMessage();
            Message message = new Message(type);
            attributes.forEach(message::set);
            m.setText(message.toString());
            return m;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

