/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.terminal;

import io.intino.alexandria.Json;
import io.intino.alexandria.jms.MessageWriter;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.terminal.Connector;
import io.intino.alexandria.terminal.JmsConnector;
import io.intino.consul.terminal.RequestAttendant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;

public class ConsulService {
    private final Connector connector;
    private final Map<String, RequestAttendant> attendants = new HashMap<String, RequestAttendant>();

    public ConsulService(Connector connector, String clientId) {
        this.connector = connector;
        this.createServiceConsumer("service.consul." + clientId + ".request", this::response);
    }

    public void register(String request, RequestAttendant attendant) {
        if (this.attendants.containsKey(request)) {
            Logger.error("Request Attendant already register: " + request);
        } else {
            this.attendants.put(request, attendant);
        }
    }

    public void unregister(String request) {
        this.attendants.remove(request);
    }

    private void response(Message m) {
        try {
            if (m.getBooleanProperty("availability")) {
                this.availabilityResponse(m);
            } else {
                RequestAttendant attendant = this.attendant(m);
                if (attendant == null) {
                    this.response(m.getJMSReplyTo(), this.message(m.getJMSCorrelationID(), "Bad Request: attendant not found"));
                } else {
                    this.response(m.getJMSReplyTo(), this.message(m.getJMSCorrelationID(), Json.toJson(attendant.responseTo(m))));
                }
            }
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
    }

    private void availabilityResponse(Message m) {
        try {
            String activity = m.getStringProperty("request");
            List<String> available = this.attendants.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(activity) && ((RequestAttendant)e.getValue()).isAvailable(m)).map(e -> ((RequestAttendant)e.getValue()).id()).toList();
            this.response(m.getJMSReplyTo(), this.message(m.getJMSCorrelationID(), Json.toJson(new RequestAttendant.RequestResult(true, available))));
        }
        catch (JMSException e2) {
            throw new RuntimeException(e2);
        }
    }

    private void response(Destination destination, Message message) {
        new Thread(() -> this.serviceResponse(destination, message)).start();
    }

    private Message message(String messageId, String response) {
        try {
            Message msg = MessageWriter.write(response);
            msg.setJMSCorrelationID(messageId);
            return msg;
        }
        catch (JMSException e) {
            Logger.error(e);
            return null;
        }
    }

    private RequestAttendant attendant(Message m) {
        try {
            return this.attendants.get(m.getStringProperty("request"));
        }
        catch (JMSException e) {
            Logger.error(e);
            return RequestAttendant.NullAttendant;
        }
    }

    private void serviceResponse(Destination destination, Message message) {
        try {
            MessageProducer producer = this.session().createProducer(destination);
            producer.send(message);
            producer.close();
        }
        catch (JMSException e) {
            Logger.error(e);
        }
    }

    private synchronized void createServiceConsumer(String path, MessageListener listener) {
        try {
            MessageConsumer serviceConsumer = this.session().createConsumer(this.session().createQueue(path), null, true);
            serviceConsumer.setMessageListener(listener);
        }
        catch (JMSException e) {
            Logger.error(e);
        }
    }

    public Session session() {
        return ((JmsConnector)this.connector).session();
    }
}

