/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.service.requests;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.Utils;
import io.intino.consul.container.box.actions.WindowsUpgradeCommand;
import io.intino.consul.container.box.service.requests.ContainerRequest;
import io.intino.consul.container.box.service.requests.UpgradeRequest;
import io.intino.consul.terminal.RequestAttendant;
import java.io.File;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.Message;

public class RestartConsulRequest
extends ContainerRequest {
    public static final String ID = "restart";

    @Override
    public String id() {
        return ID;
    }

    @Override
    public RequestAttendant.RequestResult responseTo(Message request) {
        Logger.info("Consul Restart requested");
        File jarFile = this.jarFile();
        String jarName = jarFile.getName().toLowerCase().replace(".jar", "");
        if (Utils.isWindows()) {
            try {
                File installDirectory = UpgradeRequest.installDirectory();
                WindowsUpgradeCommand.createScript(installDirectory, "upgrade.bat");
                RestartConsulRequest.runProcessDelayed(new ProcessBuilder(new String[0]).directory(installDirectory).command("net", "start", "consul-upgrade"));
            }
            catch (IOException e) {
                Logger.error(e);
            }
        } else if (Utils.isUnix()) {
            RestartConsulRequest.runProcessDelayed(new ProcessBuilder(new String[0]).command("systemctl", ID, jarName));
        }
        return new RequestAttendant.RequestResult(true, "Restarted consul");
    }

    @Override
    public boolean isAvailable(Message message) {
        return true;
    }

    private static void runProcessDelayed(final ProcessBuilder processBuilder) {
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    processBuilder.inheritIO().start();
                }
                catch (IOException e) {
                    Logger.error(e);
                }
            }
        }, 1000L);
    }

    private File jarFile() {
        return new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile().replace("%20", " "));
    }
}

