/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.service.requests;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.ContainerBox;
import io.intino.consul.container.box.ContainerStore;
import io.intino.consul.container.box.actions.ObserverAssertionAction;
import io.intino.consul.container.box.service.requests.ContainerRequest;
import io.intino.consul.framework.Activity;
import io.intino.consul.terminal.RequestAttendant;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;

public class InstallActivityRequest
extends ContainerRequest {
    public static final String ID = "installActivity";
    private final ContainerBox box;
    private final Activity.Context context;

    public InstallActivityRequest(ContainerBox box, Activity.Context context, ContainerStore store) {
        this.box = box;
        this.context = context;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public RequestAttendant.RequestResult responseTo(Message request) {
        BytesMessage message = (BytesMessage)request;
        try {
            String artifact = this.activity(request);
            if (this.box.activities().enabledActivities().contains(artifact)) {
                return new RequestAttendant.RequestResult(true, "Activity already enabled");
            }
            this.install(message, artifact);
            new Thread(() -> new ObserverAssertionAction(this.box, this.context).execute(), artifact + "-install").start();
            return new RequestAttendant.RequestResult(true, "Activity installed");
        }
        catch (JMSException e) {
            Logger.error(e);
            return new RequestAttendant.RequestResult(false, e.getMessage());
        }
    }

    @Override
    public boolean isAvailable(Message message) {
        return true;
    }

    private void install(BytesMessage message, String artifact) throws JMSException {
        byte[] payload = new byte[(int)message.getBodyLength()];
        message.readBytes(payload);
        this.box.activities().installActivity(artifact, payload);
    }
}

