/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.service.requests;

import io.intino.consul.container.box.ContainerBox;
import io.intino.consul.container.box.Utils;
import io.intino.consul.container.box.service.requests.ContainerRequest;
import io.intino.consul.terminal.RequestAttendant;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.jms.Message;

public class InfoRequest
extends ContainerRequest {
    public static final String ID = "info";
    private final ContainerBox box;

    public InfoRequest(ContainerBox box) {
        this.box = box;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public RequestAttendant.RequestResult responseTo(Message request) {
        RuntimeMXBean rb = ManagementFactory.getRuntimeMXBean();
        return new RequestAttendant.RequestResult(true, new Info(this.box.observer(), Utils.currentVersion(), Instant.now().minus(rb.getUptime(), ChronoUnit.MILLIS)));
    }

    @Override
    public boolean isAvailable(Message message) {
        return true;
    }

    public record Info(String host, String consulVersion, Instant startDate) {
    }
}

