/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.os.remote;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.os.remote.RemoteOperatingSystem;
import io.intino.consul.container.box.os.remote.RemoteProcessRunner;
import io.intino.consul.framework.Activity;
import java.io.File;
import java.util.List;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.ProcPath;

public class RemoteSystem
implements Activity.System {
    private final Session session;
    private final RemoteOperatingSystem operatingSystem;

    public RemoteSystem(String privateKey, String remoteServer, String remotePort, String remoteUser) throws Exception {
        this.session = this.createSession(privateKey, remoteServer, remotePort, remoteUser);
        this.operatingSystem = new RemoteOperatingSystem(this.session);
        Logger.info("Connected to remote system!");
    }

    @Override
    public String name() {
        try {
            return new RemoteProcessRunner(this.session).execute("hostname");
        }
        catch (Exception e) {
            Logger.error(e);
            return "consul-default-server";
        }
    }

    @Override
    public Activity.System.OperatingSystem operatingSystem() {
        return this.operatingSystem;
    }

    @Override
    public Activity.System.HDD hdd() {
        return null;
    }

    @Override
    public Activity.System.RAM ram() {
        return null;
    }

    @Override
    public Activity.System.CPU cpu() {
        return null;
    }

    @Override
    public Activity.System.Network network() {
        return null;
    }

    public long getBootTime() {
        List<String> procStat = FileUtil.readFile(ProcPath.STAT);
        for (String stat : procStat) {
            if (!stat.startsWith("btime")) continue;
            String[] bTime = ParseUtil.whitespaces.split(stat);
            return ParseUtil.parseLongOrDefault(bTime[1], 0L);
        }
        return 0L;
    }

    protected Session createSession(String privateKey, String remoteServer, String remotePort, String remoteUser) throws JSchException {
        JSch jSch = new JSch();
        jSch.addIdentity(privateKey);
        jSch.setKnownHosts(new File(new File(privateKey).getAbsoluteFile(), "known_hosts").getAbsolutePath());
        Session session = jSch.getSession(remoteUser, remoteServer, Integer.parseInt(remotePort));
        session.setConfig("StrictHostKeyChecking", "no");
        session.setServerAliveInterval(30000);
        session.setConfig("PreferredAuthentications", "publickey,password");
        session.connect(30000);
        return session;
    }
}

