/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.actions;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.ContainerBox;
import io.intino.consul.container.model.Info;
import io.intino.consul.framework.Activity;
import io.intino.cosmos.datahub.messages.monitoring.Status;
import io.intino.cosmos.datahub.messages.universe.ComputerAssertion;
import java.io.BufferedReader;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Objects;

public class ComputerAssertionAction {
    public ContainerBox box;
    private Activity.Context context;

    public void execute() {
        this.context = this.box.context();
        ComputerAssertion newInfo = this.computerInfo();
        Info last = this.last();
        if (!this.hasChanges(last, newInfo)) {
            return;
        }
        if (this.context.terminal() != null) {
            this.sleep(1000);
            this.context.terminal().publish(newInfo);
        }
        if (last == null && this.context.terminal() != null) {
            this.context.terminal().publish(this.status(List.of("line")));
        }
        this.box.store().put("info", this.map(newInfo));
    }

    private Status status(List<String> signals) {
        return new Status(this.context.observer()).observable(this.context.hostName()).group("line").signals(signals);
    }

    private boolean hasChanges(Info last, ComputerAssertion newInfo) {
        return last == null || last.diskSize() != newInfo.diskSize().longValue() || last.memorySize() != newInfo.memorySize().longValue() || last.maxOpenFiles() != newInfo.maxOpenFiles().longValue() || !last.localIps().equals(newInfo.ip()) || !last.publicIp().equals(newInfo.publicIp()) || !Objects.equals(newInfo.jvm(), last.jvm());
    }

    private Info last() {
        return this.box.store().get("info", Info.class);
    }

    private void sleep(int i) {
        try {
            Thread.sleep(i);
        }
        catch (InterruptedException e) {
            Logger.error(e);
        }
    }

    private Info map(ComputerAssertion newInfo) {
        return new Info(newInfo.ip(), newInfo.publicIp(), newInfo.cores(), newInfo.diskSize(), newInfo.memorySize(), newInfo.maxOpenFiles(), newInfo.jvm());
    }

    private ComputerAssertion computerInfo() {
        Activity.System system = this.context.system();
        return (ComputerAssertion)new ComputerAssertion(this.context.observer() + "." + system.name(), system.name()).ts(Instant.now()).isp(system.network().ISP()).os(System.getProperty("os.name")).maxOpenFiles(system.hdd().maxOpenFiles()).cores(system.cpu().cores()).diskSize(system.hdd().capacityMB()).memorySize(system.ram().capacityMB()).architecture(System.getProperty("os.arch")).jvm(this.findInstalledJVM()).publicIp(system.network().publicIP()).ip(List.of(system.network().localIP())).observer(this.box.observer());
    }

    private String findInstalledJVM() {
        try {
            Process java = new ProcessBuilder("java", "--version").start();
            Thread.sleep(1000L);
            BufferedReader reader = java.inputReader();
            List<String> lines = reader.lines().toList();
            reader.close();
            if (!lines.isEmpty()) {
                return lines.get(0);
            }
        }
        catch (IOException | InterruptedException e) {
            Logger.error(e);
        }
        return null;
    }
}

