/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.scheduler.AlexandriaScheduler;
import io.intino.consul.container.box.ContainerBox;
import io.intino.consul.container.box.scheduling.ComputerAssertionListener;
import io.intino.consul.container.box.scheduling.SaveStoreListener;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class Sentinels {
    private Sentinels() {
    }

    public static void init(AlexandriaScheduler scheduler, File home, ContainerBox box) {
        try {
            JobDetail job = JobBuilder.newJob(ComputerAssertionListener.class).withIdentity("computerAssertion").build();
            job.getJobDataMap().put("box", (Object)box);
            scheduler.scheduleJob(job, Sentinels.newSet(TriggerBuilder.newTrigger().withIdentity("Box#computerAssertion").withSchedule(CronScheduleBuilder.cronSchedule("0 0/15 * 1/1 * ? *")).build(), TriggerBuilder.newTrigger().startNow().build()), true);
            job = JobBuilder.newJob(SaveStoreListener.class).withIdentity("saveStore").build();
            job.getJobDataMap().put("box", (Object)box);
            scheduler.scheduleJob(job, Sentinels.newSet(TriggerBuilder.newTrigger().withIdentity("Box#saveStore").withSchedule(CronScheduleBuilder.cronSchedule("0 0/15 * 1/1 * ? *")).build()), true);
            scheduler.startSchedules();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
        }
    }

    private static Set<Trigger> newSet(Trigger ... triggers) {
        LinkedHashSet<Trigger> set = new LinkedHashSet<Trigger>();
        Collections.addAll(set, triggers);
        return set;
    }
}

