/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.logger.Formatter;
import io.intino.alexandria.scheduler.AlexandriaScheduler;
import io.intino.consul.container.box.ContainerBox;
import io.intino.consul.container.box.ContainerConfiguration;
import io.intino.consul.container.box.Sentinels;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractBox
extends Box {
    protected ContainerConfiguration configuration;
    private AlexandriaScheduler scheduler = new AlexandriaScheduler();

    public AbstractBox(String[] args) {
        this(new ContainerConfiguration(args));
    }

    public AbstractBox(ContainerConfiguration configuration) {
        this.configuration = configuration;
        this.initJavaLogger();
    }

    @Override
    public ContainerConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public Box put(Object o) {
        return this;
    }

    @Override
    public abstract void beforeStart();

    @Override
    public Box start() {
        this.initConnector();
        if (this.owner != null) {
            this.owner.beforeStart();
        }
        this.beforeStart();
        if (this.owner != null) {
            this.owner.startServices();
        }
        this.startServices();
        if (this.owner != null) {
            this.owner.afterStart();
        }
        this.afterStart();
        return this;
    }

    @Override
    public abstract void afterStart();

    @Override
    public abstract void beforeStop();

    @Override
    public void stop() {
        if (this.owner != null) {
            this.owner.beforeStop();
        }
        this.beforeStop();
        if (this.owner != null) {
            this.owner.stopServices();
        }
        this.stopServices();
        if (this.owner != null) {
            this.owner.afterStop();
        }
        this.afterStop();
    }

    @Override
    public void stopServices() {
    }

    @Override
    public abstract void afterStop();

    @Override
    public void startServices() {
        this.initUI();
        this.initRestServices();
        this.initSoapServices();
        this.initJmxServices();
        this.initDatalake();
        this.initTerminal();
        this.initMessagingServices();
        this.initSentinels();
        this.initSlackBots();
        this.initWorkflow();
        this.initAgenda();
        this.initCli();
    }

    public AlexandriaScheduler scheduler() {
        return this.scheduler;
    }

    private void initRestServices() {
    }

    private void initSoapServices() {
    }

    private void initMessagingServices() {
    }

    private void initJmxServices() {
    }

    private void initSlackBots() {
    }

    private void initUI() {
    }

    private void initDatalake() {
    }

    private void initConnector() {
    }

    private void initTerminal() {
    }

    private void initSentinels() {
        Sentinels.init(this.scheduler, this.configuration.home(), (ContainerBox)this);
    }

    private void initWorkflow() {
    }

    private void initAgenda() {
    }

    private void initCli() {
    }

    protected void initJavaLogger() {
        Logger Logger2 = Logger.getGlobal();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.INFO);
        handler.setFormatter(new Formatter());
        Logger2.setUseParentHandlers(false);
        Logger2.addHandler(handler);
    }

    protected URL url(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

