/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.zit.model;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Objects;

public class Period {
    private static final Map<String, ChronoUnit> Units = Period.units();
    public final int amount;
    public final ChronoUnit unit;

    public static Period of(int amount, ChronoUnit unit) {
        return new Period(amount, unit);
    }

    public static Period of(short amount, short chronoUnit) {
        return new Period(amount, ChronoUnit.values()[chronoUnit]);
    }

    public static Period of(String data) {
        return Period.parse(data.toUpperCase().toCharArray());
    }

    public Period(int amount, ChronoUnit unit) {
        this.amount = amount;
        this.unit = unit;
    }

    private static Period parse(char[] chars) {
        int amount = Period.amountIn(chars);
        ChronoUnit unit = Units.getOrDefault(Period.unitIn(chars), ChronoUnit.DAYS);
        return new Period(amount, unit);
    }

    private static String unitIn(char[] chars) {
        StringBuilder unit = new StringBuilder();
        for (char c : chars) {
            if (c < 'A' || c > 'Z') continue;
            unit.append(c);
        }
        String s = unit.toString();
        return s.endsWith("S") ? Period.singular(s) : s;
    }

    private static int amountIn(char[] chars) {
        int amount = 0;
        for (char c : chars) {
            if (c < '0' || c > '9') break;
            amount = amount * 10 + (c - 48);
        }
        return amount == 0 ? 1 : amount;
    }

    public String toString() {
        return this.amount + " " + this.toString(this.unit.toString().toLowerCase());
    }

    private String toString(String unit) {
        return this.amount == 1 ? Period.singular(unit) : unit;
    }

    private static String singular(String unit) {
        return unit.substring(0, unit.length() - 1);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this == o || this.equals((Period)o);
    }

    private boolean equals(Period period) {
        return this.amount == period.amount && this.unit == period.unit;
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.unit);
    }

    public Instant next(Instant instant) {
        return instant.plus((long)this.amount, this.unit);
    }

    public long duration() {
        return (long)this.amount * this.unit.getDuration().toSeconds();
    }

    private static Map<String, ChronoUnit> units() {
        return Map.of("SECOND", ChronoUnit.SECONDS, "MINUTE", ChronoUnit.MINUTES, "HOUR", ChronoUnit.HOURS, "DAY", ChronoUnit.DAYS, "WEEK", ChronoUnit.WEEKS, "MONTH", ChronoUnit.MONTHS, "YEAR", ChronoUnit.YEARS);
    }
}

