/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.event.resource;

import io.intino.alexandria.event.EventWriter;
import io.intino.alexandria.event.resource.ResourceEvent;
import io.intino.alexandria.event.resource.ResourceHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;

public class ResourceEventWriter
implements EventWriter<ResourceEvent> {
    private final File file;

    public ResourceEventWriter(File file) {
        this.file = file;
    }

    @Override
    public void write(ResourceEvent event) throws IOException {
        URI uri = URI.create("jar:" + this.file.toPath().toUri());
        String entryName = event.getREI().resourceId().replace("/", "$");
        String entryMetadataName = event.getREI().resourceId().replace("/", "$") + ".metadata";
        String metadata = ResourceHelper.serializeMetadata(event, this.file);
        try (FileSystem fs = FileSystems.newFileSystem(uri, Map.of("create", "true"));
             InputStream data = event.resource().stream();){
            Path nf = fs.getPath(entryName, new String[0]);
            Files.write(nf, data.readAllBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            nf = fs.getPath(entryMetadataName, new String[0]);
            Files.writeString(nf, (CharSequence)metadata, StandardOpenOption.CREATE);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
    }
}

