/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.lang.model.rules.variable;

import io.intino.magritte.lang.model.Primitive;
import io.intino.magritte.lang.model.rules.variable.VariableRule;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class NativeRule
implements VariableRule<Primitive.Expression> {
    private String interfaceClass;
    private String signature;
    private List<String> imports = new ArrayList<String>();

    public NativeRule(String interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    public NativeRule(String interfaceClass, String signature) {
        this.interfaceClass = interfaceClass;
        this.signature = signature;
    }

    public NativeRule(String interfaceClass, String signature, List<String> imports) {
        this.interfaceClass = interfaceClass;
        this.signature = signature;
        this.imports.addAll(imports);
    }

    @Override
    public boolean accept(Primitive.Expression value) {
        return true;
    }

    public String signature() {
        return this.signature;
    }

    public String interfaceClass() {
        return this.interfaceClass;
    }

    public void interfaceClass(String interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    public void signature(String signature) {
        this.signature = signature;
    }

    public List<String> imports() {
        return new ArrayList<String>(this.imports);
    }

    public void imports(List<String> imports) {
        this.imports.addAll(imports.stream().filter(s -> !s.isEmpty() && !this.imports.contains(s)).collect(Collectors.toList()));
    }

    public String toString() {
        return "NativeRule{" + this.interfaceClass + "}";
    }
}

