/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.framework;

import io.intino.magritte.framework.Graph;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Model;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.NodeLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class NodeCloner {
    private final List<Node> nodes;
    private final Node node;
    private final Graph model;
    private final Map<String, Node> cloneMap = new HashMap<String, Node>();
    private final NodeLoader loader = this.cloneMap::get;
    private String stash;

    private NodeCloner(List<Node> nodes, Node node, Graph model) {
        this.nodes = nodes;
        this.node = node;
        this.model = model;
    }

    private NodeCloner(List<Node> nodes, Model m1, String stash, Graph model) {
        this.nodes = nodes;
        this.node = m1;
        this.stash = stash;
        this.model = model;
    }

    static void clone(List<Node> toClone, Node node, Graph model) {
        if (toClone.isEmpty()) {
            return;
        }
        new NodeCloner(toClone, node, model).execute();
    }

    static void clone(List<Node> toClone, Model m1, String stash, Graph model) {
        if (toClone.isEmpty()) {
            return;
        }
        new NodeCloner(toClone, m1, stash, model).execute();
    }

    private void execute() {
        this.model.loaders.add(this.loader);
        this.nodes.stream().map(toClone -> this.clone(this.cloneId((Node)toClone), (Node)toClone, this.node)).forEach(this.node::add);
        this.nodes.forEach(this::copyVariables);
        this.model.loaders.remove(this.loader);
    }

    private String cloneId(Node toClone) {
        return this.node instanceof Model ? this.stash + "#" + toClone.name() : this.node.id() + "." + toClone.name();
    }

    private void copyVariables(Node original) {
        this.copyVariables(original, this.cloneMap.get(original.id()));
        original.componentList().forEach(this::copyVariables);
    }

    private Node clone(String name, Node toClone, Node owner) {
        Node clone = new Node(name);
        clone.owner(owner);
        toClone.typeNames.forEach(n -> clone.addLayer(this.model.concept$((String)n)));
        clone.syncLayers();
        this.cloneComponents(toClone, clone, name);
        this.register(toClone, clone);
        return clone;
    }

    private void register(Node toClone, Node clone) {
        this.cloneMap.put(toClone.id, clone);
        this.model.register(clone);
    }

    private void cloneComponents(Node toClone, Node clone, String name) {
        toClone.layers.forEach(origin -> {
            Layer destination = this.getLayerFrom(clone, (Layer)origin);
            toClone.componentList().forEach(c -> destination.addNode$(this.clone(name + "." + c.name(), (Node)c, clone)));
        });
    }

    private void copyVariables(Node toClone, Node clone) {
        toClone.layers.forEach(origin -> {
            Layer destination = this.getLayerFrom(clone, (Layer)origin);
            origin.variables$().entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty()).forEach(e -> destination.set$((String)e.getKey(), (List)e.getValue()));
        });
    }

    private Layer getLayerFrom(Node clone, Layer origin) {
        return clone.layers.stream().filter(l -> l.getClass() == origin.getClass()).findFirst().get();
    }
}

